#include <curses.h>
#include <libguile.h>
#include <libruin.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

void atexit_handler() {
  raise (SIGTRAP);
}

int real_main(int argc, char *argv[]) {
  ruin_window_t *w = NULL;
  FILE *log = NULL;

  if (argc < 3) {
    printf("%s: Usage: %s [filename] xul|xhtml\n", argv[0], argv[0]);
    return 1;
  }

  atexit(atexit_handler);

  initscr();
  start_color();
  cbreak();
  noecho();

  ruin_init();
  
  { char *logfilename = calloc(sizeof(char), strlen(argv[0]) + 5);
    snprintf(logfilename, strlen(argv[0]) + 5, "%s.log", argv[0]);
    log = fopen(logfilename, "w");
    free(logfilename);
  }

  w = ruin_window_new(stdscr, log);
  if (strcmp(argv[2], "xul") == 0)
    ruin_draw_file(w, argv[1], RUIN_XML_DIALECT_XUL);
  else if (strcmp(argv[2], "xhtml") == 0)
    ruin_draw_file(w, argv[1], RUIN_XML_DIALECT_XHTML);
  else {
    printf("Invalid XML dialect specification.\n");
    return 1;
  }

  { int ch;
    while (ch = getch())
    ruin_input_send(w, ch);
  } 
 
  pause();

  getch();
  endwin();

  return 0;
}

int main(int argc, char *argv[]) {
  /* scm_boot_guile(argc, argv, (void (*) ()) real_main, NULL); */
  scm_init_guile();
  real_main(argc, argv);
  return 0;
}
