/* win-fns.c: Window-management functions for the libRUIN Scheme API
 * Copyright (C) 2005 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include <libguile.h>

#include "../layout.h"
#include "../util.h"
#include "../window.h"
#include "win-fns.h"

extern ruin_windows_t *_ruin_windows;

SCM ruin_scm_api_window_focus_next(SCM id) {
  ruin_window_t *w = (ruin_window_t *) ruin_util_string_to_ptr
    (ruin_util_hash_retrieve
     (_ruin_windows->windows, 
      SCM_STRING_CHARS(scm_number_to_string(id, SCM_MAKINUM(10)))));
  int tab_length = ruin_util_list_length(w->tab_order);
  int i;
  for (i = 0; i < tab_length; i++) {
    if (w->focused == (ruin_element_t *) 
	ruin_util_string_to_ptr(ruin_util_list_peek_after(w->tab_order, i))) {
      ruin_element_t *old_focus = w->focused;
      if (i == tab_length - 1) 
	w->focused = (ruin_element_t *) 
	  ruin_util_string_to_ptr(ruin_util_list_peek_after(w->tab_order, 0));
      else w->focused = (ruin_element_t *) ruin_util_string_to_ptr
	     (ruin_util_list_peek_after(w->tab_order, i + 1));
      if (old_focus != w->focused) {
	/* Now we need to queue some more events. */

	ruin_util_log_current("dispatching event sdom:event-dom-focus-out on "
			      "element '%s'\n", old_focus->id);
	scm_call_4(scm_c_eval_string("sdom:dispatch-event"),
		   old_focus->element, 
		   scm_str2symbol("sdom:event-dom-focus-out"), 
		   SCM_EOL, SCM_EOL);

	ruin_util_log_current("dispatching event sdom:event-dom-focus-in on "
			      "element '%s'\n", w->focused->id);
	scm_call_4(scm_c_eval_string("sdom:dispatch-event"),
		   w->focused->element, 
		   scm_str2symbol("sdom:event-dom-focus-in"), 
		   SCM_EOL, SCM_EOL);
	return SCM_BOOL_T;
      }
    }
  }

  /* Otherwise, the currently-focused element was not in the list -- this can
     happen if there are no focusable elements and thus the document window
     has been assigned the focus. */

  { char *focusable = ruin_util_list_peek_after(w->tab_order, 0);
    if (focusable != NULL) {
      ruin_element_t *old_focus = w->focused;
      w->focused = (ruin_element_t *) ruin_util_string_to_ptr(focusable);

      ruin_util_log_current("dispatching event sdom:event-dom-focus-out on "
			    "element '%s'\n", old_focus->id);
      scm_call_4(scm_c_eval_string("sdom:dispatch-event"),
		 old_focus->element, 
		 scm_str2symbol("sdom:event-dom-focus-out"), SCM_EOL, SCM_EOL);
      ruin_util_log_current("dispatching event sdom:event-dom-focus-in on "
			    "element '%s'\n", w->focused->id);
      scm_call_4(scm_c_eval_string("sdom:dispatch-event"),
		 w->focused->element, 
		 scm_str2symbol("sdom:event-dom-focus-in"), SCM_EOL, SCM_EOL);
    }
  }
  return SCM_BOOL_F;
}
