/* focus.c: Default focus event handlers for libRUIN
 * Copyright (C) 2005 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include <libguile.h>

#include "../api/win-fns.h"
#include "focus.h"

SCM ruin_scm_default_handler_tab(SCM event) {
  SCM key = scm_call_2(scm_c_eval_string("sdom:get-event-property"), event,
		       scm_makfrom0str("sdom:key-identifier"));

  if (scm_equal_p(key, scm_makfrom0str("sdom:key-u+0009")) == SCM_BOOL_T)
    return ruin_scm_api_window_focus_next
      (scm_c_eval_string("ruin:current-window"));
  return SCM_BOOL_F;
}

SCM ruin_scm_default_handler_focus_toggle(SCM event) {
  SCM target = scm_call_2(scm_c_eval_string("sdom:get-event-property"),
			  event, scm_makfrom0str("sdom:target"));
  SCM attr_name = scm_makfrom0str("color");
  SCM attr_ns = scm_makfrom0str("http://www.w3.org/TR/CSS21");
  SCM attr_value = scm_call_3(scm_c_eval_string("sdom:get-attribute"),
			      target, attr_name, attr_ns);

  if (attr_value == SCM_EOL) {

    /* This can happen if the property is inherited from a stylesheet in the
       cascade. Until we resolve the problems with the cascade, we'll set this
       to the default manually. */

    attr_value = scm_makfrom0str("silver");
  }

  scm_call_4(scm_c_eval_string("sdom:set-attribute!"), target, attr_name, 
	     scm_call_1(scm_c_eval_string("ruin:invert-foreground-color"), 
			attr_value), attr_ns);

  attr_name = scm_makfrom0str("background-color");
  attr_value = scm_call_3(scm_c_eval_string("sdom:get-attribute"),
			  target, attr_name, attr_ns);

  if (attr_value == SCM_EOL) {
    attr_value = scm_makfrom0str("black");
  }

  scm_call_4(scm_c_eval_string("sdom:set-attribute!"), target, attr_name, 
	     scm_call_1(scm_c_eval_string("ruin:invert-background-color"), 
			attr_value), attr_ns);
  return SCM_BOOL_T;
}
