/* modify.c: Default modification event handlers for libRUIN
 * Copyright (C) 2005 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include <libguile.h>
#include <ncurses.h>

#include "modify.h"
#include "../layout.h"
#include "../render.h"
#include "../window.h"

SCM ruin_scm_default_handler_attr_modified(SCM event) {
  SCM target = scm_call_2(scm_c_eval_string("sdom:get-event-property"),
			  event, scm_makfrom0str("sdom:target"));
  ruin_window_t *win = ruin_window_lookup_scm(target);
  char *ptr_str =
    SCM_STRING_CHARS(scm_hashq_ref(win->scm_hash, target, SCM_EOL));
  ruin_element_t *tree = (ruin_element_t *) ruin_util_string_to_ptr(ptr_str);
  ruin_util_list *l = ruin_util_list_new();

  ruin_generate_tree_parse_attrs(tree);
  /* ruin_css_apply(tree); */

  /* Do we need to re-check the sizes? */

  ruin_render_render_tree(win->top, l);
  ruin_util_list_free(l);
  refresh();
  return SCM_BOOL_T;
}
