/* dialect.h: Prototypes and declarations for dialect.c
 * Copyright (C) 2005 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef RUIN_DIALECT_H
#define RUIN_DIALECT_H

#include <libguile.h>

#include "layout.h"

SCM ruin_dialect_parse_in_document_style(SCM, SCM);
ruin_element_t *ruin_dialect_add_table_nodes(ruin_element_t *);
void ruin_dialect_update_tab_position(ruin_element_t *, int);
char *ruin_dialect_get_node_name(SCM node);
ruin_element_t *ruin_dialect_generate_text_node(SCM node, 
						ruin_element_t *,
						ruin_element_t *);

#endif
