/* focus.c: Default focus event handlers for libRUIN
 * Copyright (C) 2006 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include "focus.h"

#include <curses.h>
#include <libguile.h>

#include "../api/attr-fns.h"
#include "../api/css-fns.h"
#include "../api/win-fns.h"
#include "../render.h"
#include "../util.h"

SCM ruin_scm_default_handler_tab(SCM event) {
  SCM key = scm_call_2(scm_c_eval_string("sdom:get-event-property"), event,
		       scm_makfrom0str("sdom:key-identifier"));
  
  if (scm_equal_p(key, scm_makfrom0str("sdom:key-u+0009")) == SCM_BOOL_T)
    return ruin_scm_api_window_focus_next
      (scm_call_2(scm_c_eval_string("sdom:get-event-property"), event,
		  scm_makfrom0str("sdom:target")));
  return SCM_BOOL_F;
}

SCM ruin_scm_default_handler_focus_toggle(SCM event) {
  ruin_util_list *inh = ruin_util_list_new();
  SCM target = scm_call_2(scm_c_eval_string("sdom:get-event-property"),
			  event, scm_makfrom0str("sdom:target"));

  SCM colorp = scm_mem2string("color", 5);
  SCM bgcolorp = scm_mem2string("background-color", 16);

  SCM color = ruin_scm_api_css_get_style(target, colorp);
  SCM bgcolor = ruin_scm_api_css_get_style(target, bgcolorp);

  color = ruin_scm_attribute_invert_foreground_color(color);
  bgcolor = ruin_scm_attribute_invert_background_color(bgcolor);

  ruin_scm_api_css_set_style_x(target, colorp, color);
  ruin_scm_api_css_set_style_x(target, bgcolorp, bgcolor);

  ruin_render_render_tree
    (ruin_window_lookup_scm(target)->parent_window->top, inh);

  ruin_util_list_free(inh);
  refresh();
  return SCM_BOOL_T;
}
