/* handlers.c: Function exports for libRUIN default event handlers
 * Copyright (C) 2006 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include <libguile.h>

#include "handlers.h"
#include "focus.h"
#include "modify.h"

void _ruin_scm_init_handlers() {
  scm_c_define_gsubr
    ("ruin:default-tab-handler", 1, 0, 0, ruin_scm_default_handler_tab);
  scm_c_define_gsubr("ruin:default-focus-toggle-handler", 1, 0, 0, 
		     ruin_scm_default_handler_focus_toggle);

  scm_c_define_gsubr("ruin:default-attr-modified-handler", 1, 0, 0,
		     ruin_scm_default_handler_attr_modified);
  scm_c_define_gsubr("ruin:default-node-insertion-handler", 1, 0, 0,
		     ruin_scm_default_handler_dom_node_inserted);
  scm_c_define_gsubr("ruin:default-node-removal-handler", 1, 0, 0,
		     ruin_scm_default_handler_dom_node_removed);
  return;
}
