/* api.c: Export directives for the libRUIN Scheme API
 * Copyright (C) 2006 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include <libguile.h>

#include "api.h"
#include "attr-fns.h"
#include "css-fns.h"
#include "node-fns.h"
#include "win-fns.h"

void _ruin_scm_init_api() {

  /* Set up the attribute-handling functions... */
  
  scm_c_define_gsubr("ruin:invert-foreground-color", 1, 0, 0,
		     ruin_scm_attribute_invert_foreground_color);
  scm_c_define_gsubr("ruin:invert-background-color", 1, 0, 0,
		     ruin_scm_attribute_invert_background_color);
  
  /* Set up the node-handling functions... */

  scm_c_define_gsubr("ruin:scss-pseudo-element-handler", 3, 0, 0,
		     ruin_scm_api_node_pseudo_element_handler);
  scm_c_define_gsubr("ruin:scss-pseudo-class-handler", 3, 0, 0,
		     ruin_scm_api_node_pseudo_class_handler);

  scm_c_define_gsubr("ruin:get-style", 2, 0, 0, ruin_scm_api_css_get_style);
  scm_c_define_gsubr("ruin:set-style!", 3, 0, 0, ruin_scm_api_css_set_style_x);

  /* Set up the window-handling functions... */

  scm_c_define_gsubr("ruin:render", 1, 0, 0, ruin_scm_api_window_render);
  scm_c_define_gsubr("ruin:focus-next", 1, 0, 0, 
		     ruin_scm_api_window_focus_next);
  scm_c_define_gsubr("ruin:focus-prev", 1, 0, 0, 
		     ruin_scm_api_window_focus_prev);
  scm_c_define_gsubr("ruin:focus", 1, 0, 0, ruin_scm_api_window_focus);
}
