/* render.h: Prototypes and declarations for render.c
 * Copyright (C) 2005 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef RUIN_RENDER_H
#define RUIN_RENDER_H

#include <curses.h>
#include <libguile.h>

#include "layout.h"
#include "util.h"
#include "window.h"

enum _ruin_render_border_char {
  RUIN_RENDER_BORDER_ULCORNER, RUIN_RENDER_BORDER_URCORNER,
  RUIN_RENDER_BORDER_LLCORNER, RUIN_RENDER_BORDER_LRCORNER,
  RUIN_RENDER_BORDER_HLINE, RUIN_RENDER_BORDER_VLINE, RUIN_RENDER_BORDER_LTEE,
  RUIN_RENDER_BORDER_RTEE, RUIN_RENDER_BORDER_TTEE, RUIN_RENDER_BORDER_BTEE
};

typedef struct _ruin_render_box_t {
  int top;
  int left;
  int bottom;
  int right;
} ruin_render_box_t;

void ruin_render_render_tree(ruin_element_t *, ruin_util_list *);
void ruin_render_compute_sizes(ruin_element_t *, int, int);
int ruin_render_get_words(char *, char ***, int **);

#endif
