/* window.h: Prototypes and declarations for window.c
 * Copyright (C) 2006 Julian Graham
 *
 * libRUIN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libRUIN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libRUIN; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef RUIN_WINDOW_H
#define RUIN_WINDOW_H

#include <curses.h>
#include <libguile.h>
#include <signal.h>
#include <stdio.h>

#include "layout.h"
#include "util.h"

#define RUIN_WINDOW_SCM_HASH_SIZE	256

#define RUIN_WINDOW_DEFAULT_FONT_HEIGHT 16
#define RUIN_WINDOW_DEFAULT_FONT_WIDTH   8
#define RUIN_WINDOW_DEFAULT_DPI         96

struct _ruin_window_t {
  WINDOW *window;
  FILE *log;

  int font_height;
  int font_width;
  int dpi;

  long internal_id;

  struct _ruin_util_hash *ids;
  struct _ruin_util_hash *internal_ids;
  SCM scm_hash;

  struct _ruin_util_list *tab_order;
  struct _ruin_util_list *current_pseudo_elements;

  struct _ruin_element_t *focused;
  struct _ruin_element_t *top;

  short render_requested;
};

typedef struct _ruin_windows_t {
  struct _ruin_util_hash *windows;
  SCM xul_agent_css;
  SCM xhtml_agent_css;
} ruin_windows_t;

ruin_window_t *ruin_window_new(WINDOW *, FILE *);
void ruin_window_clear(ruin_window_t *);
void ruin_window_free(ruin_window_t *);

ruin_windows_t *ruin_windows_new();
void ruin_windows_free(ruin_windows_t *);

struct _ruin_element_t *ruin_window_lookup_scm(SCM elt);

/* Because I'm a moron and can't figure out how else to prototype this... */
void ruin_util_log(ruin_window_t *, char *, ...);

void ruin_window_signal_handler_SIGWINCH(int, siginfo_t *, void *);

#endif
