#include <curses.h>
#include <libguile.h>
#include <libruin.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#if HAVE_LIBCURL

#include <curl/curl.h>

static CURL *_curl = NULL; 

typedef struct {
  int size;
  char *memory;
} mem_struct;

static size_t write_callback(void *ptr, size_t s, size_t nmemb, void *data) {
  size_t realsize = s * nmemb;
  mem_struct *mem = (mem_struct *) data;
  mem->memory = (char *) realloc(mem->memory, mem->size + realsize + 1);
  if (mem->memory) {
    memcpy(&(mem->memory[mem->size]), ptr, realsize);
    mem->size += realsize;
    mem->memory[mem->size] = 0;
  }
  return realsize;
}

char *retrieve_url(char *url) {
  CURLcode res;

  mem_struct chunk;
  chunk.memory = NULL;
  chunk.size = 0; 
  
  _curl = curl_easy_init();

  curl_easy_setopt(_curl, CURLOPT_URL, url);
  curl_easy_setopt(_curl, CURLOPT_WRITEFUNCTION, write_callback); 
  curl_easy_setopt(_curl, CURLOPT_WRITEDATA, (void *) &chunk);
  res = curl_easy_perform(_curl);
  return chunk.memory;
}

#endif /* HAVE_LIBCURL */

int real_main(int argc, char *argv[]) {
  ruin_window_t *w = NULL;
  FILE *log = NULL;
  int i = 1;

  if (argc < 2) {
    printf("%s: Usage: %s [filename] [filename] ...", argv[0], argv[0]);
    return 1;
  }

  initscr();
  start_color();
  cbreak();
  noecho();

  ruin_init();
  
  { char *logfilename = calloc(sizeof(char), strlen(argv[0]) + 5);
    snprintf(logfilename, strlen(argv[0]) + 5, "%s.log", argv[0]);
    log = fopen(logfilename, "w");
    free(logfilename);
  }

  w = ruin_window_new(stdscr, log);

#if HAVE_LIBCURL
  curl_global_init(0);
  _curl = curl_easy_init();
#endif

  for (; i < argc; i++) {
    int ch;
    
    fprintf(log, "rendering %s\n", argv[i]);

#if HAVE_LIBCURL
    ruin_draw_string(w, retrieve_url(argv[i]));
#else
    ruin_draw_file(w, argv[i]);
#endif
    while (ch = getch()) {
      if (ch == 'n') break;
      else ruin_input_send(w, ch);
    }
  } 

  getch();
  endwin();

  return 0;
}

int main(int argc, char *argv[]) {
  /*  setenv("GUILE_MIN_YIELD_1", "100", 1);
      setenv("GUILE_MIN_YIELD_2", "100", 1); */

  SCM debug_enable = SCM_EOL;

  scm_init_guile();
  debug_enable = scm_c_eval_string("debug-enable");

  scm_call_1(debug_enable, scm_from_locale_symbol("backtrace"));

  real_main(argc, argv);
  return 0;
}
