/* css-fns.c: Style-management functions for the libRUIN Scheme API
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <libguile.h>
#include <string.h>

#include "../css.h"
#include "../layout.h"
#include "../parse.h"
#include "../scheme.h"
#include "../util.h"
#include "../window.h"

SCM_DEFINE (ruin_scm_api_css_get_style, "ruin:get-style", 2, 0, 0, 
	    (SCM node, SCM property), "Get the style for a node.")
{
  ruin_node_t *n = ruin_window_lookup_scm(node);
  if (n != NULL) 
    {
      char *style = NULL;
      style = ruin_css_lookup (NULL, n, scm_to_locale_string (property));
      return scm_from_locale_string (style);
    }
  return SCM_EOL;
}

SCM_DEFINE (ruin_scm_api_css_set_style_x, "ruin:set-style!", 3, 0, 0, 
	    (SCM node, SCM property, SCM value), "Set the style for a node.")
{
  ruin_node_t *n = ruin_window_lookup_scm (node);
  if (n != NULL) 
    {
      ruin_layout_add_style
	(&((ruin_node_element_t *) n)->additional_attribute_style,
	 scm_to_locale_string (property), 
	 scm_to_locale_string (value));
    }
  return SCM_EOL;
}

void _ruin_scm_css_init_api (void)
{
  #include "css-fns.x"
}
