/* focus.c: Default focus event handlers for libRUIN
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <curses.h>
#include <glib.h>
#include <libguile.h>

#include "../render.h"
#include "../util.h"

/* TODO: Replace references to these functions with calls to C versions. */

extern SCM ruin_scm_api_window_focus_next (SCM);
extern SCM ruin_scm_api_css_get_style (SCM, SCM);
extern SCM ruin_scm_api_css_set_style_x (SCM, SCM, SCM);
extern SCM ruin_scm_attribute_invert_foreground_color (SCM);
extern SCM ruin_scm_attribute_invert_background_color (SCM);

SCM_DEFINE (ruin_scm_default_handler_tab, "ruin:default-tab-handler", 1, 0, 0, 
	    (SCM event), "Default tab handler.")
{
  SCM key = scm_call_2
    (scm_c_eval_string ("sdom:get-event-property"), event,
     scm_from_locale_string ("sdom:key-identifier"));
  
  if (scm_equal_p(key, scm_from_locale_string ("sdom:key-u+0009")) 
      == SCM_BOOL_T)
    return ruin_scm_api_window_focus_next
      (scm_call_2 (scm_c_eval_string ("sdom:get-event-property"), event,
		   scm_from_locale_string ("sdom:target")));
  return SCM_BOOL_F;
}

SCM_DEFINE (ruin_scm_default_handler_focus_toggle, 
	    "ruin:default-focus-toggle-handler", 1, 0, 0, (SCM event), 
	    "Default focus toggle handler.")
{
  SCM target = scm_call_2 
    (scm_c_eval_string ("sdom:get-event-property"), event, 
     scm_from_locale_string ("sdom:target"));

  SCM colorp = scm_from_locale_string ("color");
  SCM bgcolorp = scm_from_locale_string ("background-color");

  SCM color = ruin_scm_api_css_get_style (target, colorp);
  SCM bgcolor = ruin_scm_api_css_get_style (target, bgcolorp);

  ruin_window_t *w = ruin_window_lookup_window (target);

  color = ruin_scm_attribute_invert_foreground_color (color);
  bgcolor = ruin_scm_attribute_invert_background_color (bgcolor);

  ruin_scm_api_css_set_style_x (target, colorp, color);
  ruin_scm_api_css_set_style_x (target, bgcolorp, bgcolor);

  ruin_render_render_tree ((ruin_box_t *) g_list_nth_data (w->root_boxes, 0));

  refresh ();
  return SCM_BOOL_T;
}

void _ruin_scm_focus_handlers_init (void)
{
  #include "focus.x"
}
