/* input.h: Prototypes and declarations for input.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RUIN_INPUT_H
#define RUIN_INPUT_H

#include "window.h"

enum ruin_key_identifier {
  RUIN_KEY_ACCEPT, RUIN_KEY_AGAIN, RUIN_KEY_ALL_CANDIDATES, 
  RUIN_KEY_ALPHANUMERIC, RUIN_KEY_ALT, RUIN_KEY_ALT_GRAPH, RUIN_KEY_APPS, 
  RUIN_KEY_ATTN, RUIN_KEY_BROWSER_BACK, RUIN_KEY_BROWSER_FAVORITES, 
  RUIN_KEY_BROWSER_FORWARD, RUIN_KEY_BROWSER_HOME, RUIN_KEY_BROWSER_REFRESH, 
  RUIN_KEY_BROWSER_SEARCH, RUIN_KEY_BROWSER_STOP, RUIN_KEY_CAPS_LOCK, 
  RUIN_KEY_CLEAR, RUIN_KEY_CODE_INPUT, RUIN_KEY_COMPOSE, RUIN_KEY_CRSEL, 
  RUIN_KEY_CONVERT, RUIN_KEY_COPY, RUIN_KEY_CUT, RUIN_KEY_DOWN, RUIN_KEY_END, 
  RUIN_KEY_ENTER, RUIN_KEY_ERASE_EOF, RUIN_KEY_EXECUTE, RUIN_KEY_EXSEL,
  RUIN_KEY_F1, RUIN_KEY_F2, RUIN_KEY_F3, RUIN_KEY_F4, RUIN_KEY_F5, RUIN_KEY_F6,
  RUIN_KEY_F7, RUIN_KEY_F8, RUIN_KEY_F9, RUIN_KEY_F10, RUIN_KEY_F11, 
  RUIN_KEY_F12, RUIN_KEY_F13, RUIN_KEY_F14, RUIN_KEY_F15, RUIN_KEY_F16, 
  RUIN_KEY_F17, RUIN_KEY_F18, RUIN_KEY_F19, RUIN_KEY_F20, RUIN_KEY_F21, 
  RUIN_KEY_F22, RUIN_KEY_F23, RUIN_KEY_F24, RUIN_KEY_FINAL_MODE, RUIN_KEY_FIND,
  RUIN_KEY_FULL_WIDTH, RUIN_KEY_HALF_WIDTH, RUIN_KEY_HANGUL_MODE, 
  RUIN_KEY_HANJA_MODE, RUIN_KEY_HELP, RUIN_KEY_HIRAGANA, RUIN_KEY_HOME, 
  RUIN_KEY_INSERT, RUIN_KEY_JAPANESE_HIRAGANA, RUIN_KEY_JAPANESE_KATAKANA, 
  RUIN_KEY_JAPANESE_ROMAJI, RUIN_KEY_JUNJA_MODE, RUIN_KEY_KANA_MODE, 
  RUIN_KEY_KANJI_MODE, RUIN_KEY_KATAKANA, RUIN_KEY_LAUNCH_APPLICATION_1, 
  RUIN_KEY_LAUNCH_APPLICATION_2, RUIN_KEY_LAUNCH_MAIL, RUIN_KEY_LEFT, 
  RUIN_KEY_META, RUIN_KEY_MEDIA_NEXT_TRACK, RUIN_KEY_MEDIA_PLAY_PAUSE,
  RUIN_KEY_MEDIA_PREVIOUS_TRACK, RUIN_KEY_MEDIA_STOP, RUIN_KEY_MODE_CHANGE,
  RUIN_KEY_NONCONVERT, RUIN_KEY_NUM_LOCK, RUIN_KEY_PAGE_DOWN, RUIN_KEY_PAGE_UP,
  RUIN_KEY_PASTE, RUIN_KEY_PAUSE, RUIN_KEY_PLAY, RUIN_KEY_PREVIOUS_CANDIDATE,
  RUIN_KEY_PRINT_SCREEN, RUIN_KEY_PROCESS, RUIN_KEY_PROPS, RUIN_KEY_RIGHT, 
  RUIN_KEY_ROMAN_CHARACTERS, RUIN_KEY_SCROLL, RUIN_KEY_SELECT, 
  RUIN_KEY_SELECT_MEDIA, RUIN_KEY_SHIFT, RUIN_KEY_STOP, RUIN_KEY_UP, 
  RUIN_KEY_UNDO, RUIN_KEY_VOLUME_DOWN, RUIN_KEY_VOLUME_MUTE, 
  RUIN_KEY_VOLUME_UP, RUIN_KEY_WIN, RUIN_KEY_ZOOM,

  RUIN_KEY_U_0008, RUIN_KEY_U_0009, RUIN_KEY_U_0018, RUIN_KEY_U_001B, 
  RUIN_KEY_U_0020, RUIN_KEY_U_0021, RUIN_KEY_U_0022, RUIN_KEY_U_0023, 
  RUIN_KEY_U_0024, RUIN_KEY_U_0025, RUIN_KEY_U_0026, RUIN_KEY_U_0027, 
  RUIN_KEY_U_0028, RUIN_KEY_U_0029, RUIN_KEY_U_002A, RUIN_KEY_U_002B, 
  RUIN_KEY_U_002C, RUIN_KEY_U_002D, RUIN_KEY_U_002E, RUIN_KEY_U_002F, 
  RUIN_KEY_U_0030, RUIN_KEY_U_0031, RUIN_KEY_U_0032, RUIN_KEY_U_0033, 
  RUIN_KEY_U_0034, RUIN_KEY_U_0035, RUIN_KEY_U_0036, RUIN_KEY_U_0037, 
  RUIN_KEY_U_0038, RUIN_KEY_U_0039, RUIN_KEY_U_003A, RUIN_KEY_U_003B, 
  RUIN_KEY_U_003C, RUIN_KEY_U_003D, RUIN_KEY_U_003E, RUIN_KEY_U_003F, 
  RUIN_KEY_U_0040, RUIN_KEY_U_0041, RUIN_KEY_U_0042, RUIN_KEY_U_0043, 
  RUIN_KEY_U_0044, RUIN_KEY_U_0045, RUIN_KEY_U_0046, RUIN_KEY_U_0047, 
  RUIN_KEY_U_0048, RUIN_KEY_U_0049, RUIN_KEY_U_004A, RUIN_KEY_U_004B, 
  RUIN_KEY_U_004C, RUIN_KEY_U_004D, RUIN_KEY_U_004E, RUIN_KEY_U_004F, 
  RUIN_KEY_U_0050, RUIN_KEY_U_0051, RUIN_KEY_U_0052, RUIN_KEY_U_0053, 
  RUIN_KEY_U_0054, RUIN_KEY_U_0055, RUIN_KEY_U_0056, RUIN_KEY_U_0057, 
  RUIN_KEY_U_0058, RUIN_KEY_U_0059, RUIN_KEY_U_005A, RUIN_KEY_U_005B, 
  RUIN_KEY_U_005C, RUIN_KEY_U_005D, RUIN_KEY_U_005E, RUIN_KEY_U_005F, 
  RUIN_KEY_U_0060, RUIN_KEY_U_007B, RUIN_KEY_U_007C, RUIN_KEY_U_007D, 
  RUIN_KEY_U_007F, RUIN_KEY_U_00A1, RUIN_KEY_U_0300, RUIN_KEY_U_0301, 
  RUIN_KEY_U_0302, RUIN_KEY_U_0303, RUIN_KEY_U_0304, RUIN_KEY_U_0305, 
  RUIN_KEY_U_0306, RUIN_KEY_U_0307, RUIN_KEY_U_0308, RUIN_KEY_U_030A, 
  RUIN_KEY_U_030B, RUIN_KEY_U_030C, RUIN_KEY_U_0327, RUIN_KEY_U_0328, 
  RUIN_KEY_U_0345, RUIN_KEY_U_20AC, RUIN_KEY_U_3099, RUIN_KEY_U_309A,

  RUIN_KEY_UNDEFINED
};

enum ruin_key_identifier _ruin_input_char_to_key_identifier(int ch);
SCM _ruin_input_key_identifier_to_string(enum ruin_key_identifier k);
void ruin_input_send(ruin_window_t *, int);

#endif
