/* layout.h: Prototypes and declarations for layout.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RUIN_LAYOUT_H
#define RUIN_LAYOUT_H

#include <glib.h>
#include <libguile.h>

#include "box.h"
#include "parse.h"
#include "util.h"
#include "window.h"

#define RUIN_LAYOUT_VALUE_INHERIT	-2
#define RUIN_LAYOUT_VALUE_NONE          -3

enum ruin_layout_border_style {
  RUIN_LAYOUT_BORDER_STYLE_NONE, RUIN_LAYOUT_BORDER_STYLE_SOLID, 
  RUIN_LAYOUT_BORDER_STYLE_DOUBLE, RUIN_LAYOUT_BORDER_STYLE_DASHED
};

enum ruin_layout_orientation {
  RUIN_LAYOUT_ORIENT_VERTICAL, RUIN_LAYOUT_ORIENT_HORIZONTAL
};

enum ruin_layout_horizontal_alignment {
  RUIN_LAYOUT_HORIZONTAL_ALIGNMENT_LEFT, 
  RUIN_LAYOUT_HORIZONTAL_ALIGNMENT_CENTER,
  RUIN_LAYOUT_HORIZONTAL_ALIGNMENT_RIGHT
};

enum ruin_layout_vertical_alignment {
  RUIN_LAYOUT_VERTICAL_ALIGNMENT_TOP, RUIN_LAYOUT_VERTICAL_ALIGNMENT_CENTER,
  RUIN_LAYOUT_VERTICAL_ALIGNMENT_BOTTOM
};

enum ruin_layout_crop_side {
  RUIN_LAYOUT_CROP_SIDE_NONE, RUIN_LAYOUT_CROP_SIDE_START, 
  RUIN_LAYOUT_CROP_SIDE_END, RUIN_LAYOUT_CROP_SIDE_BOTH
};

enum ruin_extra_content {
  RUIN_LAYOUT_EXTRA_CONTENT_NONE, RUIN_LAYOUT_EXTRA_CONTENT_CHECKBOX,
  RUIN_LAYOUT_EXTRA_CONTENT_RADIO, RUIN_LAYOUT_EXTRA_CONTENT_COLORPICKER
};

enum ruin_layout_foreground_color {
  RUIN_LAYOUT_FG_COLOR_BLACK = 0, RUIN_LAYOUT_FG_COLOR_RED, 
  RUIN_LAYOUT_FG_COLOR_GREEN, RUIN_LAYOUT_FG_COLOR_YELLOW, 
  RUIN_LAYOUT_FG_COLOR_BLUE, RUIN_LAYOUT_FG_COLOR_MAGENTA, 
  RUIN_LAYOUT_FG_COLOR_CYAN, RUIN_LAYOUT_FG_COLOR_WHITE, 
  RUIN_LAYOUT_FG_COLOR_BR_BLACK, RUIN_LAYOUT_FG_COLOR_BR_RED, 
  RUIN_LAYOUT_FG_COLOR_BR_GREEN, RUIN_LAYOUT_FG_COLOR_BR_YELLOW, 
  RUIN_LAYOUT_FG_COLOR_BR_BLUE, RUIN_LAYOUT_FG_COLOR_BR_MAGENTA, 
  RUIN_LAYOUT_FG_COLOR_BR_CYAN, RUIN_LAYOUT_FG_COLOR_BR_WHITE
};

enum ruin_layout_background_color {
  RUIN_LAYOUT_BG_COLOR_BLACK = 0, RUIN_LAYOUT_BG_COLOR_RED, 
  RUIN_LAYOUT_BG_COLOR_GREEN, RUIN_LAYOUT_BG_COLOR_YELLOW, 
  RUIN_LAYOUT_BG_COLOR_BLUE, RUIN_LAYOUT_BG_COLOR_MAGENTA, 
  RUIN_LAYOUT_BG_COLOR_CYAN, RUIN_LAYOUT_BG_COLOR_WHITE
};

enum ruin_layout_editable_type {
  RUIN_LAYOUT_EDITABLE_TYPE_NONE, RUIN_LAYOUT_EDITABLE_TYPE_SINGLE_LINE,
  RUIN_LAYOUT_EDITABLE_TYPE_MULTI_LINE
};

enum ruin_layout_display {
  RUIN_LAYOUT_DISPLAY_BLOCK = 0x1, RUIN_LAYOUT_DISPLAY_INLINE_BLOCK = 0x2,
  RUIN_LAYOUT_DISPLAY_INLINE = 0x4, RUIN_LAYOUT_DISPLAY_LIST_ITEM = 0x8,
  RUIN_LAYOUT_DISPLAY_NONE = 0x10, RUIN_LAYOUT_DISPLAY_RUN_IN = 0x20, 
  RUIN_LAYOUT_DISPLAY_TABLE = 0x40, RUIN_LAYOUT_DISPLAY_INLINE_TABLE = 0x80,
  RUIN_LAYOUT_DISPLAY_TABLE_ROW_GROUP = 0x100, 
  RUIN_LAYOUT_DISPLAY_TABLE_COLUMN = 0x200,
  RUIN_LAYOUT_DISPLAY_TABLE_COLUMN_GROUP = 0x400, 
  RUIN_LAYOUT_DISPLAY_TABLE_HEADER_GROUP = 0x800, 
  RUIN_LAYOUT_DISPLAY_TABLE_FOOTER_GROUP = 0x1000,
  RUIN_LAYOUT_DISPLAY_TABLE_ROW = 0x2000, 
  RUIN_LAYOUT_DISPLAY_TABLE_CELL = 0x4000,
  RUIN_LAYOUT_DISPLAY_TABLE_CAPTION = 0x8000
};

enum ruin_layout_direction {
  RUIN_LAYOUT_DIRECTION_LTR, RUIN_LAYOUT_DIRECTION_RTL
};

typedef struct _ruin_word_t {
  int raw_len;
  char *word;
} ruin_word_t;

typedef struct _ruin_layout_size_t {
  int height;
  int width;
} ruin_layout_size_t;

typedef struct _ruin_layout_line_state_t {
  short is_first;
  short is_last;
  char last_char;
  
  ruin_inline_box_t *last_break_opportunity;
  char *last_break_opportunity_ptr;
} ruin_layout_line_state_t;

ruin_layout_size_t *ruin_layout_size_new(int, int);
void ruin_layout_size_free(ruin_layout_size_t *t);

void ruin_layout_add_style(SCM *, char *, char *);
void ruin_layout_normalize_lengths(ruin_box_t *, int);

void ruin_layout_layout_elements (GList *);
GList *ruin_layout_generate_and_layout_elements 
(ruin_window_t *, ruin_node_t *);

#endif /* RUIN_LAYOUT_H */

