/* libruin.h: Main exports for libRUIN
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBRUIN_H
#define LIBRUIN_H

#include <curses.h>
#include <libguile.h>
#include <stdio.h>

typedef struct _ruin_window_t ruin_window_t;

int ruin_init ();

int ruin_draw (ruin_window_t *, SCM);
int ruin_draw_string (ruin_window_t *, char *);
int ruin_draw_file (ruin_window_t *, char *);

ruin_window_t *ruin_window_new (WINDOW *, FILE *);
void ruin_window_free (ruin_window_t *);

ruin_window_t *ruin_get_current_window ();
void ruin_set_current_window (ruin_window_t *);

void ruin_input_send (ruin_window_t *, int);

void ruin_shutdown ();

#endif
