/* parse.h: Prototypes and declarations for parse.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RUIN_PARSE_H
#define RUIN_PARSE_H

#include <glib.h>
#include <libguile.h>

#include "window.h"
#include "xml.h"

enum ruin_parse_node_type
  {
    RUIN_PARSE_NODE_TYPE_ELEMENT,
    RUIN_PARSE_NODE_TYPE_PROTOTYPE,
    RUIN_PARSE_NODE_TYPE_TEXT
  };

typedef struct _ruin_node_t {
  enum ruin_parse_node_type type;

  struct _ruin_node_t *parent;
  
  SCM doc;
  SCM node;

  GList *children;
  struct _ruin_node_t *first_child;
  struct _ruin_node_t *next_sibling;

} ruin_node_t;

typedef struct _ruin_node_element_t {
  ruin_node_t node;

  SCM inherent_attribute_style;
  SCM additional_attribute_style;

  GHashTable *style_cache;
  GHashTable *first_letter_style_cache;
  GHashTable *first_line_style_cache;
  GHashTable *before_style_cache;
  GHashTable *after_style_cache;

} ruin_node_element_t;

typedef struct _ruin_node_prototype_t {
  ruin_node_t node;

  GHashTable *properties;

} ruin_node_prototype_t;

typedef struct _ruin_node_text_t {
  ruin_node_t node;

  char *content;

} ruin_node_text_t;

void ruin_parse_init ();

ruin_node_element_t *ruin_node_element_new (SCM, SCM, ruin_node_t *);
ruin_node_text_t *ruin_node_text_new (SCM, SCM, ruin_node_t *);
ruin_node_prototype_t *ruin_node_prototype_new (GHashTable *);

void ruin_node_free (struct _ruin_node_t *);
ruin_node_t *ruin_parse_document (ruin_window_t *, SCM);
ruin_node_t *ruin_parse_get_node_by_scm (SCM);
enum ruin_xml_dialect ruin_parse_determine_dialect (ruin_window_t *, SCM);

#endif /* RUIN_PARSE_H */

