/* render.h: Prototypes and declarations for render.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RUIN_RENDER_H
#define RUIN_RENDER_H

#include <curses.h>
#include <libguile.h>

#include "layout.h"
#include "util.h"
#include "window.h"

enum _ruin_render_border_char 
  {
    RUIN_RENDER_BORDER_ULCORNER, 
    RUIN_RENDER_BORDER_URCORNER,
    RUIN_RENDER_BORDER_LLCORNER, 
    RUIN_RENDER_BORDER_LRCORNER,
    RUIN_RENDER_BORDER_HLINE, 
    RUIN_RENDER_BORDER_VLINE, 
    RUIN_RENDER_BORDER_LTEE,
    RUIN_RENDER_BORDER_RTEE, 
    RUIN_RENDER_BORDER_TTEE, 
    RUIN_RENDER_BORDER_BTEE
  };

enum _ruin_render_text_decoration
  {
    RUIN_RENDER_TEXT_DECORATION_UNDERLINE = 0x1,
    RUIN_RENDER_TEXT_DECORATION_OVERLINE = 0x2,
    RUIN_RENDER_TEXT_DECORATION_LINE_THROUGH = 0x4,
    RUIN_RENDER_TEXT_DECORATION_BLINK = 0x8
  };

void ruin_render_render_tree(ruin_box_t *);

int ruin_render_get_words(char *, char ***, int **);

#endif /* RUIN_RENDER_H */
