/* scheme.h: Prototypes and declarations for scheme.c
 * Copyright (C) 2011 Julian Graham
 *
 * libRUIN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RUIN_SCHEME_H
#define RUIN_SCHEME_H

#include <libguile.h>

#include "layout.h"
#include "window.h"

SCM ruin_scheme_scss_document_interface_sdom;

SCM ruin_scheme_scss_color_to_hex (ruin_window_t *, char *);
void ruin_scheme_scss_set_cascade_author (ruin_window_t *, SCM, SCM);
SCM ruin_scheme_scss_cascade_author (ruin_window_t *, SCM);
void ruin_scheme_scss_set_cascade_agent (ruin_window_t *, SCM, SCM);
int ruin_scheme_scss_is_inherited (ruin_window_t *, char *);
char *ruin_scheme_scss_get_default_value (ruin_window_t *, char *);
SCM ruin_scheme_scss_make_cascade (ruin_window_t *);
SCM ruin_scheme_scss_css_to_scss (ruin_window_t *, char *, char *);
SCM ruin_scheme_scss_css_to_scss_port (ruin_window_t *, SCM, char *);
SCM ruin_scheme_scss_make_rendering_interface (ruin_window_t *, SCM, SCM);
SCM ruin_scheme_scss_make_selection_context (ruin_window_t *, SCM, SCM, SCM);
int ruin_scheme_scss_selected_value_important_p (ruin_window_t *, SCM);
char *ruin_scheme_scss_selected_value_property (ruin_window_t *, SCM);
char *ruin_scheme_scss_selected_value_source (ruin_window_t *, SCM);
char *ruin_scheme_scss_selected_value_value (ruin_window_t *, SCM);
SCM ruin_scheme_scss_select_values (ruin_window_t *, SCM, SCM);
char *ruin_scheme_scss_specify (ruin_window_t *, char *, char *);

void ruin_scheme_sdom_add_event_listener 
(ruin_window_t *, SCM, char *, char *, char *);
SCM ruin_scheme_sdom_attributes (ruin_window_t *, SCM);
SCM ruin_scheme_sdom_create_document (ruin_window_t *, char *, SCM);
SCM ruin_scheme_sdom_create_document_type (ruin_window_t *, char *);
SCM ruin_scheme_sdom_create_element (ruin_window_t *, SCM, char *);
SCM ruin_scheme_sdom_create_text_node (ruin_window_t *, SCM, char *);
void ruin_scheme_sdom_append_child (ruin_window_t *, SCM, SCM);
void ruin_scheme_sdom_dispatch_event (ruin_window_t *, SCM, char *);
SCM ruin_scheme_sdom_document_element (ruin_window_t *, SCM);
int ruin_scheme_sdom_document_p (ruin_window_t *, SCM);
SCM ruin_scheme_sdom_doctype (ruin_window_t *, SCM);
char *ruin_scheme_sdom_document_uri (ruin_window_t *, SCM);
int ruin_scheme_sdom_element_p (ruin_window_t *, SCM);
SCM ruin_scheme_sdom_first_child (ruin_window_t *, SCM);
char *ruin_scheme_sdom_get_attribute (ruin_window_t *, SCM, char *);
void ruin_scheme_sdom_set_attribute (ruin_window_t *, SCM, char *, char *);
char *ruin_scheme_sdom_name (ruin_window_t *, SCM);
SCM ruin_scheme_sdom_next_sibling (ruin_window_t *, SCM);
char *ruin_scheme_sdom_node_name (ruin_window_t *, SCM);
char *ruin_scheme_sdom_node_value (ruin_window_t *, SCM);
SCM ruin_scheme_sdom_owner_document (ruin_window_t *, SCM);
SCM ruin_scheme_sdom_parent_node (ruin_window_t *, SCM);
char *ruin_scheme_sdom_text_content (ruin_window_t *, SCM);
int ruin_scheme_sdom_text_node_p (ruin_window_t *, SCM);
char *ruin_scheme_sdom_value (ruin_window_t *, SCM);
SCM ruin_scheme_sdom_xml_to_sdom (ruin_window_t *, SCM, SCM);

SCM ruin_scheme_sdom_node_type_attr;
SCM ruin_scheme_sdom_node_type_element;
SCM ruin_scheme_sdom_node_type_document;
SCM ruin_scheme_sdom_node_type_processing_instruction;
SCM ruin_scheme_sdom_node_type_text;

void ruin_scheme_init();

#if SCM_MAJOR_VERSION == 1 && SCM_MINOR_VERSION < 8
#define scm_from_int32 scm_int2num
#define scm_to_locale_string(x) strdup(SCM_STRING_CHARS(x))
#endif

#endif /* RUIN_SCHEME_H */
