;; sdom.scm: document interface implementation for SDOM
;; Copyright (C) 2011 Julian Graham

;; SCSS is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

#!r6rs

(library (scss interface sdom)
  (export scss:document-interface-sdom)
  (import (rnrs base) (sdom core) (scss scss))

  (define scss:document-interface-sdom
    (scss:make-document-interface
     sdom:tag-name
     
     ;; This parent function checks the result of `sdom:parent-node' to make
     ;; sure it's an element - a document's document element will have the
     ;; document as its parent, and no selection operations can be performed
     ;; against that.

     (lambda (node) 
       (let ((p (sdom:parent-node node))) (and (sdom:element? p) p)))
     
     sdom:previous-sibling
     sdom:get-attribute

     (lambda (node) (sdom:get-attribute node "class"))
     (lambda (node) (sdom:get-attribute node "id"))))
)

  