#include <glib.h>
#include <ncurses.h>
#include <stdio.h>
#include <stdlib.h>

#include "../box.h"
#include "../css.h"
#include "../load.h"
#include "../parse.h"
#include "../scheme.h"
#include "../window.h"
#include "util.h"

void test_generation_list_item_ordinals_simple
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;
  int i = 0;

  g_assert_cmpint (1, ==, g_list_length (boxes));
  
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  
  boxes = box->children;
  g_assert_cmpint (6, ==, g_list_length (boxes));

  for (i = 0; i < 3; i++)
    {
      box = (ruin_box_t *) boxes->data;
      g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_MARKER);

      ruin_marker_box_t *marker = (ruin_marker_box_t *) box;      
      g_assert_cmpint (marker->ordinal, ==, i);
      g_assert_cmpint (marker->length, ==, 3);

      boxes = boxes->next;

      box = (ruin_box_t *) boxes->data;
      g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);

      boxes = boxes->next;
    }
}

void test_generation_list_item_ordinals_continuity
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;
  int i = 0;

  g_assert_cmpint (1, ==, g_list_length (boxes));
  
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  
  boxes = box->children;
  g_assert_cmpint (7, ==, g_list_length (boxes));
  
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_MARKER);

  ruin_marker_box_t *marker = (ruin_marker_box_t *) box;      
  g_assert_cmpint (marker->ordinal, ==, 0);
  g_assert_cmpint (marker->length, ==, 1);

  boxes = boxes->next;

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);

  boxes = boxes->next;  

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);

  boxes = boxes->next;  

  for (i = 0; i < 2; i++)
    {
      box = (ruin_box_t *) boxes->data;
      g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_MARKER);

      ruin_marker_box_t *marker = (ruin_marker_box_t *) box;      
      g_assert_cmpint (marker->ordinal, ==, i);
      g_assert_cmpint (marker->length, ==, 2);

      boxes = boxes->next;

      box = (ruin_box_t *) boxes->data;
      g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);

      boxes = boxes->next;
    }
}

int main (int argc, char *argv[])
{
  int ret = 0;
  FILE *dev_null = fopen ("/dev/null", "w+");
  
  GHashTable *style_block = g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_list_item_outside = 
    g_hash_table_new (g_str_hash, g_str_equal);
  
  g_test_init (&argc, &argv, NULL);

  newterm (NULL, dev_null, stdin);
  scm_init_guile ();
  ruin_init ();

  g_hash_table_insert (style_block, "display", "block");
  g_hash_table_insert (style_list_item_outside, "display", "list-item");
  g_hash_table_insert 
    (style_list_item_outside, "list-style-position", "outside");

  { box_generation_fixture_component_t *block =
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new (style_block, NULL);
    GList *list_items = 
      g_list_append
      (g_list_append
       (g_list_append 
	(g_list_append
	 (NULL, block), 
	 box_generation_element_fixture_component_new
	 (style_list_item_outside, block)),
	box_generation_element_fixture_component_new 
	(style_list_item_outside, block)),
       box_generation_element_fixture_component_new 
       (style_list_item_outside, block));

    g_test_add 
      ("/box/generation/list-item/ordinals/simple", 
       box_generation_fixture, list_items, setup_box_generation_fixture, 
       test_generation_list_item_ordinals_simple, 
       teardown_box_generation_fixture);
  }

  { box_generation_fixture_component_t *block =
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new (style_block, NULL);
    GList *list_items = 
      g_list_append
      (g_list_append
       (g_list_append
	(g_list_append 
	 (g_list_append
	  (NULL, block), 
	  box_generation_element_fixture_component_new
	  (style_list_item_outside, block)),
	 box_generation_element_fixture_component_new
	 (style_block, block)),
	box_generation_element_fixture_component_new 
	(style_list_item_outside, block)),
       box_generation_element_fixture_component_new 
       (style_list_item_outside, block));

    g_test_add 
      ("/box/generation/list-item/ordinals/continuity", 
       box_generation_fixture, list_items, setup_box_generation_fixture, 
       test_generation_list_item_ordinals_continuity, 
       teardown_box_generation_fixture);
  }

  ret = g_test_run ();

  endwin ();
  fclose (dev_null);

  return ret;
}
