#include <glib.h>
#include <ncurses.h>
#include <stdio.h>
#include <stdlib.h>

#include "../box.h"
#include "../css.h"
#include "../load.h"
#include "../parse.h"
#include "../scheme.h"
#include "../window.h"
#include "util.h"

void test_generation_table_cell_missing_row 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;
  ruin_node_t *node = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);
  g_assert_cmpstr ("table-row", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
  
  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-cell", ==,
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_row_missing_table 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;
  ruin_node_t *node = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);  
  g_assert_cmpstr 
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-row", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_column_missing_table 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;
  ruin_node_t *node = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-column", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_row_group_missing_table 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-row-group", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_header_group_missing_table 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-header-group", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_footer_group_missing_table 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-footer-group", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_column_group_missing_table 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-column-group", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_caption_missing_table 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-caption", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_missing_row
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);
  g_assert_cmpstr ("table-row", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-cell", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_row_group_missing_row 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-row-group", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);
  g_assert_cmpstr ("table-row", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-cell", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_header_group_missing_row 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-header-group", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);
  g_assert_cmpstr ("table-row", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-cell", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_footer_group_missing_row 
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-footer-group", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);
  g_assert_cmpstr ("table-row", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-cell", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

void test_generation_table_row_missing_cell
(box_generation_fixture *f, gconstpointer d)
{
  GList *boxes = ruin_box_generate (f->window, f->node);
  ruin_box_t *box = NULL;

  g_assert_cmpint (1, ==, g_list_length (boxes));

  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);  
  g_assert_cmpstr
    ("table", ==, ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("table-row", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_ANONYMOUS_BLOCK);
  g_assert_cmpstr ("table-cell", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));

  boxes = box->children;
  g_assert_cmpint (1, ==, g_list_length (boxes));
  box = (ruin_box_t *) boxes->data;
  g_assert (box->type == RUIN_LAYOUT_BOX_TYPE_BLOCK);
  g_assert_cmpstr ("block", ==, 
		   ruin_css_lookup (f->window, box->generator, "display"));
}

int main (int argc, char *argv[])
{
  int ret = 0;
  FILE *dev_null = fopen ("/dev/null", "w+");

  GHashTable *style_block = g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_table = g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_table_cell = g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_table_row = g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_table_column = g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_table_row_group = 
    g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_table_header_group = 
    g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_table_footer_group = 
    g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_table_column_group = 
    g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *style_table_caption = g_hash_table_new (g_str_hash, g_str_equal);

  g_test_init (&argc, &argv, NULL);

  newterm (NULL, dev_null, stdin);
  scm_init_guile ();
  ruin_init ();

  g_hash_table_insert (style_block, "display", "block");
  g_hash_table_insert (style_table, "display", "table");
  g_hash_table_insert (style_table_cell, "display", "table-cell");
  g_hash_table_insert (style_table_row, "display", "table-row");
  g_hash_table_insert (style_table_column, "display", "table-column");
  g_hash_table_insert (style_table_row_group, "display", "table-row-group");
  g_hash_table_insert 
    (style_table_header_group, "display", "table-header-group");
  g_hash_table_insert 
    (style_table_footer_group, "display", "table-footer-group");
  g_hash_table_insert 
    (style_table_column_group, "display", "table-column-group");
  g_hash_table_insert (style_table_caption, "display", "table-caption");

  { box_generation_fixture_component_t *table = 
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new (style_table, NULL);
    GList *table_cell = g_list_append (NULL, table);
    table_cell = g_list_append 
      (table_cell, box_generation_element_fixture_component_new 
       (style_table_cell, table));

    g_test_add 
      ("/box/generation/table/cell/missing-row", box_generation_fixture, 
       table_cell, setup_box_generation_fixture, 
       test_generation_table_cell_missing_row, teardown_box_generation_fixture);
  }

  g_test_add 
    ("/box/generation/table/row/missing-table", box_generation_fixture, 
     g_list_append 
     (NULL, box_generation_element_fixture_component_new 
      (style_table_row, NULL)), 
     setup_box_generation_fixture, test_generation_table_row_missing_table, 
     teardown_box_generation_fixture);

  g_test_add 
    ("/box/generation/table/column/missing-table", box_generation_fixture,
     g_list_append
     (NULL, box_generation_element_fixture_component_new
      (style_table_column, NULL)),
     setup_box_generation_fixture, test_generation_table_column_missing_table, 
     teardown_box_generation_fixture);

  g_test_add 
    ("/box/generation/table/row-group/missing-table", box_generation_fixture, 
     g_list_append
     (NULL, box_generation_element_fixture_component_new
      (style_table_row_group, NULL)), setup_box_generation_fixture, 
     test_generation_table_row_group_missing_table, 
     teardown_box_generation_fixture);

  g_test_add 
    ("/box/generation/table/header-group/missing-table", box_generation_fixture,
     g_list_append
     (NULL, box_generation_element_fixture_component_new
      (style_table_header_group, NULL)), setup_box_generation_fixture, 
     test_generation_table_header_group_missing_table,
     teardown_box_generation_fixture);

  g_test_add 
    ("/box/generation/table/footer-group/missing-table", box_generation_fixture,
     g_list_append
     (NULL, box_generation_element_fixture_component_new
      (style_table_footer_group, NULL)), setup_box_generation_fixture, 
     test_generation_table_footer_group_missing_table,
     teardown_box_generation_fixture);

  g_test_add 
    ("/box/generation/table/column-group/missing-table", box_generation_fixture,
     g_list_append
     (NULL, box_generation_element_fixture_component_new
      (style_table_column_group, NULL)), setup_box_generation_fixture, 
     test_generation_table_column_group_missing_table,
     teardown_box_generation_fixture);

  g_test_add 
    ("/box/generation/table/caption/missing-table", box_generation_fixture, 
     g_list_append
     (NULL, box_generation_element_fixture_component_new
      (style_table_caption, NULL)), setup_box_generation_fixture, 
     test_generation_table_caption_missing_table,
     teardown_box_generation_fixture);

  { box_generation_fixture_component_t *table = 
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new (style_table, NULL);
    GList *table_cell = g_list_append (NULL, table);
    table_cell = g_list_append
      (table_cell, box_generation_element_fixture_component_new 
       (style_table_cell, table));
    
    g_test_add 
      ("/box/generation/table/missing-row", box_generation_fixture, table_cell, 
       setup_box_generation_fixture, test_generation_table_missing_row, 
       teardown_box_generation_fixture);
  }

  { box_generation_fixture_component_t *table = 
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new (style_table, NULL);
    box_generation_fixture_component_t *table_row_group =
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new 
      (style_table_row_group, table);      

    GList *table_cell = g_list_append (NULL, table);
    table_cell = g_list_append (table_cell, table_row_group);
    table_cell = g_list_append
      (table_cell, box_generation_element_fixture_component_new 
       (style_table_cell, table_row_group));

    g_test_add 
      ("/box/generation/table/row-group/missing-row", box_generation_fixture, 
       table_cell, setup_box_generation_fixture, 
       test_generation_table_row_group_missing_row,
       teardown_box_generation_fixture);
  }

  { box_generation_fixture_component_t *table = 
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new (style_table, NULL);
    box_generation_fixture_component_t *table_header_group =
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new 
      (style_table_header_group, table);      

    GList *table_cell = g_list_append (NULL, table);
    table_cell = g_list_append (table_cell, table_header_group);
    table_cell = g_list_append
      (table_cell, box_generation_element_fixture_component_new 
       (style_table_cell, table_header_group));

    g_test_add 
      ("/box/generation/table/header-group/missing-row", 
       box_generation_fixture, table_cell, setup_box_generation_fixture, 
       test_generation_table_header_group_missing_row,
       teardown_box_generation_fixture);
  }

  { box_generation_fixture_component_t *table = 
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new (style_table, NULL);
    box_generation_fixture_component_t *table_footer_group =
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new 
      (style_table_footer_group, table);      

    GList *table_cell = g_list_append (NULL, table);
    table_cell = g_list_append (table_cell, table_footer_group);
    table_cell = g_list_append
      (table_cell, box_generation_element_fixture_component_new 
       (style_table_cell, table_footer_group));

    g_test_add 
      ("/box/generation/table/footer-group/missing-row", 
       box_generation_fixture, table_cell, setup_box_generation_fixture, 
       test_generation_table_footer_group_missing_row, 
       teardown_box_generation_fixture);
  }

  { box_generation_fixture_component_t *table = 
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new (style_table, NULL);
    box_generation_fixture_component_t *table_row =
      (box_generation_fixture_component_t *)
      box_generation_element_fixture_component_new 
      (style_table_row, table);      

    GList *table_block = g_list_append (NULL, table);
    table_block = g_list_append (table_block, table_row);
    table_block = g_list_append
      (table_block, box_generation_element_fixture_component_new 
       (style_block, table_row));

    g_test_add 
      ("/box/generation/table/row/missing-cell", box_generation_fixture, 
       table_block, setup_box_generation_fixture, 
       test_generation_table_row_missing_cell, teardown_box_generation_fixture);
  }

  ret = g_test_run ();
  
  endwin ();
  fclose (dev_null);

  return ret;
}
