#include <glib.h>
#include <ncurses.h>
#include <stdio.h>
#include <stdlib.h>

#include "../box.h"
#include "../scheme.h"
#include "../window.h"
#include "util.h"

void test_layout_white_space_normal_simple
(box_fixture *f, gconstpointer d)
{
  ruin_box_t *child_box = NULL;
  ruin_inline_box_t *inline_child_box = NULL;
  ruin_box_t *line1 = NULL, *line2 = NULL, *line3 = NULL;

  ruin_layout_layout_elements (g_list_append (NULL, f->root_box));

  g_assert_cmpint (3, ==, g_list_length (f->root_box->children));
  
  line1 = (ruin_box_t *) f->root_box->children->data;
  line2 = (ruin_box_t *) f->root_box->children->next->data;
  line3 = (ruin_box_t *) f->root_box->children->next->next->data;

  g_assert (line1->type == RUIN_LAYOUT_BOX_TYPE_LINE);
  g_assert (line2->type == RUIN_LAYOUT_BOX_TYPE_LINE);
  g_assert (line3->type == RUIN_LAYOUT_BOX_TYPE_LINE);

  g_assert_cmpint (1, ==, g_list_length (line1->children));
  child_box = (ruin_box_t *) line1->children->data;
  g_assert (child_box->type == RUIN_LAYOUT_BOX_TYPE_INLINE);

  g_assert_cmpint (1, ==, g_list_length (line2->children));
  child_box = (ruin_box_t *) line2->children->data;
  g_assert (child_box->type == RUIN_LAYOUT_BOX_TYPE_INLINE);
  g_assert_cmpint (1, ==, g_list_length (child_box->children));
  child_box = (ruin_box_t *) child_box->children->data;
  inline_child_box = (ruin_inline_box_t *) child_box;
  g_assert_cmpstr (" bbbbbbbbbb cccccccccc", ==, inline_child_box->content_ptr);

  g_assert_cmpint (1, ==, g_list_length (line3->children));
  child_box = (ruin_box_t *) line3->children->data;
  g_assert (child_box->type == RUIN_LAYOUT_BOX_TYPE_INLINE);
  g_assert_cmpint (1, ==, g_list_length (child_box->children));
  child_box = (ruin_box_t *) child_box->children->data;
  inline_child_box = (ruin_inline_box_t *) child_box;
  g_assert_cmpstr (" cccccccccc", ==, inline_child_box->content_ptr);
}

int main (int argc, char *argv[])
{
  int ret = 0;
  FILE *dev_null = fopen ("/dev/null", "w+");

  GHashTable *display_block = NULL;
  GHashTable *white_space_normal = NULL;
  
  box_layout_fixture_component_t root_block;
  box_layout_fixture_component_t line_config;
  box_layout_fixture_component_t inline_wrapper_config;
  box_layout_fixture_component_t white_space_normal_config;
  
  g_test_init (&argc, &argv, NULL);

  newterm (NULL, dev_null, stdin);
  scm_init_guile ();
  ruin_init ();

  display_block = g_hash_table_new (g_str_hash, g_str_equal);
  g_hash_table_insert (display_block, "display", "block");

  white_space_normal = g_hash_table_new (g_str_hash, g_str_equal);
  g_hash_table_insert (white_space_normal, "white-space", "normal");

  root_block.style = display_block;
  root_block.type = RUIN_LAYOUT_BOX_TYPE_BLOCK;
  root_block.content_ptr = NULL;
  root_block.parent = NULL;
  root_block.containing_block = NULL;

  line_config.style = g_hash_table_new (g_str_hash, g_str_equal);
  line_config.type = RUIN_LAYOUT_BOX_TYPE_LINE;
  line_config.content_ptr = NULL;
  line_config.parent = &root_block;
  line_config.containing_block = &root_block;

  inline_wrapper_config.style = g_hash_table_new (g_str_hash, g_str_equal);
  inline_wrapper_config.type = RUIN_LAYOUT_BOX_TYPE_INLINE;
  inline_wrapper_config.content_ptr = NULL;
  inline_wrapper_config.parent = &line_config;
  inline_wrapper_config.containing_block = &root_block;

  white_space_normal_config.style = white_space_normal;
  white_space_normal_config.type = RUIN_LAYOUT_BOX_TYPE_INLINE;
  white_space_normal_config.content_ptr = 
    "aaaaaaaaaa bbbbbbbbbb cccccccccc";
  white_space_normal_config.parent = &inline_wrapper_config;
  white_space_normal_config.containing_block = &root_block;
  
  g_test_add ("/box/layout/white-space/normal/simple", box_fixture, 
	      g_list_append 
	      (g_list_append 
	       (g_list_append 
		(g_list_append (NULL, &root_block),
		 &line_config),
		&inline_wrapper_config),
	       &white_space_normal_config),
	      setup_box_layout_fixture, test_layout_white_space_normal_simple, 
	      teardown_box_fixture);

  ret = g_test_run ();

  endwin ();
  fclose (dev_null);

  return ret;
}
