#include <glib.h>
#include <ncurses.h>
#include <stdio.h>
#include <stdlib.h>

#include "../box.h"
#include "../tables.h"
#include "util.h"

void test_layout_table_fixed_simple (box_fixture *f, gconstpointer d)
{
  ruin_layout_table *table = ruin_layout_table_fixed (f->root_box);

  ruin_layout_table_column *column1 = NULL;
  ruin_layout_table_column *column2 = NULL;
  ruin_layout_table_column *column3 = NULL;
  
  g_assert_cmpint (15, ==, table->width);
  g_assert_cmpint (3, ==, g_list_length (table->columns));
  
  column1 = g_list_nth_data (table->columns, 0);
  column2 = g_list_nth_data (table->columns, 1);
  column3 = g_list_nth_data (table->columns, 2);

  g_assert_cmpint (5, ==, column1->width);
  g_assert_cmpint (5, ==, column2->width);
  g_assert_cmpint (5, ==, column3->width);
}

int main (int argc, char *argv[])
{
  int ret = 0;
  FILE *dev_null = fopen ("/dev/null", "w+");

  box_layout_fixture_component_t simple_fixed_table;
  box_layout_fixture_component_t simple_fixed_table_row;
  box_layout_fixture_component_t simple_fixed_table_cell;

  GHashTable *simple_fixed_table_style =
    g_hash_table_new (g_str_hash, g_str_equal);
  GHashTable *simple_table_row_style = g_hash_table_new 
    (g_str_hash, g_str_equal);
  GHashTable *simple_table_cell_style = g_hash_table_new 
    (g_str_hash, g_str_equal);

  g_test_init (&argc, &argv, NULL);

  newterm (NULL, dev_null, stdin);
  scm_init_guile ();
  ruin_init ();

  g_hash_table_insert (simple_fixed_table_style, "display", "table");
  g_hash_table_insert (simple_fixed_table_style, "table-layout", "fixed");
  g_hash_table_insert (simple_fixed_table_style, "width", "15em");

  g_hash_table_insert (simple_table_row_style, "display", "table-row");
  g_hash_table_insert (simple_table_cell_style, "display", "table-cell");

  simple_fixed_table.style = simple_fixed_table_style;
  simple_fixed_table.type = RUIN_LAYOUT_BOX_TYPE_BLOCK;
  simple_fixed_table.parent = NULL;
  simple_fixed_table.containing_block = NULL;
  simple_fixed_table.content_ptr = NULL;

  simple_fixed_table_row.style = simple_table_row_style;
  simple_fixed_table_row.type = RUIN_LAYOUT_BOX_TYPE_BLOCK;
  simple_fixed_table_row.parent = &simple_fixed_table;
  simple_fixed_table_row.containing_block = &simple_fixed_table;
  simple_fixed_table_row.content_ptr = NULL;

  simple_fixed_table_cell.style = simple_table_cell_style;
  simple_fixed_table_cell.type = RUIN_LAYOUT_BOX_TYPE_BLOCK;
  simple_fixed_table_cell.parent = &simple_fixed_table_row;
  simple_fixed_table_cell.containing_block = &simple_fixed_table_cell;
  simple_fixed_table_cell.content_ptr = NULL;

  g_test_add 
    ("/layout/table/fixed/simple", box_fixture,
     g_list_append 
     (g_list_append
      (g_list_append
       (g_list_append
	(g_list_append (NULL, &simple_fixed_table),
	 &simple_fixed_table_row),
	&simple_fixed_table_cell),
       &simple_fixed_table_cell),
      &simple_fixed_table_cell),
	 
     setup_box_layout_fixture, test_layout_table_fixed_simple, 
     teardown_box_fixture);
  
  ret = g_test_run ();
  
  endwin ();
  fclose (dev_null);

  return ret;
}
