/*
    This file is part of libtermui.

    libtermui is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    libtermui is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with libtermui.  If not, see <http://www.gnu.org/licenses/>.

    Copyright 2006, Alexandre Becoulet <alexandre.becoulet@free.fr>

*/

#ifndef CONSOLE_PV_H_
#define CONSOLE_PV_H_

#include <unistd.h>

#include <termui/term.h>
#include <termui/getline.h>

#include <termui/bhv.h>
#include <termui/console.h>

#define CONSOLE_MAX_CANDIDATES		64

struct				console_ctx_s
{
  struct term_behavior_s	*bhv;
  struct term_s			*tm;
  void				*pv;
  int				acl;
  struct command_entry_s	**root;
  const char			*prompt;
};

/*
 * console_complete.c
 */

struct command_entry_s *
console_complete_cmd(struct term_behavior_s *bhv,
		    struct console_ctx_s *con,
		    const char **start_,
		    const char *end);

GETLINE_FCN_COMPLETE(console_complete);

#endif /* CONSOLE_H_ */

