/*
 * Copyright (C) 2025 Nicolas Dato
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/*
 * Compile with
 * gcc -o simple simple.c -ltuberia -lpthread
 * or
 * gcc -o simple simple.c `pkg-config --cflags --libs --static tuberia`
 */

#include <stdio.h>
#include <stdlib.h>
#include <tuberia.h>

void *stage_one(void *element, void *opaque)
{
	(void)opaque;
	int *i = element;
	*i += 5;
	return i;
}

void *stage_two(void *element, void *opaque)
{
	(void)opaque;
	int *i = element;
	*i *= 10;
	return i;
}

void sink(void *element, void *opaque)
{
	(void)opaque;
	int *i = element;
	printf("sink: %d\n", *i);
	free(i);
}

int main(void)
{
	tube *ctx;
	tube_source *source;
	int *element, n;

	source = tube_source_alloc(2, NULL, NULL, free);
	tube_stage_append(source, tube_stage_alloc(2, stage_one, NULL, free));
	tube_stage_append(source, tube_stage_alloc(2, stage_two, NULL, free));
	ctx = tube_alloc(source, sink, NULL);
	tube_source_and_stages_free(&source);
	tube_start(ctx);
	while (scanf("%d", &n) == 1) {
		element = malloc(sizeof(*element));
		*element = n;
		tube_inject(ctx, 1000, element);
	}
	tube_free(&ctx);

	return 0;
}

