/* libunwind - a platform-independent unwind library
   Copyright (C) 2001-2002 Hewlett-Packard Co
	Contributed by David Mosberger-Tang <davidm@hpl.hp.com>

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 2.1 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public
License.  */

#include <ucontext.h>
#include <unwind.h>

/* See glibc manual for a description of this function.  */

int
backtrace (void **buffer, int size)
{
  unw_cursor_t cursor;
  ucontext_t uc;
  unw_word_t ip;
  int n = 0;

  getcontext (&uc);
  if (unw_init_local (&cursor, &uc) < 0)
    return 0;

  while (unw_step (&cursor) > 0)
    {
      if (n >= size)
	return n;

      if (unw_get_reg (&cursor, UNW_REG_IP, &ip) < 0)
	return n;
      buffer[n++] = (void *) ip;
    }
  return n;
}
