/* libunwind - a platform-independent unwind library
   Copyright (C) 2001-2002 Hewlett-Packard Co
	Contributed by David Mosberger-Tang <davidm@hpl.hp.com>

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 2.1 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public
License.  */

#include <execinfo.h>
#include <stdio.h>
#include <stdlib.h>
#include <unwind.h>
#include <unwind-ia64.h>

#define panic(args...)				\
	{ fprintf (stderr, args); exit (-1); }

static void
do_backtrace (void)
{
  unw_cursor_t cursor;
  unw_word_t ip, sp;
  ucontext_t uc;

  getcontext (&uc);
  if (unw_init_local (&cursor, &uc) < 0)
    panic ("unw_init_local failed!\n");

  do
    {
      unw_get_reg (&cursor, UNW_REG_IP, &ip);
      unw_get_reg (&cursor, UNW_REG_SP, &sp);
      printf ("ip=%016lx sp=%016lx\n", ip, sp);

      {
	unw_word_t first_ip, handler, lsda, bsp;

	unw_get_reg (&cursor, UNW_REG_FIRST_IP, &first_ip);
	unw_get_reg (&cursor, UNW_REG_HANDLER, &handler);
	unw_get_reg (&cursor, UNW_REG_LSDA, &lsda);
	unw_get_reg (&cursor, UNW_IA64_CURRENT_BSP, &bsp);
	printf ("\tfirst_ip=%016lx handler=%lx lsda=%lx bsp=%lx\n",
		first_ip, handler, lsda, bsp);
      }
    }
  while (unw_step (&cursor) > 0);
}

static void
foo (void)
{
  void *buffer[20];
  int i, n;

  do_backtrace ();

  n = backtrace (buffer, 20);
  for (i = 0; i < n; ++i)
    printf ("[%d] ip=%p\n", i, buffer[i]);
}

int
main (int argc, char **argv)
{
  foo ();
  return 0;
}
