/* libunwind - a platform-independent unwind library
   Copyright (C) 2001-2002 Hewlett-Packard Co
	Contributed by David Mosberger-Tang <davidm@hpl.hp.com>

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 2.1 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public
License.  */

/* This shows how to use the unwind interface to modify any ancestor
   frame while still returning to the parent frame.  */

#include <signal.h>
#include <stdio.h>

#include <unwind.h>

#define panic(args...)				\
	{ fprintf (stderr, args); exit (-1); }

static void
sighandler (int signal)
{
  unw_cursor_t cursor, cursor2;
  unw_word_t rp;
  ucontext_t uc;

  printf ("caught signal %d\n", signal);

  getcontext(&uc);

  if (unw_init (&cursor, &uc) < 0)
    panic ("unw_init() failed!\n");

  /* get cursor for caller of sighandler: */
  if (unw_step (&cursor) < 0)
    panic ("unw_step() failed!\n");

  cursor2 = cursor;
  while (!unw_is_signal_frame (&cursor2))
    if (unw_step (&cursor2) < 0)
      panic ("failed to find signal frame!\n");

  if (unw_get_reg(&cursor2, UNW_REG_RP, &rp) < 0)
    panic ("failed to get IP!\n");

  /* skip faulting instruction (doesn't handle MLX template) */
  ++rp;
  if (rp & 0x3 == 0x3)
    rp += 13;

  if (unw_set_reg(&cursor2, UNW_REG_RP, rp) < 0)
    panic ("failed to set IP!\n");

  unw_resume(&cursor);	/* update context & return to caller of sighandler() */

  panic ("unexpected return from unw_resume()!\n");
}

static void
doit (char *p)
{
  int ch;

  ch = *p;	/* trigger SIGSEGV */

  printf("doit: finishing execution!\n");
}

int
main (int argc, char **argv)
{
  signal(SIGSEGV, sighandler);
  doit (0);
}
