;;;; packages.lisp --- package definitions for libxml-clisp

;;; Copyright (C) 2009 N. Raghavendra.  All rights reserved.
;;; 
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above
;;;    copyright notice, this list of conditions and the following
;;;    disclaimer in the documentation and/or other materials provided
;;;    with the distribution.
;;; 
;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
;;; IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; N. Raghavendra <raghu@retrotexts.net>
;;; 
;;; Created: 2009-06-14
;;; 
;;; $Hg: packages.lisp,v ae6366215b15 2009-09-03T20:01:35+05:30 raghu $

(in-package "COMMON-LISP-USER")



(defpackage "NET.RETROTEXTS.LIBXML-CLISP"
  (:nicknames "LIBXML-CLISP")
  (:documentation "Main package of libxml-clisp.")
  (:use "COMMON-LISP" "FFI")
  (:shadowing-import-from "EXPORTING"
    "DEFCONSTANT" "DEFPARAMETER" "DEFVAR" "DEFUN" "DEFMACRO"
    "DEFCLASS" "DEFGENERIC" "DEFMETHOD" "DEFINE-CONDITION"
    "DEF-C-TYPE" "DEF-C-ENUM" "DEF-CALL-OUT" "DEF-C-VAR" "DEF-C-STRUCT")
  (:export
   ;; awk '/symbol-function/ { x = $3 ; sub(/\047/,"",x ) ; \
   ;;   sub(/\051/,"",x) ; print "\"" toupper(x) "\"" }' foreign/*.lisp
   "ERROR-PATHNAME"
   "XML-FREE"
   "NAMESPACE-NAME"
   "NAMESPACE-DOCUMENT"
   "DTD-PREVIOUS"
   "DTD-DOCUMENT"
   "ATTRIBUTE-PREVIOUS"
   "ATTRIBUTE-DOCUMENT"
   "ATTRIBUTE-NAMESPACE"
   "NODE-PREVIOUS"
   "NODE-DOCUMENT"
   "NODE-NAMESPACE"
   "NODE-ATTRIBUTES"
   "NODE-NAMESPACE-DEFINITIONS"
   "DOCUMENT-PREVIOUS"
   "DOCUMENT-SELF"
   "DOCUMENT-INTERNAL-SUBSET"
   "DOCUMENT-EXTERNAL-SUBSET"
   "DOCUMENT-OLD-NAMESPACE"
   "DOCUMENT-URI"))



(defpackage "NET.RETROTEXTS.LIBXML-CLISP.EXAMPLES"
  (:nicknames "EXAMPLES")
  (:documentation "Examples for libxml-clisp.")
  (:use "COMMON-LISP" "NET.RETROTEXTS.LIBXML-CLISP"))



;;; Local Variables:
;;; mode: lisp
;;; comment-column: 32
;;; End:

;;;; packages.lisp ends here