;;;; attribute-get.lisp --- example for libxml-clisp tutorial

;;; Copyright (C) 2009 N. Raghavendra.  All rights reserved.
;;; 
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above
;;;    copyright notice, this list of conditions and the following
;;;    disclaimer in the documentation and/or other materials provided
;;;    with the distribution.
;;; 
;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
;;; IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; N. Raghavendra <raghu@retrotexts.net>
;;; 
;;; Created: 2009-08-30
;;; 
;;; $Hg: attribute-get.lisp,v ae6366215b15 2009-09-03T20:01:35+05:30 raghu $

(in-package "NET.RETROTEXTS.LIBXML-CLISP.EXAMPLES")



(defun get-references (filename)
  "Return the values of certain attributes in the document from FILENAME.
The return-value is a list, each element of which is the value of the
`uri' attribute of a `reference' child of the document element of the
`story' document parsed from FILENAME.  FILENAME must be a pathname
designator."
  (with-xml-file (story filename)
    (let ((document-element (document-element story)))
      (if (story-node-p document-element)
        (get-node-references document-element)
        (restart-case (error 'story-error :document story)
          (parse-new-file (new-filename)
            :report "Parse another file."
            :interactive read-new-value
            (get-references new-filename)))))))

(defun get-node-references (node)
  (node-list-map #'(lambda (nd)
                     (attribute-value nd "uri"))
                 (node-children node)
                 #'(lambda (nd)
                     (string= (node-namestring nd) "reference"))))

(defun test-get-references (string)
  (with-temp-file (test-file)
    (with-open-file (out test-file :direction :output)
      (write-string string out))
    (get-references test-file)))

(defvar *get-references-test-data*
  "<?xml version=\"1.0\"?>
<story>
  <storyinfo>
    <author>Foo B. Quux</author>
    <datewritten>2009-05-17</datewritten>
    <keyword>storyinfo-1/keyword-1</keyword>
    <keyword>storyinfo-1/keyword-2</keyword>
  </storyinfo>
  <storyinfo>
    <keyword>storyinfo-2/keyword-1</keyword>
    <keyword>storyinfo-2/keyword-2</keyword>
  </storyinfo>
  <reference uri=\"http://www.libxml.org/\"/>
  <body>
    <headline>The Headline</headline>
    <keyword>body/keyword</keyword>
    <para>This is the body text.</para>
  </body>
  <reference uri=\"http://xml.coverpages.org/\"/>
</story>")

(defvar *get-references-test-value*
  '("http://www.libxml.org/" "http://xml.coverpages.org/"))

(defun test-attribute-get ()
  (test-libxml-clisp #'test-get-references
                     *get-references-test-data*
                     *get-references-test-value*))

(provide-example 'attribute-get)



;;; Local Variables:
;;; mode: lisp
;;; comment-column: 32
;;; End:

;;;; attribute-get.lisp ends here