/* libxml-clisp.c --- FFI definitions for libxml-clisp
 * 
 * Copyright (C) 2009 N. Raghavendra.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * N. Raghavendra <raghu@retrotexts.net>
 * 
 * Created: 2009-07-30
 * 
 * $Hg: libxml-clisp.c,v 238ceb51574b 2009-09-13T19:14:52+05:30 raghu $
 */

#include <libxml/parser.h>
#include <libxml/xmlreader.h>
#include <libxml/xpath.h>



/* xmlversion.h */

int
lxcl_libxml_version()
{
        return  LIBXML_VERSION;
}



/* xmlmemory.h and globals.h */

/* `xmlFree' is a global variable declared in `globals.h', whose value
 * equals the pointer to a function for freeing memory.  The following
 * definition provides an actual function which just calls that
 * function.  One can use `def-call-out' on the following function.
 * Without it, one would have to do
 *
 *   (def-c-var $xml-free (:name * "xmlFree")...)
 *
 *   (funcall (foreign-function $xml-free 
 *                              (parse-c-type '(c-function...)))
 *
 * etc, which seems less convenient than this method.
 */
   
void lxcl_free(void *mem)
{
        xmlFree(mem);
}



/* xmlNs in `tree.h'. */

xmlNsPtr
lxcl_ns_next(xmlNsPtr ns)
{
        return ns->next;
}

xmlNsType
lxcl_ns_type(xmlNsPtr ns)
{
        return ns->type;
}

const xmlChar *
lxcl_ns_href(xmlNsPtr ns)
{
        return ns->href;
}

const xmlChar *
lxcl_ns_prefix(xmlNsPtr ns)
{
        return ns->prefix;
}

void *
lxcl_ns_private(xmlNsPtr ns)
{
        return ns->_private;
}

xmlDocPtr
lxcl_ns_context(xmlNsPtr ns)
{
        return ns->context;
}



/* xmlDtd in `tree.h'. */

void *
lxcl_dtd_private(xmlDtdPtr dtd)
{
        return dtd->_private;
}

xmlElementType
lxcl_dtd_type(xmlDtdPtr dtd)
{
        return dtd->type;
}

const xmlChar *
lxcl_dtd_name(xmlDtdPtr dtd)
{
        return dtd->name;
}

xmlNodePtr
lxcl_dtd_children(xmlDtdPtr dtd)
{
        return dtd->children;
}

xmlNodePtr
lxcl_dtd_last(xmlDtdPtr dtd)
{
        return dtd->last;
}

xmlDocPtr
lxcl_dtd_parent(xmlDtdPtr dtd)
{
        return dtd->parent;
}

xmlNodePtr
lxcl_dtd_next(xmlDtdPtr dtd)
{
        return dtd->next;
}

xmlNodePtr
lxcl_dtd_prev(xmlDtdPtr dtd)
{
        return dtd->prev;
}

xmlDocPtr
lxcl_dtd_doc(xmlDtdPtr dtd)
{
        return dtd->doc;
}

void *
lxcl_dtd_notations(xmlDtdPtr dtd)
{
        return dtd->notations;
}

void *
lxcl_dtd_elements(xmlDtdPtr dtd)
{
        return dtd->elements;
}

void *
lxcl_dtd_attributes(xmlDtdPtr dtd)
{
        return dtd->attributes;
}

void *
lxcl_dtd_entities(xmlDtdPtr dtd)
{
        return dtd->entities;
}

const xmlChar *
lxcl_dtd_external_id(xmlDtdPtr dtd)
{
        return dtd->ExternalID;
}

const xmlChar *
lxcl_dtd_system_id(xmlDtdPtr dtd)
{
        return dtd->SystemID;
}

void *
lxcl_dtd_pentities(xmlDtdPtr dtd)
{
        return dtd->pentities;
}



/* xmlAttr in `tree.h'. */

void *
lxcl_attr_private(xmlAttrPtr attr)
{
        return attr->_private;
}

xmlElementType
lxcl_attr_type(xmlAttrPtr attr)
{
        return attr->type;
}

const xmlChar *
lxcl_attr_name(xmlAttrPtr attr)
{
        return attr->name;
}

xmlNodePtr
lxcl_attr_children(xmlAttrPtr attr)
{
        return attr->children;
}

xmlNodePtr
lxcl_attr_last(xmlAttrPtr attr)
{
        return attr->last;
}

xmlNodePtr
lxcl_attr_parent(xmlAttrPtr attr)
{
        return attr->parent;
}

xmlAttrPtr
lxcl_attr_next(xmlAttrPtr attr)
{
        return attr->next;
}

xmlAttrPtr
lxcl_attr_prev(xmlAttrPtr attr)
{
        return attr->prev;
}

xmlDocPtr
lxcl_attr_doc(xmlAttrPtr attr)
{
        return attr->doc;
}

xmlNsPtr
lxcl_attr_ns(xmlAttrPtr attr)
{
        return attr->ns;
}

xmlAttributeType
lxcl_attr_atype(xmlAttrPtr attr)
{
        return attr->atype;
}

void *
lxcl_attr_psvi(xmlAttrPtr attr)
{
        return attr->psvi;
}



/* xmlNode in `tree.h'. */

void *
lxcl_node_private(xmlNodePtr node)
{
        return node->_private;
}

xmlElementType
lxcl_node_type(xmlNodePtr node)
{
        return node->type;
}

const xmlChar *
lxcl_node_name(xmlNodePtr node)
{
        return node->name;
}

xmlNodePtr
lxcl_node_children(xmlNodePtr node)
{
        return node->children;
}

xmlNodePtr
lxcl_node_last(xmlNodePtr node)
{
        return node->last;
}

xmlNodePtr
lxcl_node_parent(xmlNodePtr node)
{
        return node->parent;
}

xmlNodePtr
lxcl_node_next(xmlNodePtr node)
{
        return node->next;
}

xmlNodePtr
lxcl_node_prev(xmlNodePtr node)
{
        return node->prev;
}

xmlDocPtr
lxcl_node_doc(xmlNodePtr node)
{
        return node->doc;
}

xmlNsPtr
lxcl_node_ns(xmlNodePtr node)
{
        return node->ns;
}

xmlChar *
lxcl_node_content(xmlNodePtr node)
{
        return node->content;
}

xmlAttrPtr
lxcl_node_properties(xmlNodePtr node)
{
        return node->properties;
}

xmlNsPtr
lxcl_node_ns_def(xmlNodePtr node)
{
        return node->nsDef;
}

void *
lxcl_node_psvi(xmlNodePtr node)
{
        return node->psvi;
}

unsigned short
lxcl_node_line(xmlNodePtr node)
{
        return node->line;
}

unsigned short
lxcl_node_extra(xmlNodePtr node)
{
        return node->extra;
}



/* xmlDoc in `tree.h'. */

void *
lxcl_doc_private(xmlDocPtr doc)
{
        return doc->_private;
}

xmlElementType
lxcl_doc_type(xmlDocPtr doc)
{
        return doc->type;
}

char *
lxcl_doc_name(xmlDocPtr doc)
{
        return doc->name;
}

xmlNodePtr
lxcl_doc_children(xmlDocPtr doc)
{
        return doc->children;
}

xmlNodePtr
lxcl_doc_last(xmlDocPtr doc)
{
        return doc->last;
}

xmlNodePtr
lxcl_doc_parent(xmlDocPtr doc)
{
        return doc->parent;
}

xmlNodePtr
lxcl_doc_next(xmlDocPtr doc)
{
        return doc->next;
}

xmlNodePtr
lxcl_doc_prev(xmlDocPtr doc)
{
        return doc->prev;
}

xmlDocPtr
lxcl_doc_doc(xmlDocPtr doc)
{
        return doc->doc;
}

int
lxcl_doc_compression(xmlDocPtr doc)
{
        return doc->compression;
}

int
lxcl_doc_standalone(xmlDocPtr doc)
{
        return doc->standalone;
}

xmlDtdPtr
lxcl_doc_int_subset(xmlDocPtr doc)
{
        return doc->intSubset;
}

xmlDtdPtr
lxcl_doc_ext_subset(xmlDocPtr doc)
{
        return doc->extSubset;
}

xmlNsPtr
lxcl_doc_old_ns(xmlDocPtr doc)
{
        return doc->oldNs;
}

const xmlChar *
lxcl_doc_version(xmlDocPtr doc)
{
        return doc->version;
}

const xmlChar *
lxcl_doc_encoding(xmlDocPtr doc)
{
        return doc->encoding;
}

void *
lxcl_doc_ids(xmlDocPtr doc)
{
        return doc->ids;
}

void *
lxcl_doc_refs(xmlDocPtr doc)
{
        return doc->refs;
}

const xmlChar *
lxcl_doc_url(xmlDocPtr doc)
{
        return doc->URL;
}

int
lxcl_doc_charset(xmlDocPtr doc)
{
        return doc->charset;
}

xmlDictPtr
lxcl_doc_dict(xmlDocPtr doc)
{
        return doc->dict;
}

void *
lxcl_doc_psvi(xmlDocPtr doc)
{
        return doc->psvi;
}



/* xmlNodeSet in `xpath.h'. */

int
lxcl_node_set_node_nr(xmlNodeSetPtr node_set)
{
        return node_set->nodeNr;
}

int
lxcl_node_set_node_max(xmlNodeSetPtr node_set)
{
        return node_set->nodeMax;
}

xmlNodePtr *
lxcl_node_set_node_tab(xmlNodeSetPtr node_set)
{
        return node_set->nodeTab;
}

/* The following evaluate macros defined in `xpath.h'. */
int
lxcl_xpath_node_set_get_length(xmlNodeSetPtr node_set)
{
        return xmlXPathNodeSetGetLength(node_set);
}

xmlNodePtr
lxcl_xpath_node_set_item(xmlNodeSetPtr node_set, int index)
{
        return xmlXPathNodeSetItem(node_set, index);
}

int
lxcl_xpath_node_set_is_empty(xmlNodeSetPtr node_set)
{
        return xmlXPathNodeSetIsEmpty(node_set);
}



/* xmlXPathObject in `xpath.h'. */

xmlXPathObjectType
lxcl_xpath_object_type(xmlXPathObjectPtr xpath_object)
{
        return xpath_object->type;
}

xmlNodeSetPtr
lxcl_xpath_object_nodesetval(xmlXPathObjectPtr xpath_object)
{
        return xpath_object->nodesetval;
}



/*
 * Local Variables:
 * mode: c
 * comment-column: 32
 * End:
 */

/* libxml-clisp.c ends here  */
