;;;; attribute-add.lisp --- example for libxml-clisp tutorial

;;; Copyright (C) 2009 N. Raghavendra.  All rights reserved.
;;; 
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above
;;;    copyright notice, this list of conditions and the following
;;;    disclaimer in the documentation and/or other materials provided
;;;    with the distribution.
;;; 
;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
;;; IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; N. Raghavendra <raghu@retrotexts.net>
;;; 
;;; Created: 2009-08-26
;;; 
;;; $Hg: attribute-add.lisp,v ae6366215b15 2009-09-03T20:01:35+05:30 raghu $

(in-package "NET.RETROTEXTS.LIBXML-CLISP.EXAMPLES")



(defun add-reference (filename &optional uri)
  "Add a new element with an attribute to the document from FILENAME.
A `reference' element with a `uri' attribute having value URI is added
to the end of the `story' document parsed from FILENAME.  FILENAME
must be a pathname designator, and URI must be an XML String
designator.  The resulting document is written to the default XML
output stream.  Returns the number of octets written."
  (with-xml-file (story filename)
    (let ((document-element (document-element story)))
      (cond ((story-node-p document-element)
              (add-attribute (append-child-with-text document-element
                                                     "reference")
                             "uri" uri)
              (write-document story))
            (t (restart-case (error 'story-error :document story)
                 (parse-new-file (new-filename)
                   :report "Parse another file."
                   :interactive read-new-value
                   (add-reference new-filename uri))))))))

(defun test-add-reference (string)
  (with-temp-file (test-file)
    (with-open-file (out test-file :direction :output)
      (write-string string out))
    (with-output-to-string (stream)
      (with-xml-output (stream)
        (add-reference test-file "http://www.xmlsoft.org/")))))

(defvar *add-reference-test-data*
  "<?xml version=\"1.0\"?>
<story>
  <storyinfo>
    <author>Foo B. Quux</author>
    <datewritten>2009-05-17</datewritten>
    <keyword>storyinfo-1/keyword-1</keyword>
    <keyword>storyinfo-1/keyword-2</keyword>
  </storyinfo>
  <storyinfo>
    <keyword>storyinfo-2/keyword-1</keyword>
    <keyword>storyinfo-2/keyword-2</keyword>
  </storyinfo>
  <body>
    <headline>The Headline</headline>
    <keyword>body/keyword</keyword>
    <para>This is the body text.</para>
  </body>
</story>")

(defvar *add-reference-test-value*
  "<?xml version=\"1.0\"?>
<story>
  <storyinfo>
    <author>Foo B. Quux</author>
    <datewritten>2009-05-17</datewritten>
    <keyword>storyinfo-1/keyword-1</keyword>
    <keyword>storyinfo-1/keyword-2</keyword>
  </storyinfo>
  <storyinfo>
    <keyword>storyinfo-2/keyword-1</keyword>
    <keyword>storyinfo-2/keyword-2</keyword>
  </storyinfo>
  <body>
    <headline>The Headline</headline>
    <keyword>body/keyword</keyword>
    <para>This is the body text.</para>
  </body>
<reference uri=\"http://www.xmlsoft.org/\"/></story>
")

(defun test-attribute-add ()
  (test-libxml-clisp #'test-add-reference
                     *add-reference-test-data*
                     *add-reference-test-value*))

(provide-example 'attribute-add)



;;; Local Variables:
;;; mode: lisp
;;; comment-column: 32
;;; End:

;;;; attribute-add.lisp ends here