;;;; names.lisp --- example for libxml-clisp tutorial

;;; Copyright (C) 2009 N. Raghavendra.  All rights reserved.
;;; 
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above
;;;    copyright notice, this list of conditions and the following
;;;    disclaimer in the documentation and/or other materials provided
;;;    with the distribution.
;;; 
;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
;;; IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; N. Raghavendra <raghu@retrotexts.net>
;;; 
;;; Created: 2009-09-12
;;; 
;;; $Hg: names.lisp,v 238ceb51574b 2009-09-13T19:14:52+05:30 raghu $

(in-package "NET.RETROTEXTS.LIBXML-CLISP.EXAMPLES")



(defun element-names (filename)
  "Return the names of all elements of the document from FILENAME.
The return value is the list of all the elements of the document, in
depth-first order.  FILENAME must be a pathname designator."
  (with-xml-file (document filename)
    (node-element-names (document-element document))))

(defun node-element-names (node)
  (loop for nd = node then (node-next nd)
     until (null-item-p nd)
     when (elementp nd)
     collect (node-namestring nd) into result
     append (node-element-names (node-children nd)) into result
     finally (return result)))

(defun elementp (node)
  "Return true if NODE is an element."
  (eql (node-type node) 'xml-element-node))

(defun test-element-names (string)
  (with-temp-file (test-file)
    (with-open-file (out test-file :direction :output)
      (write-string string out))
    (element-names test-file)))

(defvar *element-names-test-data*
  "<?xml version=\"1.0\"?>
<article>
  <articleinfo>
    <author>
      <firstname>Foo</firstname>
      <surname>Bar</surname>
    </author>
    <title>An Example Article</title>
    <titleabbrev>Example art</titleabbrev>
    <keywordset>
      <keyword>an articleinfo keyword</keyword>
      <keyword>another articleinfo keyword</keyword>
    </keywordset>
  </articleinfo>
  <section>
    <sectioninfo>
      <keywordset>
        <keyword>a sectioninfo keyword</keyword>
      </keywordset>
    </sectioninfo>
    <title>A Section</title>
    <para>This is a paragraph in a section.</para>
  </section>
</article>")

(defvar *element-names-test-value*
  '("article" "articleinfo" "author" "firstname" "surname" "title"
    "titleabbrev" "keywordset" "keyword" "keyword" "section" "sectioninfo"
    "keywordset" "keyword" "title" "para"))

(defun test-names ()
  (test-libxml-clisp #'test-element-names
                     *element-names-test-data*
                     *element-names-test-value*))

(provide-example 'names)



;;; Local Variables:
;;; mode: lisp
;;; comment-column: 32
;;; End:

;;;; names.lisp ends here