//-*- C++ -*-
/*
  lingot, a musical instrument tuner.

  Copyright (C) 2004   Ibn Cereijo Graa, Jairo Chapela Martnez.

  This file is part of lingot.

  lingot is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  lingot is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with lingot; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __CONFIG_H__
#define __CONFIG_H__

#include "defs.h"

// Clase de configuracin. Determina el funcionamiento del afinador.
// No todos los parmetros son configurables externamente.
class Config {

private:

  char**       tokens;    // tabla de tokens.
  void**       atributos; // tabla de punteros a los atributos.
  char*        formatos;  // formatos para parsear/guardar los tokens de/en el archivo de configuracin.

public:
  
  char         AUDIO_DEV[80];
  unsigned int SAMPLE_RATE;
  unsigned int OVERSAMPLING;

  // error de frecuencia del "La" de referencia (en semitonos).
  FLT          ROOT_FREQUENCY_ERROR;

  // frecuencia del "La" de referencia (parmetro derivado).
  FLT          ROOT_FREQUENCY;

  unsigned int FFT_SIZE; // muestras usadas para hacer la FFT del mismo nmero de muestras.

  FLT          CALCULATION_RATE;   // frecuencia de clculo.
  FLT          VISUALIZATION_RATE; // frecuencia de visualizacin.

  // duracin en segundos de la ventana temporal.
  FLT          TEMPORAL_WINDOW;  // seg.

  // muestras almacenadas en la ventana temporal (parmetro derivado).
  unsigned int TEMPORAL_BUFFER_SIZE;
  // muestras leidas de la tarjeta de cada vez. (muestras/clculo, parmetro derivado)
  unsigned int READ_BUFFER_SIZE;

  FLT          NOISE_THRESHOLD;    // dB
  FLT          NOISE_THRESHOLD_UN; // unidades naturales (parmetro derivado)

  // configuracin del algoritmo de determinacin de la frecuencia fundamental.
  //----------------------------------------------------------------------------

  // nmero de picos mximos considerados.
  unsigned int PEAK_NUMBER;

  // nmero de muestras adyacentes para considerar una muestra como pico.
  unsigned int PEAK_ORDER ;

  // si el pico mximo es tantas o ms veces mayor que el pico considerado,
  // dicho pico no se tendr en cuenta como portador de la frecuencia
  // fundamental.
  FLT          PEAK_REJECTION_RELATION;    // dBs
  FLT          PEAK_REJECTION_RELATION_UN; // unidades naturales (parmetro derivado)

  // aproximacin por DFT's
  unsigned int DFT_NUMBER;  // numero de DFT's.
  unsigned int DFT_SIZE;  // tamao en muestras de las DFT's de aproximacin.

  // mximo nmero de iterantes por el algoritmo de Newton-Raphson
  unsigned int MAX_NR_ITER;

  //----------------------------------------------------------------------------

  // valor de reposo de la aguja. (la aguja abarca [-0.5, 0.5])
  FLT          VRP;

  //----------------------------------------------------------------------------

public:
  
  // constructor.
  Config();

  // configuracin por defecto.
  void reset();

  // resuelve parmetros internos a partir de parmetros externos.
  void actualizaParametrosInternos();

  void asociaAtributos();
  void guardaArchivoConf(char* archivo);
  void parseaArchivoConf(char* archivo);
};


#endif
