/*
 * $Id: lm-applet.h,v 1.5 2004/08/15 01:07:27 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LM_APPLET_H
#define _LM_APPLET_H

#include <panel-applet.h>
#include "lm-host.h"

#define LM_TYPE_APPLET			(lm_applet_get_type())
#define LM_APPLET(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), LM_TYPE_APPLET, LMApplet))
#define LM_APPLET_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), LM_TYPE_APPLET, LMAppletClass))
#define LM_IS_APPLET(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), LM_TYPE_APPLET))
#define LM_IS_APPLET_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), LM_TYPE_APPLET))
#define LM_APPLET_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), LM_TYPE_APPLET, LMAppletClass))

typedef struct _LMAppletPrivate LMAppletPrivate;

typedef struct
{
  PanelApplet		applet;

  LMAppletPrivate	*priv;
} LMApplet;

typedef struct
{
  PanelAppletClass	parent_class;

  /* signals */
  void	(*activate)		(LMApplet *applet);
  void	(*activate_preferences)	(LMApplet *applet);
} LMAppletClass;

GType lm_applet_get_type (void);
int lm_applet_factory_main (void);

GSList *lm_applet_get_hosts (LMApplet *applet);

LMHost *lm_applet_add_host (LMApplet *applet, const char *name);
LMHost *lm_applet_replace_host (LMApplet *applet, LMHost *old, const char *new);
void lm_applet_swap_hosts (LMApplet *applet, LMHost *host1, LMHost *host2);
void lm_applet_remove_host (LMApplet *applet, LMHost *host);

void lm_applet_set_delay (LMApplet *applet, unsigned int delay);
unsigned int lm_applet_get_delay (LMApplet *applet);

void lm_applet_set_timeout (LMApplet *applet, unsigned int timeout);
unsigned int lm_applet_get_timeout (LMApplet *applet);

void lm_applet_set_scale (LMApplet *applet, unsigned int scale);
unsigned int lm_applet_get_scale (LMApplet *applet);

void lm_applet_set_preferences_width (LMApplet *applet, int width);
int lm_applet_get_preferences_width (LMApplet *applet);

void lm_applet_set_preferences_height (LMApplet *applet, int height);
int lm_applet_get_preferences_height (LMApplet *applet);

#endif /* _LM_APPLET_H */
