/*
 * $Id: lm-dialog.c,v 1.3 2004/07/15 23:22:02 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdarg.h>
#include <gtk/gtk.h>
#include "lm-util.h"

/*** implementation **********************************************************/

void
lm_error_dialog (const char *primary, const char *format, ...)
{
  GtkWidget *dialog;
  GtkWidget *label;
  GString *message;
  char *escaped;

  lm_create_interface("dialog",
		      "dialog", &dialog,
		      "label", &label,
		      NULL);
  gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_OK, GTK_RESPONSE_OK);

  message = g_string_new(NULL);

  if (primary)
    {
      escaped = g_markup_printf_escaped("<span weight=\"bold\" size=\"larger\">%s</span>", primary);
      g_string_append(message, escaped);
      g_free(escaped);
    }

  if (format)
    {
      va_list args;
      char *secondary;

      va_start(args, format);
      secondary = g_strdup_vprintf(format, args);
      va_end(args);

      if (primary)
	g_string_append(message, "\n\n");

      escaped = g_markup_escape_text(secondary, -1);
      g_free(secondary);

      g_string_append(message, escaped);
      g_free(escaped);
    }

  gtk_label_set_markup(GTK_LABEL(label), message->str);
  g_string_free(message, TRUE);

  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);
}
