/* Generated by GOB (v2.0.9) on Sun Aug 22 17:00:50 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#define selfp (self->_priv)

#include "lm-applet.h"

#include "lm-applet-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 45 "lm-applet.gob"

#include <string.h>
#include <panel-applet-gconf.h>
#include "lm-util.h"
#include "lm-preferences.h"
#include "lm-sockets.h"
#include "lm-icmp.h"

#define ICON_PADDING			1
#define BAR_PADDING			3

#define BAR_SPACING			3
#define BAR_THICKNESS			6

#define CONF_HOSTS			"hosts"
#define CONF_DELAY			"delay"
#define CONF_TIMEOUT			"timeout"
#define CONF_SCALE			"scale"
#define CONF_PREFERENCES_WIDTH		"preferences_width"
#define CONF_PREFERENCES_HEIGHT		"preferences_height"

#define KEY_PROGRESS_BAR		"lm-applet:progress-bar"

/* keep in sync with link-monitor-applet.schemas */
#define DEFAULT_PREFERENCES_WIDTH	-1
#define DEFAULT_PREFERENCES_HEIGHT	387

/* keep in sync with preferences.glade */
#define MIN_SCALE			1

  LMApplet *lm_applet = NULL;

  typedef struct
  {
    GIOChannel		*channel;
    LMSocket		*s;
    LMApplet		*applet;
    unsigned int	source_id;
  } WatchInfo;

#line 66 "lm-applet.c"
/* self casting macros */
#define SELF(x) LM_APPLET(x)
#define SELF_CONST(x) LM_APPLET_CONST(x)
#define IS_SELF(x) LM_IS_APPLET(x)
#define TYPE_SELF LM_TYPE_APPLET
#define SELF_CLASS(x) LM_APPLET_CLASS(x)

#define SELF_GET_CLASS(x) LM_APPLET_GET_CLASS(x)

/* self typedefs */
typedef LMApplet Self;
typedef LMAppletClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lm_applet_init (LMApplet * o) G_GNUC_UNUSED;
static void ___real_lm_applet_activate (LMApplet * self);
static void lm_applet_activate (LMApplet * self) G_GNUC_UNUSED;
static void ___real_lm_applet_activate_preferences (LMApplet * self);
static void lm_applet_activate_preferences (LMApplet * self) G_GNUC_UNUSED;
static void lm_applet_class_init (LMAppletClass * class) G_GNUC_UNUSED;
static gboolean lm_applet_factory_cb (PanelApplet * applet, const char * iid, gpointer data) G_GNUC_UNUSED;
static gboolean lm_applet_socket_read_cb (GIOChannel * source, GIOCondition condition, gpointer data) G_GNUC_UNUSED;
static void lm_applet_reconfigure (LMApplet * self) G_GNUC_UNUSED;
static gboolean lm_applet_reconfigure_timeout_cb (gpointer data) G_GNUC_UNUSED;
static gboolean lm_applet_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data) G_GNUC_UNUSED;
static void lm_applet_preferences_cb (BonoboUIComponent * component, gpointer user_data, const char * cname) G_GNUC_UNUSED;
static void lm_applet_help_cb (BonoboUIComponent * component, gpointer user_data, const char * cname) G_GNUC_UNUSED;
static void lm_applet_about_cb (BonoboUIComponent * component, gpointer user_data, const char * cname) G_GNUC_UNUSED;
static void lm_applet_configure (LMApplet * self) G_GNUC_UNUSED;
static void lm_applet_sync_gconf_hosts (LMApplet * self) G_GNUC_UNUSED;
static unsigned int lm_applet_get_unique_seq (LMApplet * self) G_GNUC_UNUSED;
static LMHost * lm_applet_add_host_internal (LMApplet * self, const char * name) G_GNUC_UNUSED;
static LMHost * lm_applet_replace_host_internal (LMApplet * self, LMHost * old, const char * new) G_GNUC_UNUSED;
static void lm_applet_swap_hosts_internal (LMApplet * self, LMHost * host1, LMHost * host2) G_GNUC_UNUSED;
static void lm_applet_remove_host_internal (LMApplet * self, LMHost * host) G_GNUC_UNUSED;
static void lm_applet_host_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data) G_GNUC_UNUSED;
static void lm_applet_configure_progress_bar (LMApplet * self, LMHost * host) G_GNUC_UNUSED;
static void lm_applet_update_progress_bar (LMApplet * self, LMHost * host) G_GNUC_UNUSED;
static void lm_applet_update_tooltip (LMApplet * self) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__activate(object,func,data)	lm_applet_connect__activate((object),(func),(data))
#define self_connect_after__activate(object,func,data)	lm_applet_connect_after__activate((object),(func),(data))
#define self_connect_data__activate(object,func,data,destroy_data,flags)	lm_applet_connect_data__activate((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_preferences(object,func,data)	lm_applet_connect__activate_preferences((object),(func),(data))
#define self_connect_after__activate_preferences(object,func,data)	lm_applet_connect_after__activate_preferences((object),(func),(data))
#define self_connect_data__activate_preferences(object,func,data,destroy_data,flags)	lm_applet_connect_data__activate_preferences((object),(func),(data),(destroy_data),(flags))

enum {
	ACTIVATE_SIGNAL,
	ACTIVATE_PREFERENCES_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_HOSTS,
	PROP_DELAY,
	PROP_TIMEOUT,
	PROP_SCALE,
	PROP_PREFERENCES_WIDTH,
	PROP_PREFERENCES_HEIGHT
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static PanelAppletClass *parent_class = NULL;

/* Short form macros */
#define self_get_hosts lm_applet_get_hosts
#define self_set_hosts lm_applet_set_hosts
#define self_get_delay lm_applet_get_delay
#define self_set_delay lm_applet_set_delay
#define self_get_timeout lm_applet_get_timeout
#define self_set_timeout lm_applet_set_timeout
#define self_get_scale lm_applet_get_scale
#define self_set_scale lm_applet_set_scale
#define self_get_preferences_width lm_applet_get_preferences_width
#define self_set_preferences_width lm_applet_set_preferences_width
#define self_get_preferences_height lm_applet_get_preferences_height
#define self_set_preferences_height lm_applet_set_preferences_height
#define self_activate lm_applet_activate
#define self_activate_preferences lm_applet_activate_preferences
#define self_factory_cb lm_applet_factory_cb
#define self_socket_read_cb lm_applet_socket_read_cb
#define self_reconfigure lm_applet_reconfigure
#define self_reconfigure_timeout_cb lm_applet_reconfigure_timeout_cb
#define self_button_press_event_h lm_applet_button_press_event_h
#define self_preferences_cb lm_applet_preferences_cb
#define self_help_cb lm_applet_help_cb
#define self_about_cb lm_applet_about_cb
#define self_configure lm_applet_configure
#define self_factory_main lm_applet_factory_main
#define self_sync_gconf_hosts lm_applet_sync_gconf_hosts
#define self_get_unique_seq lm_applet_get_unique_seq
#define self_add_host_internal lm_applet_add_host_internal
#define self_replace_host_internal lm_applet_replace_host_internal
#define self_swap_hosts_internal lm_applet_swap_hosts_internal
#define self_remove_host_internal lm_applet_remove_host_internal
#define self_host_notify_h lm_applet_host_notify_h
#define self_configure_progress_bar lm_applet_configure_progress_bar
#define self_update_progress_bar lm_applet_update_progress_bar
#define self_update_tooltip lm_applet_update_tooltip
#define self_add_host lm_applet_add_host
#define self_replace_host lm_applet_replace_host
#define self_swap_hosts lm_applet_swap_hosts
#define self_remove_host lm_applet_remove_host
GType
lm_applet_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMAppletClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_applet_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMApplet),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_applet_init,
			NULL
		};

		type = g_type_register_static (PANEL_TYPE_APPLET, "LMApplet", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMApplet *)g_object_new(lm_applet_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMApplet * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMApplet *
GET_NEW_VARG (const char *first, ...)
{
	LMApplet *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMApplet *)g_object_new_valist (lm_applet_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Applet::dispose"
	LMApplet *self G_GNUC_UNUSED = LM_APPLET (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 194 "lm-applet.gob"
	if(self->_priv->tooltips) { ((*(void (*)(void *))g_object_unref)) (self->_priv->tooltips); self->_priv->tooltips = NULL; }
#line 231 "lm-applet.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Applet::finalize"
	LMApplet *self  G_GNUC_UNUSED = LM_APPLET (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#define watches (self->_priv->watches)
#define VAR watches
	{
#line 90 "lm-applet.gob"
	
      GSList *l;

      LM_LIST_FOREACH(l, VAR)
        {
	  WatchInfo *info = l->data;

	  g_source_remove(info->source_id);
	  g_io_channel_unref(info->channel);
	  g_free(info);
	}
      g_slist_free(VAR);
    }
#line 261 "lm-applet.c"
	memset(&watches, 0, sizeof(watches));
#undef VAR
#undef watches
#line 104 "lm-applet.gob"
	if(self->_priv->hosts) { ((*(void (*)(void *))lm_objects_free)) (self->_priv->hosts); self->_priv->hosts = NULL; }
#line 267 "lm-applet.c"
#define reconfigure_timeout_id (self->_priv->reconfigure_timeout_id)
#define VAR reconfigure_timeout_id
	{
#line 198 "lm-applet.gob"
	
      if (VAR)
	g_source_remove(VAR);
    }
#line 276 "lm-applet.c"
	memset(&reconfigure_timeout_id, 0, sizeof(reconfigure_timeout_id));
#undef VAR
#undef reconfigure_timeout_id
	g_free (priv);
}
#undef __GOB_FUNCTION__

static void 
lm_applet_init (LMApplet * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Applet::init"
	o->_priv = g_new0 (LMAppletPrivate, 1);
}
#undef __GOB_FUNCTION__
#line 215 "lm-applet.gob"
static void 
lm_applet_class_init (LMAppletClass * class G_GNUC_UNUSED)
#line 294 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	parent_class = g_type_class_ref (PANEL_TYPE_APPLET);

	object_signals[ACTIVATE_SIGNAL] =
		g_signal_new ("activate",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMAppletClass, activate),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_PREFERENCES_SIGNAL] =
		g_signal_new ("activate_preferences",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMAppletClass, activate_preferences),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

#line 203 "lm-applet.gob"
	class->activate = ___real_lm_applet_activate;
#line 209 "lm-applet.gob"
	class->activate_preferences = ___real_lm_applet_activate_preferences;
#line 322 "lm-applet.c"
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("hosts" /* name */,
		 NULL /* nick */,
		 _("The list of hosts") /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_HOSTS,
		param_spec);
	param_spec = g_param_spec_uint
		("delay" /* name */,
		 NULL /* nick */,
		 _("The amount of time to wait between sending each echo request to a particular host") /* blurb */,
		 LM_HOST_MIN_DELAY /* minimum */,
		 G_MAXUINT /* maximum */,
		 LM_HOST_MIN_DELAY /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DELAY,
		param_spec);
	param_spec = g_param_spec_uint
		("timeout" /* name */,
		 NULL /* nick */,
		 _("The delay after which a host is considered dead if no reply was received") /* blurb */,
		 LM_HOST_MIN_TIMEOUT /* minimum */,
		 G_MAXUINT /* maximum */,
		 LM_HOST_MIN_TIMEOUT /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_TIMEOUT,
		param_spec);
	param_spec = g_param_spec_uint
		("scale" /* name */,
		 NULL /* nick */,
		 _("The round-trip time a full bar represents") /* blurb */,
		 MIN_SCALE /* minimum */,
		 G_MAXUINT /* maximum */,
		 MIN_SCALE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SCALE,
		param_spec);
	param_spec = g_param_spec_int
		("preferences_width" /* name */,
		 NULL /* nick */,
		 _("The width of the preferences dialog") /* blurb */,
		 -1 /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_PREFERENCES_WIDTH /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PREFERENCES_WIDTH,
		param_spec);
	param_spec = g_param_spec_int
		("preferences_height" /* name */,
		 NULL /* nick */,
		 _("The height of the preferences dialog") /* blurb */,
		 -1 /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_PREFERENCES_HEIGHT /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PREFERENCES_HEIGHT,
		param_spec);
    }
 {
#line 216 "lm-applet.gob"

    GtkBindingSet *binding_set;

    binding_set = gtk_binding_set_by_class(class);
    
    gtk_binding_entry_add_signal(binding_set, GDK_Return, 0, "activate", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, 0, "activate", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, 0, "activate", 0);

    gtk_binding_entry_add_signal(binding_set, GDK_Return, GDK_MOD1_MASK, "activate-preferences", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, GDK_MOD1_MASK, "activate-preferences", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, GDK_MOD1_MASK, "activate-preferences", 0);
  
#line 409 "lm-applet.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Applet::set_property"
{
	LMApplet *self G_GNUC_UNUSED;

	self = LM_APPLET (object);

	switch (property_id) {
	case PROP_HOSTS:
		{
#line 105 "lm-applet.gob"
self->_priv->hosts = g_value_get_pointer (VAL);
#line 430 "lm-applet.c"
		}
		break;
	case PROP_DELAY:
		{
#line 113 "lm-applet.gob"

      GSList *l;

      selfp->delay = g_value_get_uint(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_DELAY, selfp->delay, NULL);
      LM_LIST_FOREACH(l, selfp->hosts)
	lm_host_set_delay(l->data, selfp->delay);
    
#line 444 "lm-applet.c"
		}
		break;
	case PROP_TIMEOUT:
		{
#line 132 "lm-applet.gob"

      GSList *l;

      selfp->timeout = g_value_get_uint(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_TIMEOUT, selfp->timeout, NULL);
      LM_LIST_FOREACH(l, selfp->hosts)
	lm_host_set_timeout(l->data, selfp->timeout);
    
#line 458 "lm-applet.c"
		}
		break;
	case PROP_SCALE:
		{
#line 151 "lm-applet.gob"

      GSList *l;

      selfp->scale = g_value_get_uint(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_SCALE, selfp->scale, NULL);
      LM_LIST_FOREACH(l, selfp->hosts)
	self_update_progress_bar(self, l->data);
    
#line 472 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_WIDTH:
		{
#line 170 "lm-applet.gob"

      selfp->preferences_width = g_value_get_int(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_PREFERENCES_WIDTH, selfp->preferences_width, NULL);
    
#line 482 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_HEIGHT:
		{
#line 185 "lm-applet.gob"

      selfp->preferences_height = g_value_get_int(VAL);
      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_PREFERENCES_HEIGHT, selfp->preferences_height, NULL);
    
#line 492 "lm-applet.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Applet::get_property"
{
	LMApplet *self G_GNUC_UNUSED;

	self = LM_APPLET (object);

	switch (property_id) {
	case PROP_HOSTS:
		{
#line 105 "lm-applet.gob"
g_value_set_pointer (VAL, self->_priv->hosts);
#line 523 "lm-applet.c"
		}
		break;
	case PROP_DELAY:
		{
#line 122 "lm-applet.gob"

      g_value_set_uint(VAL, selfp->delay);
    
#line 532 "lm-applet.c"
		}
		break;
	case PROP_TIMEOUT:
		{
#line 141 "lm-applet.gob"

      g_value_set_uint(VAL, selfp->timeout);
    
#line 541 "lm-applet.c"
		}
		break;
	case PROP_SCALE:
		{
#line 160 "lm-applet.gob"

      g_value_set_uint(VAL, selfp->scale);
    
#line 550 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_WIDTH:
		{
#line 175 "lm-applet.gob"

      g_value_set_int(VAL, selfp->preferences_width);
    
#line 559 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_HEIGHT:
		{
#line 190 "lm-applet.gob"

      g_value_set_int(VAL, selfp->preferences_height);
    
#line 568 "lm-applet.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 105 "lm-applet.gob"
gpointer 
lm_applet_get_hosts (LMApplet * self)
#line 587 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_hosts"
{
#line 105 "lm-applet.gob"
		gpointer val; g_object_get (G_OBJECT (self), "hosts", &val, NULL); return val;
}}
#line 594 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 105 "lm-applet.gob"
void 
lm_applet_set_hosts (LMApplet * self, gpointer val)
#line 600 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_hosts"
{
#line 105 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "hosts", val, NULL);
}}
#line 607 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 122 "lm-applet.gob"
guint 
lm_applet_get_delay (LMApplet * self)
#line 613 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_delay"
{
#line 108 "lm-applet.gob"
		guint val; g_object_get (G_OBJECT (self), "delay", &val, NULL); return val;
}}
#line 620 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 113 "lm-applet.gob"
void 
lm_applet_set_delay (LMApplet * self, guint val)
#line 626 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_delay"
{
#line 108 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "delay", val, NULL);
}}
#line 633 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 141 "lm-applet.gob"
guint 
lm_applet_get_timeout (LMApplet * self)
#line 639 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_timeout"
{
#line 127 "lm-applet.gob"
		guint val; g_object_get (G_OBJECT (self), "timeout", &val, NULL); return val;
}}
#line 646 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 132 "lm-applet.gob"
void 
lm_applet_set_timeout (LMApplet * self, guint val)
#line 652 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_timeout"
{
#line 127 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "timeout", val, NULL);
}}
#line 659 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 160 "lm-applet.gob"
guint 
lm_applet_get_scale (LMApplet * self)
#line 665 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_scale"
{
#line 146 "lm-applet.gob"
		guint val; g_object_get (G_OBJECT (self), "scale", &val, NULL); return val;
}}
#line 672 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 151 "lm-applet.gob"
void 
lm_applet_set_scale (LMApplet * self, guint val)
#line 678 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_scale"
{
#line 146 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "scale", val, NULL);
}}
#line 685 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 175 "lm-applet.gob"
gint 
lm_applet_get_preferences_width (LMApplet * self)
#line 691 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_preferences_width"
{
#line 165 "lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "preferences_width", &val, NULL); return val;
}}
#line 698 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 170 "lm-applet.gob"
void 
lm_applet_set_preferences_width (LMApplet * self, gint val)
#line 704 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_preferences_width"
{
#line 165 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "preferences_width", val, NULL);
}}
#line 711 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 190 "lm-applet.gob"
gint 
lm_applet_get_preferences_height (LMApplet * self)
#line 717 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_preferences_height"
{
#line 180 "lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "preferences_height", &val, NULL); return val;
}}
#line 724 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 185 "lm-applet.gob"
void 
lm_applet_set_preferences_height (LMApplet * self, gint val)
#line 730 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::set_preferences_height"
{
#line 180 "lm-applet.gob"
		g_object_set (G_OBJECT (self), "preferences_height", val, NULL);
}}
#line 737 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 203 "lm-applet.gob"
static void 
lm_applet_activate (LMApplet * self)
#line 743 "lm-applet.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 203 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 203 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 755 "lm-applet.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 203 "lm-applet.gob"
static void 
___real_lm_applet_activate (LMApplet * self G_GNUC_UNUSED)
#line 771 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::activate"
{
#line 205 "lm-applet.gob"
	
    lm_preferences_display();
  }}
#line 779 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 209 "lm-applet.gob"
static void 
lm_applet_activate_preferences (LMApplet * self)
#line 785 "lm-applet.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 209 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 209 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 797 "lm-applet.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_PREFERENCES_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 209 "lm-applet.gob"
static void 
___real_lm_applet_activate_preferences (LMApplet * self G_GNUC_UNUSED)
#line 813 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::activate_preferences"
{
#line 211 "lm-applet.gob"
	
    lm_preferences_display();
  }}
#line 821 "lm-applet.c"
#undef __GOB_FUNCTION__


#line 230 "lm-applet.gob"
static gboolean 
lm_applet_factory_cb (PanelApplet * applet, const char * iid, gpointer data)
#line 828 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::factory_cb"
#line 230 "lm-applet.gob"
	g_return_val_if_fail (applet != NULL, (gboolean )0);
#line 230 "lm-applet.gob"
	g_return_val_if_fail (PANEL_IS_APPLET (applet), (gboolean )0);
#line 230 "lm-applet.gob"
	g_return_val_if_fail (iid != NULL, (gboolean )0);
#line 837 "lm-applet.c"
{
#line 234 "lm-applet.gob"
	
    if (! strcmp(iid, "OAFIID:GNOME_LinkMonitorApplet"))
      {
	Self *self = SELF(applet);
	const BonoboUIVerb menu_verbs[] = {
	  BONOBO_UI_VERB("LinkMonitorPreferences", self_preferences_cb),
	  BONOBO_UI_VERB("LinkMonitorHelp", self_help_cb),
	  BONOBO_UI_VERB("LinkMonitorAbout", self_about_cb),
	  BONOBO_UI_VERB_END
	};
	GSList *gconf_hosts;
	GSList *l;

	lm_applet = self;
	g_object_add_weak_pointer(G_OBJECT(self), (gpointer *) &lm_applet);
	
	panel_applet_add_preferences(applet, "/schemas/apps/link-monitor-applet/prefs", NULL);

	selfp->tooltips = gtk_tooltips_new();
	g_object_ref(selfp->tooltips);
	gtk_object_sink(GTK_OBJECT(selfp->tooltips));

	panel_applet_setup_menu_from_file(applet, DATADIR, "GNOME_LinkMonitorApplet.xml", NULL, menu_verbs, applet);

	LM_LIST_FOREACH(l, lm_sockets_get())
          {
	    LMSocket *s = l->data;

	    if (! s->error)
	      {
		WatchInfo *info;
		
		info = g_new(WatchInfo, 1);
		info->channel = g_io_channel_unix_new(s->s);
		info->s = s;
		info->applet = self;

		info->source_id = g_io_add_watch_full(info->channel, G_PRIORITY_HIGH, G_IO_IN, self_socket_read_cb, info, NULL);
		selfp->watches = g_slist_append(selfp->watches, info);
	      }
	  }

	selfp->delay = panel_applet_gconf_get_int(applet, CONF_DELAY, NULL);
	if (selfp->delay < LM_HOST_MIN_DELAY)
	  selfp->delay = LM_HOST_MIN_DELAY;
      
	selfp->timeout = panel_applet_gconf_get_int(applet, CONF_TIMEOUT, NULL);
	if (selfp->timeout < LM_HOST_MIN_TIMEOUT)
	  selfp->timeout = LM_HOST_MIN_TIMEOUT;

	selfp->scale = panel_applet_gconf_get_int(applet, CONF_SCALE, NULL);
	if (selfp->scale < MIN_SCALE)
	  selfp->scale = MIN_SCALE;

	selfp->preferences_width = panel_applet_gconf_get_int(applet, CONF_PREFERENCES_WIDTH, NULL);
	if (! selfp->preferences_width)
	  selfp->preferences_width = DEFAULT_PREFERENCES_WIDTH;

	selfp->preferences_height = panel_applet_gconf_get_int(applet, CONF_PREFERENCES_HEIGHT, NULL);
	if (! selfp->preferences_height)
	  selfp->preferences_height = DEFAULT_PREFERENCES_HEIGHT;

	gconf_hosts = panel_applet_gconf_get_list(applet, CONF_HOSTS, GCONF_VALUE_STRING, NULL);
	LM_LIST_FOREACH(l, gconf_hosts)
	  self_add_host_internal(self, l->data);
	lm_pointers_free(gconf_hosts);

	self_configure(self);
	self_update_tooltip(self);

	g_signal_connect(G_OBJECT(self), "button-press-event", G_CALLBACK(self_button_press_event_h), NULL);
	g_signal_connect(G_OBJECT(self), "change-orient", G_CALLBACK(self_reconfigure), NULL);
	g_signal_connect(G_OBJECT(self), "change-size", G_CALLBACK(self_reconfigure), NULL);

	gtk_widget_show(GTK_WIDGET(self));

	return TRUE;
      }

    return FALSE;
  }}
#line 921 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 316 "lm-applet.gob"
static gboolean 
lm_applet_socket_read_cb (GIOChannel * source, GIOCondition condition, gpointer data)
#line 927 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::socket_read_cb"
#line 316 "lm-applet.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 932 "lm-applet.c"
{
#line 320 "lm-applet.gob"
	
    WatchInfo *info = data;
    LMICMPReply reply;

    GDK_THREADS_ENTER();

    if (lm_icmp_receive(info->s, &reply))
      {
	GSList *l;

	LM_LIST_FOREACH(l, info->applet->_priv->hosts)
          {
	    LMHost *host = l->data;
	  
	    if (lm_host_get_seq(host) == reply.seq)
	      {
		if (reply.echo_reply)
		  lm_host_set_roundtrip_time(host, reply.roundtrip_time);
		else
		  lm_host_set_error(host, reply.description);
	      }
	  }
      }

    GDK_THREADS_LEAVE();
    
    return TRUE;		/* keep source */
  }}
#line 963 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 349 "lm-applet.gob"
static void 
lm_applet_reconfigure (LMApplet * self)
#line 969 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reconfigure"
#line 349 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 349 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 976 "lm-applet.c"
{
#line 351 "lm-applet.gob"
	
    if (selfp->reconfigure_timeout_id)
      /* cancel the previously queued reconfigure */
      g_source_remove(selfp->reconfigure_timeout_id);

    /* do not flood the panel with reconfigures, queue it */
    selfp->reconfigure_timeout_id = g_timeout_add(10, self_reconfigure_timeout_cb, self);
  }}
#line 987 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 360 "lm-applet.gob"
static gboolean 
lm_applet_reconfigure_timeout_cb (gpointer data)
#line 993 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::reconfigure_timeout_cb"
#line 360 "lm-applet.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 998 "lm-applet.c"
{
#line 362 "lm-applet.gob"
	
    Self *self = data;
    GSList *l;

    GDK_THREADS_ENTER();

    self_configure(self);
    LM_LIST_FOREACH(l, selfp->hosts)
      {
	self_configure_progress_bar(self, l->data);
	self_update_progress_bar(self, l->data);
      }
    
    GDK_THREADS_LEAVE();

    return FALSE;		/* remove source */
  }}
#line 1018 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 380 "lm-applet.gob"
static gboolean 
lm_applet_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
#line 1024 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::button_press_event_h"
#line 380 "lm-applet.gob"
	g_return_val_if_fail (widget != NULL, (gboolean )0);
#line 380 "lm-applet.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (widget), (gboolean )0);
#line 380 "lm-applet.gob"
	g_return_val_if_fail (event != NULL, (gboolean )0);
#line 1033 "lm-applet.c"
{
#line 384 "lm-applet.gob"
	
    if (event->button == 1 && event->type == GDK_2BUTTON_PRESS)
      {
	self_activate(SELF(widget));
	return TRUE;		/* do not propagate event */
      }

    return FALSE;		/* propagate event */
  }}
#line 1045 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 394 "lm-applet.gob"
static void 
lm_applet_preferences_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
#line 1051 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::preferences_cb"
#line 394 "lm-applet.gob"
	g_return_if_fail (user_data != NULL);
#line 1056 "lm-applet.c"
{
#line 398 "lm-applet.gob"
	
    Self *self = user_data;

    self_activate_preferences(self);
  }}
#line 1064 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 404 "lm-applet.gob"
static void 
lm_applet_help_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
#line 1070 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::help_cb"
#line 404 "lm-applet.gob"
	g_return_if_fail (user_data != NULL);
#line 1075 "lm-applet.c"
{
#line 408 "lm-applet.gob"
	
    lm_display_help(NULL);
  }}
#line 1081 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 412 "lm-applet.gob"
static void 
lm_applet_about_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
#line 1087 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::about_cb"
#line 412 "lm-applet.gob"
	g_return_if_fail (user_data != NULL);
#line 1092 "lm-applet.c"
{
#line 416 "lm-applet.gob"
	
    Self *self = user_data;
    static const char *authors[] = { "Jean-Yves Lefort <jylefort@brutele.be>", NULL };
    static const char *documenters[] = { "Jean-Yves Lefort <jylefort@brutele.be>", NULL };
    GdkPixbuf *logo;
    GdkPixbuf *icon;

    if (selfp->about)
      {
	gtk_window_present(GTK_WINDOW(selfp->about));
	return;
      }

    logo = lm_pixbuf_new("about-logo.png");
    selfp->about = gnome_about_new(_("Link Monitor"),
				   VERSION,
				   "Copyright \302\251 2004 Jean-Yves Lefort",
				   _("The Link Monitor displays the round-trip time to one or more hosts."),
				   authors,
				   documenters,
				   _("Jean-Yves Lefort <jylefort@brutele.be>"),
				   logo);
    g_object_unref(logo);

    icon = lm_pixbuf_new("link-monitor-applet.png");
    if (icon)
      {
	gtk_window_set_icon(GTK_WINDOW(selfp->about), icon);
	g_object_unref(icon);
      }
  
    g_object_add_weak_pointer(G_OBJECT(selfp->about), (gpointer *) &selfp->about);
    gtk_widget_show(selfp->about);
  }}
#line 1129 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 451 "lm-applet.gob"
static void 
lm_applet_configure (LMApplet * self)
#line 1135 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::configure"
#line 451 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 451 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1142 "lm-applet.c"
{
#line 453 "lm-applet.gob"
	
    GSList *l;
    GtkWidget *child;

    /* ref the progress bars to keep them alive when we'll remove the box */
    LM_LIST_FOREACH(l, selfp->hosts)
      {
	LMHost *host = l->data;
	GtkWidget *progress_bar;

	progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
	g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

	g_object_ref(progress_bar);
	gtk_object_sink(GTK_OBJECT(progress_bar));
      }
  
    child = gtk_bin_get_child(GTK_BIN(self));
    if (child)
      gtk_container_remove(GTK_CONTAINER(self), child);

    if (selfp->hosts)
      {
	PanelAppletOrient orient;

	orient = panel_applet_get_orient(PANEL_APPLET(self));

	switch (orient)
	  {
	  case PANEL_APPLET_ORIENT_UP:
	  case PANEL_APPLET_ORIENT_DOWN:
	    child = gtk_hbox_new(FALSE, BAR_SPACING);
	    break;
	    
	  case PANEL_APPLET_ORIENT_LEFT:
	  case PANEL_APPLET_ORIENT_RIGHT:
	    child = gtk_vbox_new(FALSE, BAR_SPACING);
	    break;
      
	  default:
	    g_return_if_reached();
	  }

	LM_LIST_FOREACH(l, selfp->hosts)
          {
	    LMHost *host = l->data;
	    GtkWidget *progress_bar;

	    progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
	    g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

	    gtk_box_pack_start(GTK_BOX(child), progress_bar, FALSE, FALSE, 0);
	    gtk_widget_show(progress_bar);

	    g_object_unref(progress_bar);
	  }
      }
    else
      {
	GdkPixbuf *pixbuf;
	
	pixbuf = lm_pixbuf_new("link-monitor-applet.png");
	if (pixbuf)
	  {
	    int size;
	    GdkPixbuf *scaled;

	    size = panel_applet_get_size(PANEL_APPLET(self)) - (ICON_PADDING * 2);
	    scaled = gdk_pixbuf_scale_simple(pixbuf, size, size, GDK_INTERP_BILINEAR);
	    g_object_unref(pixbuf);
	  
	    child = gtk_image_new_from_pixbuf(scaled);
	    g_object_unref(scaled);
	  }
	else			/* use label as fallback */
	  {
	    child = gtk_label_new(_("<span size=\"small\">Link Monitor</span>"));
	    gtk_label_set_use_markup(GTK_LABEL(child), TRUE);
	  }
      }

    gtk_container_add(GTK_CONTAINER(self), child);
    gtk_widget_show(child);
  }}
#line 1229 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 538 "lm-applet.gob"
int 
lm_applet_factory_main (void)
#line 1235 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::factory_main"
{
#line 540 "lm-applet.gob"
	
    return panel_applet_factory_main("OAFIID:GNOME_LinkMonitorApplet_Factory",
				     TYPE_SELF,
				     self_factory_cb,
				     NULL);
  }}
#line 1246 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 547 "lm-applet.gob"
static void 
lm_applet_sync_gconf_hosts (LMApplet * self)
#line 1252 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::sync_gconf_hosts"
#line 547 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 547 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1259 "lm-applet.c"
{
#line 549 "lm-applet.gob"
	
    GSList *gconf_hosts = NULL;
    GSList *l;

    LM_LIST_FOREACH(l, selfp->hosts)
      gconf_hosts = g_slist_append(gconf_hosts, g_strdup(lm_host_get_name(l->data)));

    panel_applet_gconf_set_list(PANEL_APPLET(self),
				CONF_HOSTS,
				GCONF_VALUE_STRING,
				gconf_hosts,
				NULL);
    lm_pointers_free(gconf_hosts);
  }}
#line 1276 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 564 "lm-applet.gob"
static unsigned int 
lm_applet_get_unique_seq (LMApplet * self)
#line 1282 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::get_unique_seq"
#line 564 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (unsigned int )0);
#line 564 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (unsigned int )0);
#line 1289 "lm-applet.c"
{
#line 566 "lm-applet.gob"
	
    unsigned int seq = 0;
    GSList *l;
    
  loop:
    LM_LIST_FOREACH(l, selfp->hosts)
      if (lm_host_get_seq(l->data) == seq)
	{
	  seq++;
	  goto loop;
	}

    return seq;
  }}
#line 1306 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 581 "lm-applet.gob"
static LMHost * 
lm_applet_add_host_internal (LMApplet * self, const char * name)
#line 1312 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::add_host_internal"
#line 581 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 581 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 581 "lm-applet.gob"
	g_return_val_if_fail (name != NULL, (LMHost * )0);
#line 1321 "lm-applet.c"
{
#line 583 "lm-applet.gob"
	
    LMHost *host;
    GtkWidget *progress_bar;
    GtkWidget *child;

    host = lm_host_new(name, self_get_unique_seq(self), selfp->delay, selfp->timeout);

    progress_bar = gtk_progress_bar_new();
    g_object_set_data(G_OBJECT(host), KEY_PROGRESS_BAR, progress_bar);

    selfp->hosts = g_slist_append(selfp->hosts, host);
    g_signal_connect(G_OBJECT(host), "notify", G_CALLBACK(self_host_notify_h), self);

    self_configure_progress_bar(self, host);
    self_update_progress_bar(self, host);
    self_update_tooltip(self);

    child = gtk_bin_get_child(GTK_BIN(self));
    if (child && GTK_IS_BOX(child))
      {
	gtk_box_pack_start(GTK_BOX(child), progress_bar, FALSE, FALSE, 0);
	gtk_widget_show(progress_bar);
      }
    else
      self_configure(self);

    return host;
  }}
#line 1352 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 612 "lm-applet.gob"
static LMHost * 
lm_applet_replace_host_internal (LMApplet * self, LMHost * old, const char * new)
#line 1358 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::replace_host_internal"
#line 612 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 612 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 612 "lm-applet.gob"
	g_return_val_if_fail (old != NULL, (LMHost * )0);
#line 612 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_HOST (old), (LMHost * )0);
#line 612 "lm-applet.gob"
	g_return_val_if_fail (new != NULL, (LMHost * )0);
#line 1371 "lm-applet.c"
{
#line 616 "lm-applet.gob"
	
    GSList *elem;
    unsigned int seq;
    GtkWidget *progress_bar;
    LMHost *new_host;

    elem = g_slist_find(selfp->hosts, old);
    g_return_val_if_fail(elem != NULL, NULL);

    seq = self_get_unique_seq(self);

    progress_bar = g_object_get_data(G_OBJECT(old), KEY_PROGRESS_BAR);
    g_return_val_if_fail(GTK_IS_PROGRESS_BAR(progress_bar), NULL);

    g_object_unref(old);

    new_host = lm_host_new(new, seq, selfp->delay, selfp->timeout);
    g_object_set_data(G_OBJECT(new_host), KEY_PROGRESS_BAR, progress_bar);

    elem->data = new_host;
    g_signal_connect(G_OBJECT(new_host), "notify", G_CALLBACK(self_host_notify_h), self);

    self_update_progress_bar(self, new_host);
    self_update_tooltip(self);
    
    return new_host;
  }}
#line 1401 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 644 "lm-applet.gob"
static void 
lm_applet_swap_hosts_internal (LMApplet * self, LMHost * host1, LMHost * host2)
#line 1407 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::swap_hosts_internal"
#line 644 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 644 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 644 "lm-applet.gob"
	g_return_if_fail (host1 != NULL);
#line 644 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host1));
#line 644 "lm-applet.gob"
	g_return_if_fail (host2 != NULL);
#line 644 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host2));
#line 1422 "lm-applet.c"
{
#line 648 "lm-applet.gob"
	
    GSList *elem1 = NULL;
    GSList *elem2 = NULL;
    LMHost *tmp;
    GSList *l;
      
    elem1 = g_slist_find(selfp->hosts, host1);
    elem2 = g_slist_find(selfp->hosts, host2);

    g_return_if_fail(elem1 != NULL && elem2 != NULL && elem1 != elem2);

    tmp = elem1->data;
    elem1->data = elem2->data;
    elem2->data = tmp;

    self_update_tooltip(self);
    self_configure(self);

    LM_LIST_FOREACH(l, selfp->hosts)
      self_update_progress_bar(self, l->data);
  }}
#line 1446 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 670 "lm-applet.gob"
static void 
lm_applet_remove_host_internal (LMApplet * self, LMHost * host)
#line 1452 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::remove_host_internal"
#line 670 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 670 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 670 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 670 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1463 "lm-applet.c"
{
#line 672 "lm-applet.gob"
	
    GSList *elem;
    GtkWidget *progress_bar;

    elem = g_slist_find(selfp->hosts, host);
    g_return_if_fail(elem != NULL);

    progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
    g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

    selfp->hosts = g_slist_delete_link(selfp->hosts, elem);
    g_object_unref(host);
    gtk_widget_destroy(progress_bar);

    self_update_tooltip(self);
    if (! selfp->hosts)
      self_configure(self);
  }}
#line 1484 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 691 "lm-applet.gob"
static void 
lm_applet_host_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data)
#line 1490 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::host_notify_h"
#line 691 "lm-applet.gob"
	g_return_if_fail (object != NULL);
#line 691 "lm-applet.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 691 "lm-applet.gob"
	g_return_if_fail (pspec != NULL);
#line 691 "lm-applet.gob"
	g_return_if_fail (user_data != NULL);
#line 1501 "lm-applet.c"
{
#line 695 "lm-applet.gob"
	
    LMHost *host = LM_HOST(object);
    const char *name = g_param_spec_get_name(pspec);
    Self *self = user_data;

    if (! strcmp(name, "alive") || ! strcmp(name, "roundtrip-time"))
      self_update_progress_bar(self, host);
    else if (! strcmp(name, "status"))
      self_update_tooltip(self);
  }}
#line 1514 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 706 "lm-applet.gob"
static void 
lm_applet_configure_progress_bar (LMApplet * self, LMHost * host)
#line 1520 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::configure_progress_bar"
#line 706 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 706 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 706 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 706 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1531 "lm-applet.c"
{
#line 708 "lm-applet.gob"
	
    GtkWidget *progress_bar;
    PanelAppletOrient orient;
    int size;

    progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
    g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

    orient = panel_applet_get_orient(PANEL_APPLET(self));
    size = panel_applet_get_size(PANEL_APPLET(self)) - (BAR_PADDING * 2);

    switch (orient)
      {
      case PANEL_APPLET_ORIENT_UP:
      case PANEL_APPLET_ORIENT_DOWN:
	gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_BOTTOM_TO_TOP);
	gtk_widget_set_size_request(progress_bar, BAR_THICKNESS, size);
	break;
	  
      case PANEL_APPLET_ORIENT_LEFT:
      case PANEL_APPLET_ORIENT_RIGHT:
	gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(progress_bar), GTK_PROGRESS_LEFT_TO_RIGHT);
	gtk_widget_set_size_request(progress_bar, size, BAR_THICKNESS);
	break;
      
      default:
	g_return_if_reached();
      }
  }}
#line 1563 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 738 "lm-applet.gob"
static void 
lm_applet_update_progress_bar (LMApplet * self, LMHost * host)
#line 1569 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::update_progress_bar"
#line 738 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 738 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 738 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 738 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1580 "lm-applet.c"
{
#line 740 "lm-applet.gob"
	
    GtkWidget *progress_bar;

    progress_bar = g_object_get_data(G_OBJECT(host), KEY_PROGRESS_BAR);
    g_return_if_fail(GTK_IS_PROGRESS_BAR(progress_bar));

    if (lm_host_get_alive(host))
      {
	double fraction;

	fraction = lm_host_get_roundtrip_time(host) / selfp->scale;
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress_bar), CLAMP(fraction, 0.0, 1.0));
	gtk_widget_modify_bg(progress_bar, GTK_STATE_NORMAL, NULL);
      }
    else
      {
	const GdkColor color = { 0, 0xFFFF, 0x0000, 0x0000 }; /* red */
      
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress_bar), 0);
	gtk_widget_modify_bg(progress_bar, GTK_STATE_NORMAL, &color);
      }
  }}
#line 1605 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 763 "lm-applet.gob"
static void 
lm_applet_update_tooltip (LMApplet * self)
#line 1611 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::update_tooltip"
#line 763 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 763 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1618 "lm-applet.c"
{
#line 765 "lm-applet.gob"
	
    GString *tip;
    GSList *l;

    tip = g_string_new(NULL);
    LM_LIST_FOREACH(l, selfp->hosts)
      {
	LMHost *host = l->data;
	const char *name;
	const char *ip;
	const char *status;

	if (*tip->str)
	  g_string_append_c(tip, '\n');

	name = lm_host_get_name(host);
	ip = lm_host_get_ip(host);
	status = lm_host_get_status(host);

	if (ip && strcmp(ip, name))
	  g_string_append_printf(tip, "\342\200\242 %s (%s): %s", name, ip, status);
	else
	  g_string_append_printf(tip, "\342\200\242 %s: %s", name, status);
      }

    if (! *tip->str)
      g_string_assign(tip, _("No host is being monitored."));
  
    gtk_tooltips_set_tip(selfp->tooltips, GTK_WIDGET(self), tip->str, NULL);
    g_string_free(tip, TRUE);
  }}
#line 1652 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 797 "lm-applet.gob"
LMHost * 
lm_applet_add_host (LMApplet * self, const char * name)
#line 1658 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::add_host"
#line 797 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 797 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 797 "lm-applet.gob"
	g_return_val_if_fail (name != NULL, (LMHost * )0);
#line 1667 "lm-applet.c"
{
#line 799 "lm-applet.gob"
	
    LMHost *host;

    host = self_add_host_internal(self, name);
    self_sync_gconf_hosts(self);

    return host;
  }}
#line 1678 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 808 "lm-applet.gob"
LMHost * 
lm_applet_replace_host (LMApplet * self, LMHost * old, const char * new)
#line 1684 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::replace_host"
#line 808 "lm-applet.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 808 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (LMHost * )0);
#line 808 "lm-applet.gob"
	g_return_val_if_fail (old != NULL, (LMHost * )0);
#line 808 "lm-applet.gob"
	g_return_val_if_fail (LM_IS_HOST (old), (LMHost * )0);
#line 808 "lm-applet.gob"
	g_return_val_if_fail (new != NULL, (LMHost * )0);
#line 1697 "lm-applet.c"
{
#line 812 "lm-applet.gob"
	
    LMHost *new_host;

    new_host = self_replace_host_internal(self, old, new);
    self_sync_gconf_hosts(self);

    return new_host;
  }}
#line 1708 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 821 "lm-applet.gob"
void 
lm_applet_swap_hosts (LMApplet * self, LMHost * host1, LMHost * host2)
#line 1714 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::swap_hosts"
#line 821 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 821 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 821 "lm-applet.gob"
	g_return_if_fail (host1 != NULL);
#line 821 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host1));
#line 821 "lm-applet.gob"
	g_return_if_fail (host2 != NULL);
#line 821 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host2));
#line 1729 "lm-applet.c"
{
#line 825 "lm-applet.gob"
	
    self_swap_hosts_internal(self, host1, host2);
    self_sync_gconf_hosts(self);
  }}
#line 1736 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 830 "lm-applet.gob"
void 
lm_applet_remove_host (LMApplet * self, LMHost * host)
#line 1742 "lm-applet.c"
{
#define __GOB_FUNCTION__ "LM:Applet::remove_host"
#line 830 "lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 830 "lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 830 "lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 830 "lm-applet.gob"
	g_return_if_fail (LM_IS_HOST (host));
#line 1753 "lm-applet.c"
{
#line 832 "lm-applet.gob"
	
    self_remove_host_internal(self, host);
    self_sync_gconf_hosts(self);
  }}
#line 1760 "lm-applet.c"
#undef __GOB_FUNCTION__
