/* Generated by GOB (v2.0.10) on Sat Oct  9 03:33:05 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 10

#define selfp (self->_priv)

#include "lm-host.h"

#include "lm-host-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 44 "lm-host.gob"

#include "config.h"
#include <stdio.h>		/* required by stdlib.h on Darwin */
#include <stdlib.h>		/* required by sys/socket.h on Darwin */
#include <string.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <glib/gi18n-lib.h>
#include <eel/eel.h>
#include "lm-icmp.h"
#include "lm-sockets.h"
#include "lm-util.h"

#line 41 "lm-host.c"
/* self casting macros */
#define SELF(x) LM_HOST(x)
#define SELF_CONST(x) LM_HOST_CONST(x)
#define IS_SELF(x) LM_IS_HOST(x)
#define TYPE_SELF LM_TYPE_HOST
#define SELF_CLASS(x) LM_HOST_CLASS(x)

#define SELF_GET_CLASS(x) LM_HOST_GET_CLASS(x)

/* self typedefs */
typedef LMHost Self;
typedef LMHostClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lm_host_init (LMHost * o) G_GNUC_UNUSED;
static void lm_host_class_init (LMHostClass * c) G_GNUC_UNUSED;
static void lm_host_set_status (LMHost * self, const char * format, ...) G_GNUC_UNUSED;
static void ___11_lm_host_finalize (GObject * object) G_GNUC_UNUSED;
static GObject * ___12_lm_host_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gpointer lm_host_constructor_thread_cb (gpointer data) G_GNUC_UNUSED;
static void lm_host_send_echo_request (LMHost * self) G_GNUC_UNUSED;
static void lm_host_install_send_timeout (LMHost * self) G_GNUC_UNUSED;
static gboolean lm_host_send_timeout_cb (gpointer data) G_GNUC_UNUSED;
static gboolean lm_host_dead_timeout_cb (gpointer data) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_NAME,
	PROP_IP,
	PROP_SEQ,
	PROP_DELAY,
	PROP_TIMEOUT,
	PROP_ALIVE,
	PROP_ROUNDTRIP_TIME,
	PROP_ERROR,
	PROP_STATUS
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_name lm_host_get_name
#define self_get_ip lm_host_get_ip
#define self_get_seq lm_host_get_seq
#define self_set_seq lm_host_set_seq
#define self_get_delay lm_host_get_delay
#define self_set_delay lm_host_set_delay
#define self_get_timeout lm_host_get_timeout
#define self_set_timeout lm_host_set_timeout
#define self_get_alive lm_host_get_alive
#define self_set_alive lm_host_set_alive
#define self_get_roundtrip_time lm_host_get_roundtrip_time
#define self_set_roundtrip_time lm_host_set_roundtrip_time
#define self_set_error lm_host_set_error
#define self_get_error lm_host_get_error
#define self_set_status lm_host_set_status
#define self_get_status lm_host_get_status
#define self_constructor_thread_cb lm_host_constructor_thread_cb
#define self_send_echo_request lm_host_send_echo_request
#define self_install_send_timeout lm_host_install_send_timeout
#define self_send_timeout_cb lm_host_send_timeout_cb
#define self_dead_timeout_cb lm_host_dead_timeout_cb
#define self_new lm_host_new
GType
lm_host_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMHostClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_host_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMHost),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_host_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LMHost", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMHost *)g_object_new(lm_host_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMHost * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMHost *
GET_NEW_VARG (const char *first, ...)
{
	LMHost *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMHost *)g_object_new_valist (lm_host_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Host::finalize"
	LMHost *self G_GNUC_UNUSED = LM_HOST (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 199 "lm-host.gob"
	___11_lm_host_finalize(obj_self);
#line 159 "lm-host.c"
#line 62 "lm-host.gob"
	if(self->_priv->name) { g_free ((gpointer) self->_priv->name); self->_priv->name = NULL; }
#line 162 "lm-host.c"
#line 72 "lm-host.gob"
	if(self->_priv->addrinfo) { freeaddrinfo ((gpointer) self->_priv->addrinfo); self->_priv->addrinfo = NULL; }
#line 165 "lm-host.c"
#line 74 "lm-host.gob"
	if(self->_priv->ip) { g_free ((gpointer) self->_priv->ip); self->_priv->ip = NULL; }
#line 168 "lm-host.c"
#line 145 "lm-host.gob"
	if(self->_priv->error) { g_free ((gpointer) self->_priv->error); self->_priv->error = NULL; }
#line 171 "lm-host.c"
#line 177 "lm-host.gob"
	if(self->_priv->status) { g_free ((gpointer) self->_priv->status); self->_priv->status = NULL; }
#line 174 "lm-host.c"
}
#undef __GOB_FUNCTION__

static void 
lm_host_init (LMHost * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Host::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,LMHostPrivate);
}
#undef __GOB_FUNCTION__
static void 
lm_host_class_init (LMHostClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Host::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LMHostPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 199 "lm-host.gob"
	g_object_class->finalize = ___finalize;
#line 212 "lm-host.gob"
	g_object_class->constructor = ___12_lm_host_constructor;
#line 199 "lm-host.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("name" /* name */,
		 NULL /* nick */,
		 _("The hostname or IP address as given by the user") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_NAME,
		param_spec);
	param_spec = g_param_spec_string
		("ip" /* name */,
		 NULL /* nick */,
		 _("The string representation of the IP address") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_IP,
		param_spec);
	param_spec = g_param_spec_uint
		("seq" /* name */,
		 NULL /* nick */,
		 _("The sequence number assigned to the host") /* blurb */,
		 0 /* minimum */,
		 G_MAXUINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SEQ,
		param_spec);
	param_spec = g_param_spec_uint
		("delay" /* name */,
		 NULL /* nick */,
		 _("The amount of time to wait between sending each echo request") /* blurb */,
		 LM_HOST_MIN_DELAY /* minimum */,
		 G_MAXUINT /* maximum */,
		 LM_HOST_MIN_DELAY /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_DELAY,
		param_spec);
	param_spec = g_param_spec_uint
		("timeout" /* name */,
		 NULL /* nick */,
		 _("The delay after which the host is considered dead if no reply was received") /* blurb */,
		 LM_HOST_MIN_TIMEOUT /* minimum */,
		 G_MAXUINT /* maximum */,
		 LM_HOST_MIN_TIMEOUT /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_TIMEOUT,
		param_spec);
	param_spec = g_param_spec_boolean
		("alive" /* name */,
		 NULL /* nick */,
		 _("Whether the host is alive or not") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ALIVE,
		param_spec);
	param_spec = g_param_spec_double
		("roundtrip_time" /* name */,
		 NULL /* nick */,
		 _("The last round-trip time") /* blurb */,
		 0 /* minimum */,
		 G_MAXDOUBLE /* maximum */,
		 0.0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ROUNDTRIP_TIME,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 _("The last error") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
	param_spec = g_param_spec_string
		("status" /* name */,
		 NULL /* nick */,
		 _("The status of the host") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_STATUS,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Host::set_property"
{
	LMHost *self G_GNUC_UNUSED;

	self = LM_HOST (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 63 "lm-host.gob"
{ char *old = self->_priv->name; self->_priv->name = g_value_dup_string (VAL); g_free (old); }
#line 314 "lm-host.c"
		}
		break;
	case PROP_IP:
		{
#line 75 "lm-host.gob"
{ char *old = self->_priv->ip; self->_priv->ip = g_value_dup_string (VAL); g_free (old); }
#line 321 "lm-host.c"
		}
		break;
	case PROP_SEQ:
		{
#line 84 "lm-host.gob"
self->_priv->seq = g_value_get_uint (VAL);
#line 328 "lm-host.c"
		}
		break;
	case PROP_DELAY:
		{
#line 96 "lm-host.gob"

      selfp->delay = g_value_get_uint(VAL);
      if (selfp->enabled)
	self_install_send_timeout(self);
    
#line 339 "lm-host.c"
		}
		break;
	case PROP_TIMEOUT:
		{
#line 107 "lm-host.gob"
self->_priv->timeout = g_value_get_uint (VAL);
#line 346 "lm-host.c"
		}
		break;
	case PROP_ALIVE:
		{
#line 117 "lm-host.gob"
self->_priv->alive = g_value_get_boolean (VAL);
#line 353 "lm-host.c"
		}
		break;
	case PROP_ROUNDTRIP_TIME:
		{
#line 129 "lm-host.gob"

      selfp->last_received = lm_time();
      if (selfp->dead_timeout_id)
	{
	  g_source_remove(selfp->dead_timeout_id);
	  selfp->dead_timeout_id = 0;
	}
      selfp->roundtrip_time = g_value_get_double(VAL);
      self_set_alive(self, TRUE);
      self_set_status(self, _("%.3f ms"), selfp->roundtrip_time);
    
#line 370 "lm-host.c"
		}
		break;
	case PROP_ERROR:
		{
#line 148 "lm-host.gob"

      if (selfp->dead_timeout_id)
	{
	  g_source_remove(selfp->dead_timeout_id);
	  selfp->dead_timeout_id = 0;
	}
      g_free(selfp->error);
      selfp->error = g_value_dup_string(VAL);
      self_set_alive(self, FALSE);
      self_set_status(self, "%s", selfp->error);
    
#line 387 "lm-host.c"
		}
		break;
	case PROP_STATUS:
		{
#line 178 "lm-host.gob"
{ char *old = self->_priv->status; self->_priv->status = g_value_dup_string (VAL); g_free (old); }
#line 394 "lm-host.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Host::get_property"
{
	LMHost *self G_GNUC_UNUSED;

	self = LM_HOST (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 63 "lm-host.gob"
g_value_set_string (VAL, self->_priv->name);
#line 425 "lm-host.c"
		}
		break;
	case PROP_IP:
		{
#line 75 "lm-host.gob"
g_value_set_string (VAL, self->_priv->ip);
#line 432 "lm-host.c"
		}
		break;
	case PROP_SEQ:
		{
#line 84 "lm-host.gob"
g_value_set_uint (VAL, self->_priv->seq);
#line 439 "lm-host.c"
		}
		break;
	case PROP_DELAY:
		{
#line 102 "lm-host.gob"

      g_value_set_uint(VAL, selfp->delay);
    
#line 448 "lm-host.c"
		}
		break;
	case PROP_TIMEOUT:
		{
#line 107 "lm-host.gob"
g_value_set_uint (VAL, self->_priv->timeout);
#line 455 "lm-host.c"
		}
		break;
	case PROP_ALIVE:
		{
#line 117 "lm-host.gob"
g_value_set_boolean (VAL, self->_priv->alive);
#line 462 "lm-host.c"
		}
		break;
	case PROP_ROUNDTRIP_TIME:
		{
#line 141 "lm-host.gob"

      g_value_set_double(VAL, selfp->roundtrip_time);
    
#line 471 "lm-host.c"
		}
		break;
	case PROP_ERROR:
		{
#line 160 "lm-host.gob"

      g_value_set_string(VAL, selfp->error);
    
#line 480 "lm-host.c"
		}
		break;
	case PROP_STATUS:
		{
#line 178 "lm-host.gob"
g_value_set_string (VAL, self->_priv->status);
#line 487 "lm-host.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 66 "lm-host.gob"
const char * 
lm_host_get_name (LMHost * self)
#line 507 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_name"
#line 66 "lm-host.gob"
	g_return_val_if_fail (self != NULL, (const char * )0);
#line 66 "lm-host.gob"
	g_return_val_if_fail (LM_IS_HOST (self), (const char * )0);
#line 514 "lm-host.c"
{
#line 68 "lm-host.gob"
	
    return selfp->name;
  }}
#line 520 "lm-host.c"
#undef __GOB_FUNCTION__

#line 77 "lm-host.gob"
const char * 
lm_host_get_ip (LMHost * self)
#line 526 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_ip"
#line 77 "lm-host.gob"
	g_return_val_if_fail (self != NULL, (const char * )0);
#line 77 "lm-host.gob"
	g_return_val_if_fail (LM_IS_HOST (self), (const char * )0);
#line 533 "lm-host.c"
{
#line 79 "lm-host.gob"
	
    return selfp->ip;
  }}
#line 539 "lm-host.c"
#undef __GOB_FUNCTION__

#line 84 "lm-host.gob"
guint 
lm_host_get_seq (LMHost * self)
#line 545 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_seq"
{
#line 84 "lm-host.gob"
		guint val; g_object_get (G_OBJECT (self), "seq", &val, NULL); return val;
}}
#line 552 "lm-host.c"
#undef __GOB_FUNCTION__

#line 84 "lm-host.gob"
void 
lm_host_set_seq (LMHost * self, guint val)
#line 558 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_seq"
{
#line 84 "lm-host.gob"
		g_object_set (G_OBJECT (self), "seq", val, NULL);
}}
#line 565 "lm-host.c"
#undef __GOB_FUNCTION__

#line 102 "lm-host.gob"
guint 
lm_host_get_delay (LMHost * self)
#line 571 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_delay"
{
#line 90 "lm-host.gob"
		guint val; g_object_get (G_OBJECT (self), "delay", &val, NULL); return val;
}}
#line 578 "lm-host.c"
#undef __GOB_FUNCTION__

#line 96 "lm-host.gob"
void 
lm_host_set_delay (LMHost * self, guint val)
#line 584 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_delay"
{
#line 90 "lm-host.gob"
		g_object_set (G_OBJECT (self), "delay", val, NULL);
}}
#line 591 "lm-host.c"
#undef __GOB_FUNCTION__

#line 107 "lm-host.gob"
guint 
lm_host_get_timeout (LMHost * self)
#line 597 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_timeout"
{
#line 107 "lm-host.gob"
		guint val; g_object_get (G_OBJECT (self), "timeout", &val, NULL); return val;
}}
#line 604 "lm-host.c"
#undef __GOB_FUNCTION__

#line 107 "lm-host.gob"
void 
lm_host_set_timeout (LMHost * self, guint val)
#line 610 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_timeout"
{
#line 107 "lm-host.gob"
		g_object_set (G_OBJECT (self), "timeout", val, NULL);
}}
#line 617 "lm-host.c"
#undef __GOB_FUNCTION__

#line 117 "lm-host.gob"
gboolean 
lm_host_get_alive (LMHost * self)
#line 623 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_alive"
{
#line 117 "lm-host.gob"
		gboolean val; g_object_get (G_OBJECT (self), "alive", &val, NULL); return val;
}}
#line 630 "lm-host.c"
#undef __GOB_FUNCTION__

#line 117 "lm-host.gob"
void 
lm_host_set_alive (LMHost * self, gboolean val)
#line 636 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_alive"
{
#line 117 "lm-host.gob"
		g_object_set (G_OBJECT (self), "alive", val, NULL);
}}
#line 643 "lm-host.c"
#undef __GOB_FUNCTION__

#line 141 "lm-host.gob"
gdouble 
lm_host_get_roundtrip_time (LMHost * self)
#line 649 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_roundtrip_time"
{
#line 125 "lm-host.gob"
		gdouble val; g_object_get (G_OBJECT (self), "roundtrip_time", &val, NULL); return val;
}}
#line 656 "lm-host.c"
#undef __GOB_FUNCTION__

#line 129 "lm-host.gob"
void 
lm_host_set_roundtrip_time (LMHost * self, gdouble val)
#line 662 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_roundtrip_time"
{
#line 125 "lm-host.gob"
		g_object_set (G_OBJECT (self), "roundtrip_time", val, NULL);
}}
#line 669 "lm-host.c"
#undef __GOB_FUNCTION__

#line 163 "lm-host.gob"
void 
lm_host_set_error (LMHost * self, const char * error)
#line 675 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_error"
#line 163 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 163 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 163 "lm-host.gob"
	g_return_if_fail (error != NULL);
#line 684 "lm-host.c"
{
#line 165 "lm-host.gob"
	
    g_object_set(G_OBJECT(self), LM_HOST_PROP_ERROR((char *) error), NULL);
  }}
#line 690 "lm-host.c"
#undef __GOB_FUNCTION__

#line 168 "lm-host.gob"
const char * 
lm_host_get_error (LMHost * self)
#line 696 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_error"
#line 168 "lm-host.gob"
	g_return_val_if_fail (self != NULL, (const char * )0);
#line 168 "lm-host.gob"
	g_return_val_if_fail (LM_IS_HOST (self), (const char * )0);
#line 703 "lm-host.c"
{
#line 170 "lm-host.gob"
	
    return selfp->error;
  }}
#line 709 "lm-host.c"
#undef __GOB_FUNCTION__

#line 180 "lm-host.gob"
static void 
lm_host_set_status (LMHost * self, const char * format, ...)
#line 715 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_status"
#line 180 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 180 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 180 "lm-host.gob"
	g_return_if_fail (format != NULL);
#line 724 "lm-host.c"
{
#line 182 "lm-host.gob"
	
    va_list args;
    char *status;

    va_start(args, format);
    status = g_strdup_vprintf(format, args);
    va_end(args);

    g_object_set(G_OBJECT(self), LM_HOST_PROP_STATUS(status), NULL);
    g_free(status);
  }}
#line 738 "lm-host.c"
#undef __GOB_FUNCTION__

#line 193 "lm-host.gob"
const char * 
lm_host_get_status (LMHost * self)
#line 744 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_status"
#line 193 "lm-host.gob"
	g_return_val_if_fail (self != NULL, (const char * )0);
#line 193 "lm-host.gob"
	g_return_val_if_fail (LM_IS_HOST (self), (const char * )0);
#line 751 "lm-host.c"
{
#line 195 "lm-host.gob"
	
    return selfp->status;
  }}
#line 757 "lm-host.c"
#undef __GOB_FUNCTION__

#line 199 "lm-host.gob"
static void 
___11_lm_host_finalize (GObject * object G_GNUC_UNUSED)
#line 763 "lm-host.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "LM:Host::finalize"
#line 199 "lm-host.gob"
	g_return_if_fail (object != NULL);
#line 199 "lm-host.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 773 "lm-host.c"
{
#line 201 "lm-host.gob"
	
    Self *self = SELF(object);

    if (selfp->send_timeout_id)
      g_source_remove(selfp->send_timeout_id);
    if (selfp->dead_timeout_id)
      g_source_remove(selfp->dead_timeout_id);

    PARENT_HANDLER(object);
  }}
#line 786 "lm-host.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 212 "lm-host.gob"
static GObject * 
___12_lm_host_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 793 "lm-host.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "LM:Host::constructor"
{
#line 214 "lm-host.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    g_object_ref(self);
    lm_thread_create(self_constructor_thread_cb, self);

    return object;
  }}
#line 814 "lm-host.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 227 "lm-host.gob"
static gpointer 
lm_host_constructor_thread_cb (gpointer data)
#line 821 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::constructor_thread_cb"
#line 227 "lm-host.gob"
	g_return_val_if_fail (data != NULL, (gpointer )0);
#line 826 "lm-host.c"
{
#line 229 "lm-host.gob"
	
    Self *self = data;
    struct addrinfo hints;
    int status;
    
    /*
     * For design simplicity we don't use our own LMHost mutex;
     * rather, we run every non-blocking operation with the GDK lock
     * held.
     *
     * The only LMHost member accessed outside of the lock is
     * selfp->addrinfo; we are sure it can not be accessed by multiple
     * threads concurrently.
     */

    GDK_THREADS_ENTER();
  
    self_set_status(self, _("resolving"));

    memset(&hints, 0, sizeof(hints));
#ifdef WITH_IPV6
    hints.ai_family = PF_UNSPEC;
#else
    hints.ai_family = PF_INET;
#endif /* WITH_IPV6 */
    hints.ai_socktype = SOCK_RAW;

    /*
     * A note on gdk_flush(): as adviced in the GDK threads
     * documentation, we only call gdk_flush() from a thread other
     * than our main thread.
     */
  
    gdk_flush();
    GDK_THREADS_LEAVE();

    status = getaddrinfo(selfp->name, NULL, &hints, &selfp->addrinfo);
  
    GDK_THREADS_ENTER();

    if (status == 0)
      {
	char ip[NI_MAXHOST];
	const LMSocket *s;

	gdk_flush();
	GDK_THREADS_LEAVE();

	status = getnameinfo(selfp->addrinfo->ai_addr,
			     selfp->addrinfo->ai_addrlen,
			     ip,
			     sizeof(ip),
			     NULL,
			     0,
			     NI_NUMERICHOST);
	
	GDK_THREADS_ENTER();

	if (status == 0)
	  selfp->ip = g_strdup(ip);
	
	s = lm_sockets_get_by_domain(selfp->addrinfo->ai_family);
	if (s)
	  {
	    if (! s->error)
	      {
		selfp->enabled = TRUE;
		self_set_status(self, _("starting"));
	      }
	    else
	      self_set_status(self, _("socket could not be initialized: %s"), s->error);
	  }
	else
	  self_set_status(self, _("unsupported address family"));
      }
    else
      self_set_status(self, _("unable to resolve: %s"), gai_strerror(status));

    if (selfp->enabled)
      {
	self_send_echo_request(self);		/* send first packet... */
	self_install_send_timeout(self);	/* ...and install send loop */
      }
    g_object_unref(self);

    gdk_flush();
    GDK_THREADS_LEAVE();

    return NULL;
  }}
#line 919 "lm-host.c"
#undef __GOB_FUNCTION__

#line 320 "lm-host.gob"
static void 
lm_host_send_echo_request (LMHost * self)
#line 925 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::send_echo_request"
#line 320 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 320 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 932 "lm-host.c"
{
#line 322 "lm-host.gob"
	
    GError *err = NULL;

    g_return_if_fail(selfp->enabled == TRUE);

    if (lm_icmp_send_echo_request(selfp->addrinfo, selfp->seq, &err))
      {
	selfp->last_sent = lm_time();
	if (! selfp->dead_timeout_id)
	  selfp->dead_timeout_id = g_timeout_add(selfp->timeout, self_dead_timeout_cb, self);
      }
    else
      {
	self_set_alive(self, FALSE);
	if (selfp->last_sent)
	  {
	    struct tm *timeptr;
	    char *date;
	    char *time;
	  
	    timeptr = localtime(&selfp->last_sent);
	    date = eel_strdup_strftime("%x", timeptr);
	    time = eel_strdup_strftime("%X", timeptr);
	    self_set_status(self, _("unable to send echo request: %s (last request successfully sent on %s at %s)"), err->message, date, time);
	    g_free(date);
	    g_free(time);
	  }
	else
	  self_set_status(self, _("unable to send echo request: %s"), err->message);
	g_error_free(err);
      }
  }}
#line 967 "lm-host.c"
#undef __GOB_FUNCTION__

#line 355 "lm-host.gob"
static void 
lm_host_install_send_timeout (LMHost * self)
#line 973 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::install_send_timeout"
#line 355 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 355 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 980 "lm-host.c"
{
#line 357 "lm-host.gob"
	
    g_return_if_fail(selfp->enabled == TRUE);

    if (selfp->send_timeout_id)
      {
	g_source_remove(selfp->send_timeout_id);
	selfp->send_timeout_id = 0;
      }
    selfp->send_timeout_id = g_timeout_add(selfp->delay, self_send_timeout_cb, self);
  }}
#line 993 "lm-host.c"
#undef __GOB_FUNCTION__

#line 368 "lm-host.gob"
static gboolean 
lm_host_send_timeout_cb (gpointer data)
#line 999 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::send_timeout_cb"
#line 368 "lm-host.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 1004 "lm-host.c"
{
#line 370 "lm-host.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();
    
    self_send_echo_request(self);
    
    GDK_THREADS_LEAVE();
    
    return TRUE;		/* keep source */
  }}
#line 1018 "lm-host.c"
#undef __GOB_FUNCTION__

#line 382 "lm-host.gob"
static gboolean 
lm_host_dead_timeout_cb (gpointer data)
#line 1024 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::dead_timeout_cb"
#line 382 "lm-host.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 1029 "lm-host.c"
{
#line 384 "lm-host.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();

    self_set_alive(self, FALSE);
    if (selfp->last_received)
      {
	struct tm *timeptr;
	char *date;
	char *time;

	timeptr = localtime(&selfp->last_received);
	date = eel_strdup_strftime("%x", timeptr);
	time = eel_strdup_strftime("%X", timeptr);
	self_set_status(self, _("last reply received on %s at %s"), date, time);
	g_free(date);
	g_free(time);
      }
    else
      self_set_status(self, _("no reply"));

    selfp->dead_timeout_id = 0;
    
    GDK_THREADS_LEAVE();
    
    return FALSE;		/* remove source */
  }}
#line 1060 "lm-host.c"
#undef __GOB_FUNCTION__

#line 413 "lm-host.gob"
LMHost * 
lm_host_new (const char * name, unsigned int seq, unsigned int delay, unsigned int timeout)
#line 1066 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::new"
#line 413 "lm-host.gob"
	g_return_val_if_fail (name != NULL, (LMHost * )0);
#line 1071 "lm-host.c"
{
#line 418 "lm-host.gob"
	
    return GET_NEW_VARG(LM_HOST_PROP_NAME((char *) name),
			LM_HOST_PROP_SEQ(seq),
			LM_HOST_PROP_DELAY(delay),
			LM_HOST_PROP_TIMEOUT(timeout),
			NULL);
  }}
#line 1081 "lm-host.c"
#undef __GOB_FUNCTION__
