/*
 * $Id: lm-util.h,v 1.8 2004/10/07 18:29:14 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LM_UTIL_H
#define _LM_UTIL_H

#include <stdarg.h>
#include <time.h>
#include <gtk/gtk.h>

#define LM_LIST_FOREACH(var, head)		\
for ((var) = (head);				\
     (var);					\
     (var) = (var)->next)

void lm_g_object_slist_free (GSList *list);
void lm_create_interface (const char *name, ...);
GdkPixbuf *lm_pixbuf_new (const char *filename);
void lm_thread_create (GThreadFunc func, gpointer data);
time_t lm_time (void);
void lm_tvsub (GTimeVal *out, const GTimeVal *in);
void lm_display_help (const char *link_id);
GtkWidget *lm_menu_shell_append (GtkMenuShell *shell,
				 const char *stock_id,
				 const char *mnemonic);
void lm_error_dialog (GtkWindow *parent,
		      const char *primary,
		      const char *format,
		      ...) G_GNUC_PRINTF(3, 4);
void lm_fatal_error_dialog (GtkWindow *parent,
			    const char *format,
			    ...) G_GNUC_PRINTF(2, 3);

#endif /* _LM_UTIL_H */
