# Copyright (C) 2004, 2005 Jean-Yves Lefort.
#
# This file is part of Link Monitor Applet.
# It may be distributed under the same terms as Link Monitor Applet.

dnl LM_ARG_COMPILE_WARNINGS
dnl
AC_DEFUN([LM_ARG_COMPILE_WARNINGS],
[AC_ARG_ENABLE(compile-warnings,
AC_HELP_STRING([--enable-compile-warnings=no|yes|error],
[enable compiler warnings [[no]]]),
[case "$enableval" in
	yes|no|error) enable_compile_warnings=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-compile-warnings]) ;;
esac], [enable_compile_warnings=no])

if test $enable_compile_warnings = no; then
	WARN_CFLAGS=
else
	# most flags are specific to GCC
	WARN_CFLAGS="-Wall \
-Wformat-y2k \
-Wformat-security \
-Wno-unused-parameter \
-Wfloat-equal \
-Wdeclaration-after-statement \
-Wendif-labels \
-Wpointer-arith \
-Wcast-align \
-Waggregate-return \
-Wmissing-noreturn \
-Wmissing-format-attribute \
-Wpacked \
-Wredundant-decls \
-Wnested-externs \
-Winline"
	test $enable_compile_warnings = error && WARN_CFLAGS="$WARN_CFLAGS -Werror"
fi

AC_SUBST(WARN_CFLAGS)])
