# This file is part of Link Monitor Applet
#
# Copyright (C) 2006 Jean-Yves Lefort.
#
# As a special exception to the Link Monitor Applet licensing terms,
# Jean-Yves Lefort gives unlimited permission to copy, distribute and
# modify this file.

dnl AC_GDK_PIXBUF_LOADER(SAMPLE_IMAGE, MIME_TYPE, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl
AC_DEFUN([AC_GDK_PIXBUF_LOADER],
[success=yes

PKG_CHECK_MODULES(GDK_PIXBUF, [gdk-pixbuf-2.0],, [success=no])

if test $success = yes; then
	ac_save_CFLAGS="$CFLAGS"
	ac_save_LIBS="$LIBS"
	CFLAGS="$CFLAGS $GDK_PIXBUF_CFLAGS"
	LIBS="$LIBS $GDK_PIXBUF_LIBS"

	AC_MSG_CHECKING([if GTK+ can load [$2] images])

	AC_RUN_IFELSE([
#include <gdk-pixbuf/gdk-pixbuf.h>

int main() {
  g_type_init();
  if (gdk_pixbuf_new_from_file("[$1]", NULL))
    exit(0);
  else
    exit(1);
}
],, [success=no])

	AC_MSG_RESULT([$success])

	CFLAGS="$ac_save_CFLAGS"
	LIBS="$ac_save_LIBS"
fi

if test $success = yes; then
	ifelse([$3],, :, [$3])
else
	ifelse([$4],, :, [$4])
fi])
