/*
 * Copyright (C) 2004-2006 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _LM_UTIL_H
#define _LM_UTIL_H

#include <stdarg.h>
#include <time.h>
#include <gtk/gtk.h>

#define LM_LIST_FOREACH(var, head) \
  for ((var) = (head); (var); (var) = (var)->next)

void lm_g_object_slist_free (GSList *list);
GSList *lm_g_object_slist_copy (GSList *list);

void lm_container_create_interface (GtkContainer *container,
				    const char *filename,
				    const char *child_name,
				    const char *callback_prefix,
				    ...);

GdkPixbuf *lm_pixbuf_new (const char *filename);

void lm_thread_create (GThreadFunc func, gpointer data);

time_t lm_time (void);

void lm_tvsub (GTimeVal *out, const GTimeVal *in);

void lm_display_help (const char *link_id);

GtkWidget *lm_menu_shell_append (GtkMenuShell *shell,
				 const char *stock_id,
				 const char *mnemonic);

void lm_error_dialog (GtkWindow *parent,
		      const char *primary,
		      const char *format,
		      ...) G_GNUC_PRINTF(3, 4);
void lm_fatal_error_dialog (GtkWindow *parent,
			    const char *format,
			    ...) G_GNUC_PRINTF(2, 3) G_GNUC_NORETURN;

void lm_source_clear (unsigned int *tag);

void lm_gtk_object_ref_and_sink (GtkObject *object);

gpointer lm_g_object_connect (gpointer object,
			      gpointer instance,
			      const char *signal_spec,
			      ...);

typedef void (*LMCallbackFunc) (gpointer data);

typedef struct
{
  unsigned int		idle_id;
  LMCallbackFunc	func;
  gpointer		data;
} LMCallback;

void lm_callback_init (LMCallback *callback, LMCallbackFunc func, gpointer data);
void lm_callback_queue (LMCallback *callback);
void lm_callback_clear (LMCallback *callback);

#endif /* _LM_UTIL_H */
