# Link Monitor Applet
# Copyright (C) 2004-2007 Jean-Yves Lefort <jylefort@brutele.be>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

### feature handling ##########################################################

dnl LM_FEATURE_VAR_NAME(FEATURE)
dnl
AC_DEFUN([LM_FEATURE_VAR_NAME], [enable_[]translit([$1], -, _)])

dnl LM_FEATURE_DISABLE_REASON_VAR_NAME(FEATURE)
dnl
AC_DEFUN([LM_FEATURE_DISABLE_REASON_VAR_NAME], [disable_[]translit([$1], -, _)_reason])

dnl LM_FEATURE_SYMBOL_NAME(FEATURE)
dnl
AC_DEFUN([LM_FEATURE_SYMBOL_NAME], [WITH_[]translit([$1], -a-z, _A-Z)])

dnl LM_FEATURE_ENABLED(FEATURE)
dnl
AC_DEFUN([LM_FEATURE_ENABLED], [test $LM_FEATURE_VAR_NAME([$1]) = yes])

dnl LM_FEATURE_DISABLED(FEATURE)
dnl
AC_DEFUN([LM_FEATURE_DISABLED], [test $LM_FEATURE_VAR_NAME([$1]) = no])

dnl LM_FEATURE_DISABLE(FEATURE, REASON)
dnl
AC_DEFUN([LM_FEATURE_DISABLE],
[AC_MSG_NOTICE([[$2]: forcing --disable-[$1]])
LM_FEATURE_VAR_NAME([$1])=no
LM_FEATURE_DISABLE_REASON_VAR_NAME([$1])="([$2])"])

dnl LM_FEATURE_DEFINE(FEATURE)
dnl
AC_DEFUN([LM_FEATURE_DEFINE],
[if LM_FEATURE_ENABLED([$1]); then _value=1; else _value=0; fi
AC_DEFINE_UNQUOTED(LM_FEATURE_SYMBOL_NAME([$1]), $_value, [Define to 1 if $1 is enabled, 0 otherwise])
])

dnl LM_FEATURES_DEFINE(FEATURES)
dnl
AC_DEFUN([LM_FEATURES_DEFINE], [m4_foreach(feature, [$1], [LM_FEATURE_DEFINE(feature)])])

### command line arguments ####################################################

dnl LM_ARG_ENABLE(FEATURE, DESCRIPTION, [DEFAULT])
dnl
AC_DEFUN([LM_ARG_ENABLE],
[AC_ARG_ENABLE([$1],
AS_HELP_STRING(--ifelse([$3], no, enable, disable)-[$1], $2),
[case "$enableval" in
	yes|no) LM_FEATURE_VAR_NAME([$1])=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-[$1]]) ;;
esac], [LM_FEATURE_VAR_NAME([$1])=ifelse([$3],, yes, [$3])])])

dnl LM_ARG_COMPILE_WARNINGS
dnl
AC_DEFUN([LM_ARG_COMPILE_WARNINGS],
[AC_ARG_ENABLE(compile-warnings,
AC_HELP_STRING([--enable-compile-warnings=no|yes|error],
[enable compiler warnings [[no]]]),
[case "$enableval" in
	yes|no|error) enable_compile_warnings=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-compile-warnings]) ;;
esac], [enable_compile_warnings=no])

if test $enable_compile_warnings = no; then
	WARN_CFLAGS=
else
	# most flags are specific to GCC
	WARN_CFLAGS="-Wall \
-Wformat-y2k \
-Wformat-security \
-Wno-unused-parameter \
-Wfloat-equal \
-Wdeclaration-after-statement \
-Wendif-labels \
-Wpointer-arith \
-Wcast-align \
-Waggregate-return \
-Wmissing-noreturn \
-Wmissing-format-attribute \
-Wpacked \
-Wredundant-decls \
-Wnested-externs \
-Winline"
	test $enable_compile_warnings = error && WARN_CFLAGS="$WARN_CFLAGS -Werror"
fi

AC_SUBST(WARN_CFLAGS)])

dnl LM_ARG_DEBUG
dnl
AC_DEFUN([LM_ARG_DEBUG],
[AC_ARG_ENABLE(debug,
AS_HELP_STRING([--enable-debug],
[enable assertions and cast checks]),
[case "$enableval" in
	yes|no) enable_debug=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-debug]) ;;
esac], [enable_debug=no])

if test $enable_debug = no; then
	DEBUG_CFLAGS="-DG_DISABLE_ASSERT -DG_DISABLE_CHECKS -DG_DISABLE_CAST_CHECKS"
else
	DEBUG_CFLAGS=
fi

AC_SUBST(DEBUG_CFLAGS)])

### report ####################################################################

dnl LM_REPORT(NAME, VALUE)
dnl
AC_DEFUN([LM_REPORT], [  m4_format([%-30s %s], [$1], [$2])])

dnl LM_REPORT_ARG(NAME)
dnl
AC_DEFUN([LM_REPORT_ARG], [LM_REPORT([--[$1]], [$translit([$1], -, _)])])

dnl LM_REPORT_ARGS(NAMES)
dnl
AC_DEFUN([LM_REPORT_ARGS], [m4_foreach(name, [$1], [LM_REPORT_ARG(name)
])])

dnl LM_REPORT_FEATURE(FEATURE)
dnl
AC_DEFUN([LM_REPORT_FEATURE],
[LM_REPORT([--enable-[$1]],
[$LM_FEATURE_VAR_NAME([$1]) $LM_FEATURE_DISABLE_REASON_VAR_NAME([$1])])])

dnl LM_REPORT_FEATURES(FEATURES)
dnl
AC_DEFUN([LM_REPORT_FEATURES], [m4_foreach(feature, [$1], [LM_REPORT_FEATURE(feature)
])])
