/*
 * Link Monitor Applet
 * Copyright (C) 2004-2007 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _LM_ICMP_H
#define _LM_ICMP_H

#include <stdint.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <glib.h>
#include "lm-shell.h"

typedef struct
{
  uint8_t	icmp_type;
  uint8_t	icmp_code;
  uint16_t	host_id;
  uint16_t	seq;
  GTimeVal	sent;
  GTimeVal	received;
} LMICMPReply;

gboolean lm_icmp_send_echo_request (const LMSocket *sock,
				    const struct addrinfo *addrinfo,
				    uint16_t host_id,
				    uint16_t seq,
				    GError **err);

gboolean lm_icmp_reply_get (const LMSocket *sock, LMICMPReply *reply);

gboolean lm_icmp_reply_is_echo_reply (const LMICMPReply *reply, int domain);
double lm_icmp_reply_get_roundtrip_time (const LMICMPReply *reply);
const char *lm_icmp_reply_get_description (const LMICMPReply *reply, int domain);

#endif /* _LM_ICMP_H */
