/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lm-shell.h"

#include "lm-shell-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 36 "lm-shell.gob"

#include "config.h"
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "lm-applet.h"
#include "lm-host.h"
#include "lm-util.h"

typedef struct
{
  LMShell		*self;
  const LMSocket	*sock;
} WatchInfo;

LMShell *lm_shell = NULL;

#line 46 "lm-shell.c"
/* self casting macros */
#define SELF(x) LM_SHELL(x)
#define SELF_CONST(x) LM_SHELL_CONST(x)
#define IS_SELF(x) LM_IS_SHELL(x)
#define TYPE_SELF LM_TYPE_SHELL
#define SELF_CLASS(x) LM_SHELL_CLASS(x)

#define SELF_GET_CLASS(x) LM_SHELL_GET_CLASS(x)

/* self typedefs */
typedef LMShell Self;
typedef LMShellClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lm_shell_init (LMShell * o) G_GNUC_UNUSED;
static void lm_shell_class_init (LMShellClass * c) G_GNUC_UNUSED;
static GObject * ___1_lm_shell_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void lm_shell_init_socket (LMShell * self, LMSocket * sock) G_GNUC_UNUSED;
static gboolean lm_shell_socket_watch_cb (GIOChannel * source, GIOCondition condition, gpointer data) G_GNUC_UNUSED;
static LMHost * lm_shell_get_host (LMShell * self, unsigned int host_id) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_SOCKETS
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_init_socket lm_shell_init_socket
#define self_socket_watch_cb lm_shell_socket_watch_cb
#define self_get_host lm_shell_get_host
#define self_get_unique_host_id lm_shell_get_unique_host_id
#define self_get_socket lm_shell_get_socket
#define self_new lm_shell_new
GType
lm_shell_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMShellClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_shell_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMShell),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_shell_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LMShell", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMShell *)g_object_new(lm_shell_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMShell * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMShell *
GET_NEW_VARG (const char *first, ...)
{
	LMShell *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMShell *)g_object_new_valist (lm_shell_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Shell::finalize"
	LMShell *self G_GNUC_UNUSED = LM_SHELL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
lm_shell_init (LMShell * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Shell::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_SHELL,LMShellPrivate);
}
#undef __GOB_FUNCTION__
static void 
lm_shell_class_init (LMShellClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Shell::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LMShellPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 66 "lm-shell.gob"
	g_object_class->constructor = ___1_lm_shell_constructor;
#line 158 "lm-shell.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("sockets" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SOCKETS,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Shell::set_property"
{
	LMShell *self G_GNUC_UNUSED;

	self = LM_SHELL (object);

	switch (property_id) {
	case PROP_SOCKETS:
		{
#line 61 "lm-shell.gob"
self->_priv->sockets = g_value_get_pointer (VAL);
#line 193 "lm-shell.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Shell::get_property"
{
	LMShell *self G_GNUC_UNUSED;

	self = LM_SHELL (object);

	switch (property_id) {
	case PROP_SOCKETS:
		{
#line 61 "lm-shell.gob"
g_value_set_pointer (VAL, self->_priv->sockets);
#line 224 "lm-shell.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 66 "lm-shell.gob"
static GObject * 
___1_lm_shell_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 244 "lm-shell.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "LM:Shell::constructor"
{
#line 68 "lm-shell.gob"
	
    GObject *object;
    Self *self;
    GSList *l;

    g_assert(lm_shell == NULL);

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    lm_shell = self;
    eel_add_weak_pointer(&lm_shell);

    /* unique identifier for our ICMP packets */
    self->icmp_ident = getpid() & 0xffff;

    LM_LIST_FOREACH(l, selfp->sockets)
      self_init_socket(self, l->data);

    self->tooltips = lm_tooltips_new();

    return object;
  }}
#line 276 "lm-shell.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 92 "lm-shell.gob"
static void 
lm_shell_init_socket (LMShell * self, LMSocket * sock)
#line 283 "lm-shell.c"
{
#define __GOB_FUNCTION__ "LM:Shell::init_socket"
#line 92 "lm-shell.gob"
	g_return_if_fail (self != NULL);
#line 92 "lm-shell.gob"
	g_return_if_fail (LM_IS_SHELL (self));
#line 92 "lm-shell.gob"
	g_return_if_fail (sock != NULL);
#line 292 "lm-shell.c"
{
#line 94 "lm-shell.gob"
	
    if (! sock->init_error)
      {
	int flags;

	flags = fcntl(sock->desc, F_GETFL, 0);
	if (fcntl(sock->desc, F_SETFL, flags | O_NONBLOCK) < 0)
	  sock->init_error = g_strdup_printf(_("unable to set O_NONBLOCK flag: %s"), g_strerror(errno));
	else
	  {
	    GIOChannel *channel;
	    WatchInfo *info;

	    info = g_new0(WatchInfo, 1);
	    info->self = self;
	    info->sock = sock;

	    channel = g_io_channel_unix_new(sock->desc);
	    g_io_add_watch_full(channel, G_PRIORITY_HIGH, G_IO_IN, self_socket_watch_cb, info, NULL);
	  }
      }
  }}
#line 317 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 117 "lm-shell.gob"
static gboolean 
lm_shell_socket_watch_cb (GIOChannel * source, GIOCondition condition, gpointer data)
#line 323 "lm-shell.c"
{
#define __GOB_FUNCTION__ "LM:Shell::socket_watch_cb"
{
#line 119 "lm-shell.gob"
	
    WatchInfo *info = data;
    Self *self = info->self;
    LMICMPReply reply;

    if (lm_icmp_reply_get(info->sock, &reply))
      {
	LMHost *host;

	host = self_get_host(self, reply.host_id);
	if (host)
	  {
	    GDK_THREADS_ENTER();
	    lm_host_reply_received(host, &reply);
	    GDK_THREADS_LEAVE();
	  }
      }

    return TRUE;		/* keep source */
  }}
#line 348 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 140 "lm-shell.gob"
static LMHost * 
lm_shell_get_host (LMShell * self, unsigned int host_id)
#line 354 "lm-shell.c"
{
#define __GOB_FUNCTION__ "LM:Shell::get_host"
#line 140 "lm-shell.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 140 "lm-shell.gob"
	g_return_val_if_fail (LM_IS_SHELL (self), (LMHost * )0);
#line 361 "lm-shell.c"
{
#line 142 "lm-shell.gob"
	
    GSList *a;

    LM_LIST_FOREACH(a, self->applets)
      {
	LMApplet *applet = a->data;
	GSList *b;

	LM_LIST_FOREACH(b, applet->hosts)
	  {
	    LMHost *host = b->data;

	    if (host->host_id == host_id)
	      return host;
	  }
      }

    return NULL;
  }}
#line 383 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 162 "lm-shell.gob"
unsigned int 
lm_shell_get_unique_host_id (LMShell * self)
#line 389 "lm-shell.c"
{
#define __GOB_FUNCTION__ "LM:Shell::get_unique_host_id"
#line 162 "lm-shell.gob"
	g_return_val_if_fail (self != NULL, (unsigned int )0);
#line 162 "lm-shell.gob"
	g_return_val_if_fail (LM_IS_SHELL (self), (unsigned int )0);
#line 396 "lm-shell.c"
{
#line 164 "lm-shell.gob"
	
    unsigned int host_id = 0;

    while (self_get_host(self, host_id))
      host_id++;

    return host_id;
  }}
#line 407 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 173 "lm-shell.gob"
const LMSocket * 
lm_shell_get_socket (LMShell * self, int domain)
#line 413 "lm-shell.c"
{
#define __GOB_FUNCTION__ "LM:Shell::get_socket"
#line 173 "lm-shell.gob"
	g_return_val_if_fail (self != NULL, (const LMSocket * )0);
#line 173 "lm-shell.gob"
	g_return_val_if_fail (LM_IS_SHELL (self), (const LMSocket * )0);
#line 420 "lm-shell.c"
{
#line 175 "lm-shell.gob"
	
    GSList *l;

    LM_LIST_FOREACH(l, selfp->sockets)
      {
	const LMSocket *sock = l->data;

	if (sock->domain == domain)
	  return sock;
      }

    return NULL;
  }}
#line 436 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 189 "lm-shell.gob"
LMShell * 
lm_shell_new (GSList * sockets)
#line 442 "lm-shell.c"
{
#define __GOB_FUNCTION__ "LM:Shell::new"
{
#line 191 "lm-shell.gob"
	
    return GET_NEW_VARG(LM_SHELL_PROP_SOCKETS(sockets), NULL);
  }}
#line 450 "lm-shell.c"
#undef __GOB_FUNCTION__
