/***********************************************************************
Copyright (c) 2006-2012, Skype Limited. All rights reserved. 
Redistribution and use in source and binary forms, with or without 
modification, (subject to the limitations in the disclaimer below) 
are permitted provided that the following conditions are met:
- Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.
- Redistributions in binary form must reproduce the above copyright 
notice, this list of conditions and the following disclaimer in the 
documentation and/or other materials provided with the distribution.
- Neither the name of Skype Limited, nor the names of specific 
contributors, may be used to endorse or promote products derived from 
this software without specific prior written permission.
NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED 
BY THIS LICENSE. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
CONTRIBUTORS ''AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND 
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***********************************************************************/

/**********************************************/
/* This file has been automatically generated */
/*                                            */
/* ROM usage:  7.14 kB                        */
/**********************************************/

#include "SKP_Silk_tables_FLP.h"
#include "SKP_Silk_tables_NLSF_CB1_16.h"

const SKP_float SKP_Silk_NLSF_MSVQ_CB1_16_rates[ NLSF_MSVQ_CB1_16_VECTORS ] =
{
      1.78125000000000000000f,      3.06250000000000000000f,
      4.15625000000000000000f,      4.18750000000000000000f,
      4.31250000000000000000f,      4.50000000000000000000f,
      4.53125000000000000000f,      4.59375000000000000000f,
      4.75000000000000000000f,      5.53125000000000000000f,
      5.53125000000000000000f,      5.56250000000000000000f,
      5.65625000000000000000f,      5.71875000000000000000f,
      5.75000000000000000000f,      6.31250000000000000000f,
      6.43750000000000000000f,      6.71875000000000000000f,
      6.81250000000000000000f,      6.93750000000000000000f,
      7.09375000000000000000f,      7.09375000000000000000f,
      7.09375000000000000000f,      7.09375000000000000000f,
      7.09375000000000000000f,      7.09375000000000000000f,
      7.09375000000000000000f,      7.09375000000000000000f,
      7.09375000000000000000f,      7.09375000000000000000f,
      7.09375000000000000000f,      7.09375000000000000000f,
      1.18750000000000000000f,      2.71875000000000000000f,
      3.03125000000000000000f,      3.71875000000000000000f,
      4.00000000000000000000f,      4.21875000000000000000f,
      4.37500000000000000000f,      4.46875000000000000000f,
      1.25000000000000000000f,      2.53125000000000000000f,
      3.34375000000000000000f,      3.34375000000000000000f,
      4.03125000000000000000f,      4.18750000000000000000f,
      4.18750000000000000000f,      4.46875000000000000000f,
      0.96875000000000000000f,      3.40625000000000000000f,
      3.56250000000000000000f,      3.75000000000000000000f,
      4.00000000000000000000f,      4.06250000000000000000f,
      4.09375000000000000000f,      4.12500000000000000000f,
      1.34375000000000000000f,      1.90625000000000000000f,
      3.87500000000000000000f,      3.90625000000000000000f,
      4.12500000000000000000f,      4.25000000000000000000f,
      4.40625000000000000000f,      4.43750000000000000000f,
      0.93750000000000000000f,      3.43750000000000000000f,
      3.68750000000000000000f,      3.75000000000000000000f,
      4.03125000000000000000f,      4.09375000000000000000f,
      4.15625000000000000000f,      4.15625000000000000000f,
      0.96875000000000000000f,      3.37500000000000000000f,
      3.59375000000000000000f,      3.78125000000000000000f,
      3.87500000000000000000f,      4.06250000000000000000f,
      4.15625000000000000000f,      4.28125000000000000000f,
      1.25000000000000000000f,      3.06250000000000000000f,
      3.59375000000000000000f,      3.59375000000000000000f,
      3.62500000000000000000f,      3.65625000000000000000f,
      3.84375000000000000000f,      3.87500000000000000000f,
      1.56250000000000000000f,      2.90625000000000000000f,
      3.37500000000000000000f,      3.43750000000000000000f,
      3.50000000000000000000f,      3.50000000000000000000f,
      3.56250000000000000000f,      3.59375000000000000000f,
      2.28125000000000000000f,      2.96875000000000000000f,
      2.96875000000000000000f,      3.00000000000000000000f,
      3.00000000000000000000f,      3.28125000000000000000f,
      3.34375000000000000000f,      3.43750000000000000000f
};

const SKP_float SKP_Silk_NLSF_MSVQ_CB1_16_ndelta_min[ 16 + 1 ] =
{
      0.00451660156250000000f,
      0.00009155273437500000f,
      0.00183105468749999980f,
      0.00207519531250000000f,
      0.00357055664062500000f,
      0.00262451171875000000f,
      0.00369262695312500000f,
      0.00378417968750000000f,
      0.00463867187500000000f,
      0.00466918945312500000f,
      0.00631713867187499910f,
      0.00460815429687500000f,
      0.00686645507812500000f,
      0.00729370117187499910f,
      0.00384521484375000000f,
      0.00558471679687500000f,
      0.02416992187500000300f
};

const SKP_float SKP_Silk_NLSF_MSVQ_CB1_16[ 16 * NLSF_MSVQ_CB1_16_VECTORS ] =
{
      0.03994750976562499300f,      0.09338378906250000000f,
      0.15475463867187500000f,      0.21350097656250000000f,
      0.27551269531250000000f,      0.33380126953125000000f,
      0.39471435546875000000f,      0.45443725585937500000f,
      0.51675415039062500000f,      0.57537841796875000000f,
      0.63452148437500000000f,      0.69470214843750000000f,
      0.75540161132812500000f,      0.81356811523437500000f,
      0.87359619140625000000f,      0.93081665039062500000f,
      0.03857421875000000000f,      0.08377075195312498600f,
      0.14068603515625000000f,      0.19555664062500000000f,
      0.25286865234375000000f,      0.30648803710937500000f,
      0.36877441406250000000f,      0.43054199218750000000f,
      0.49188232421875006000f,      0.55429077148437500000f,
      0.61325073242187500000f,      0.67639160156250000000f,
      0.74047851562500000000f,      0.80310058593750000000f,
      0.86453247070312500000f,      0.92318725585937500000f,
      0.03186035156250000000f,      0.06347656250000000000f,
      0.11206054687500000000f,      0.15805053710937500000f,
      0.21789550781250003000f,      0.27770996093750000000f,
      0.33782958984375000000f,      0.39871215820312494000f,
      0.47067260742187500000f,      0.54290771484375000000f,
      0.60824584960937500000f,      0.67446899414062500000f,
      0.74127197265625000000f,      0.80447387695312500000f,
      0.86972045898437500000f,      0.92828369140625000000f,
      0.03451538085937500000f,      0.07556152343750000000f,
      0.13665771484375000000f,      0.18765258789062500000f,
      0.24114990234375000000f,      0.30136108398437500000f,
      0.36431884765624994000f,      0.42141723632812500000f,
      0.48428344726562500000f,      0.54107666015625000000f,
      0.60876464843750000000f,      0.66244506835937500000f,
      0.72512817382812500000f,      0.77926635742187500000f,
      0.83697509765625000000f,      0.88247680664062500000f,
      0.03173828125000000000f,      0.06115722656250000000f,
      0.12286376953125000000f,      0.18615722656250000000f,
      0.25732421875000000000f,      0.32025146484375000000f,
      0.38482666015625000000f,      0.44842529296875000000f,
      0.51260375976562500000f,      0.57296752929687500000f,
      0.63473510742187500000f,      0.69525146484375000000f,
      0.75598144531250000000f,      0.81427001953125000000f,
      0.87374877929687511000f,      0.93127441406250000000f,
      0.07049560546875000000f,      0.11633300781250001000f,
      0.18045043945312497000f,      0.24209594726562500000f,
      0.30618286132812500000f,      0.36257934570312500000f,
      0.42373657226562500000f,      0.48211669921875000000f,
      0.54171752929687500000f,      0.59741210937500000000f,
      0.65557861328125000000f,      0.71032714843750000000f,
      0.76773071289062500000f,      0.82427978515624989000f,
      0.87991333007812500000f,      0.93453979492187500000f,
      0.03826904296875000000f,      0.08688354492187500000f,
      0.15298461914062500000f,      0.20693969726562500000f,
      0.26324462890625000000f,      0.31646728515625000000f,
      0.38836669921875000000f,      0.44656372070312500000f,
      0.49685668945312494000f,      0.54479980468750000000f,
      0.60638427734375000000f,      0.65527343749999989000f,
      0.70196533203124989000f,      0.75161743164062500000f,
      0.81512451171875000000f,      0.85327148437500000000f,
      0.04479980468750000000f,      0.09335327148437500000f,
      0.15219116210937500000f,      0.21441650390625000000f,
      0.26675415039062500000f,      0.31774902343750000000f,
      0.37478637695312500000f,      0.42785644531250000000f,
      0.48736572265625000000f,      0.54086303710937500000f,
      0.59936523437500000000f,      0.65679931640625000000f,
      0.71630859375000000000f,      0.78311157226562500000f,
      0.85406494140625000000f,      0.92239379882812500000f,
      0.06625366210937500000f,      0.10882568359375000000f,
      0.17105102539062497000f,      0.22534179687500000000f,
      0.28698730468750000000f,      0.34240722656249994000f,
      0.39764404296875000000f,      0.45037841796875000000f,
      0.50924682617187500000f,      0.56204223632812500000f,
      0.62091064453125000000f,      0.67416381835937511000f,
      0.73410034179687489000f,      0.79992675781250000000f,
      0.86535644531250000000f,      0.92764282226562500000f,
      0.07351684570312500000f,      0.14270019531250000000f,
      0.23019409179687497000f,      0.29864501953125000000f,
      0.34848022460937500000f,      0.39474487304687500000f,
      0.43847656250000006000f,      0.47769165039062500000f,
      0.52996826171875000000f,      0.57809448242187500000f,
      0.63360595703125000000f,      0.68594360351562511000f,
      0.74584960937500000000f,      0.80343627929687500000f,
      0.86315917968750000000f,      0.92291259765625000000f,
      0.07183837890625000000f,      0.12884521484375000000f,
      0.20812988281250003000f,      0.27792358398437500000f,
      0.35388183593749994000f,      0.42523193359375000000f,
      0.48745727539062494000f,      0.53961181640625000000f,
      0.58465576171875000000f,      0.62612915039062500000f,
      0.67111206054687500000f,      0.71472167968750000000f,
      0.76837158203125000000f,      0.82202148437499989000f,
      0.87872314453125000000f,      0.93161010742187511000f,
      0.04037475585937500000f,      0.07366943359375000000f,
      0.12768554687500000000f,      0.18429565429687500000f,
      0.22991943359375000000f,      0.28680419921875000000f,
      0.33871459960937500000f,      0.39968872070312500000f,
      0.45162963867187500000f,      0.50204467773437500000f,
      0.56256103515625000000f,      0.63742065429687500000f,
      0.71685791015624989000f,      0.78851318359375011000f,
      0.85589599609374989000f,      0.92239379882812500000f,
      0.04153442382812500700f,      0.09896850585937500000f,
      0.18457031250000000000f,      0.25973510742187500000f,
      0.33572387695312500000f,      0.40115356445312500000f,
      0.45999145507812500000f,      0.50683593750000000000f,
      0.55316162109375000000f,      0.59146118164062500000f,
      0.63818359375000000000f,      0.68991088867187500000f,
      0.75256347656250011000f,      0.81384277343750000000f,
      0.87472534179687500000f,      0.93280029296875000000f,
      0.03710937500000000000f,      0.08081054687500000000f,
      0.18008422851562503000f,      0.25701904296875000000f,
      0.30630493164062500000f,      0.34866333007812500000f,
      0.39590454101562500000f,      0.44564819335937500000f,
      0.50921630859375000000f,      0.56762695312500000000f,
      0.62728881835937500000f,      0.68405151367187500000f,
      0.74615478515625000000f,      0.80200195312500000000f,
      0.86077880859375000000f,      0.91787719726562500000f,
      0.07376098632812500000f,      0.12353515625000000000f,
      0.19274902343750000000f,      0.25735473632812500000f,
      0.32073974609375000000f,      0.38931274414062494000f,
      0.45996093750000006000f,      0.52780151367187500000f,
      0.59732055664062500000f,      0.65621948242187489000f,
      0.71194458007812500000f,      0.75628662109375011000f,
      0.80062866210937489000f,      0.84500122070312500000f,
      0.89154052734375000000f,      0.94052124023437500000f,
      0.03088378906250000000f,      0.07156372070312500000f,
      0.15231323242187500000f,      0.22512817382812503000f,
      0.28884887695312500000f,      0.36364746093750000000f,
      0.43627929687500000000f,      0.50555419921875000000f,
      0.56982421875000000000f,      0.62695312500000000000f,
      0.68029785156250000000f,      0.72747802734375000000f,
      0.77560424804687511000f,      0.82550048828125011000f,
      0.88037109375000000000f,      0.93234252929687500000f,
      0.05911254882812500000f,      0.11270141601562500000f,
      0.19125366210937500000f,      0.24472045898437500000f,
      0.31652832031250000000f,      0.37213134765625000000f,
      0.43600463867187494000f,      0.47781372070312500000f,
      0.53195190429687500000f,      0.57568359375000000000f,
      0.63381958007812500000f,      0.67767333984375000000f,
      0.73355102539062500000f,      0.77706909179687489000f,
      0.83566284179687500000f,      0.87286376953125000000f,
      0.06008911132812500000f,      0.10086059570312500000f,
      0.15310668945312500000f,      0.20526123046875000000f,
      0.25558471679687500000f,      0.30496215820312500000f,
      0.35504150390625000000f,      0.40527343750000000000f,
      0.46014404296875000000f,      0.51119995117187500000f,
      0.56347656250000000000f,      0.61398315429687500000f,
      0.67013549804687500000f,      0.72808837890625000000f,
      0.80029296875000011000f,      0.89410400390625011000f,
      0.03656005859375000000f,      0.08078002929687500000f,
      0.16564941406250000000f,      0.22653198242187500000f,
      0.29830932617187500000f,      0.37094116210937500000f,
      0.44754028320312500000f,      0.49877929687500000000f,
      0.55300903320312500000f,      0.60394287109375000000f,
      0.65786743164062489000f,      0.69723510742187500000f,
      0.74719238281250011000f,      0.78558349609375000000f,
      0.84347534179687500000f,      0.87619018554687500000f,
      0.04992675781250000000f,      0.10232543945312500000f,
      0.16622924804687500000f,      0.23184204101562503000f,
      0.30020141601562500000f,      0.35543823242187500000f,
      0.42614746093750000000f,      0.48886108398437500000f,
      0.54510498046875000000f,      0.61389160156250000000f,
      0.68112182617187500000f,      0.73355102539062500000f,
      0.79241943359375000000f,      0.85711669921875011000f,
      0.91290283203125011000f,      0.95501708984375000000f,
      0.08166503906250000000f,      0.12527465820312500000f,
      0.19464111328125000000f,      0.25094604492187500000f,
      0.30694580078125000000f,      0.35244750976562500000f,
      0.39892578124999994000f,      0.44107055664062494000f,
      0.48693847656249994000f,      0.52963256835937500000f,
      0.57772827148437500000f,      0.62261962890625000000f,
      0.67697143554687500000f,      0.72888183593750000000f,
      0.78482055664062500000f,      0.84603881835937500000f,
      0.04190063476562500000f,      0.07913208007812500000f,
      0.13577270507812500000f,      0.17190551757812500000f,
      0.22277832031250000000f,      0.25711059570312500000f,
      0.28912353515625000000f,      0.33013916015625000000f,
      0.38967895507812500000f,      0.47979736328125006000f,
      0.57989501953125000000f,      0.65396118164062500000f,
      0.72271728515625000000f,      0.79113769531250000000f,
      0.85861206054687500000f,      0.92568969726562500000f,
      0.04870605468750000000f,      0.09713745117187500000f,
      0.16412353515625003000f,      0.21862792968750000000f,
      0.26458740234375000000f,      0.30838012695312500000f,
      0.35003662109375000000f,      0.39166259765625000000f,
      0.42697143554687500000f,      0.45904541015624994000f,
      0.50787353515625000000f,      0.54635620117187500000f,
      0.63351440429687500000f,      0.77157592773437500000f,
      0.84747314453125000000f,      0.92285156249999989000f,
      0.06216430664062500000f,      0.12167358398437500000f,
      0.19033813476562500000f,      0.24771118164062500000f,
      0.30377197265625000000f,      0.37368774414062500000f,
      0.43386840820312500000f,      0.48498535156250000000f,
      0.54244995117187500000f,      0.61383056640625000000f,
      0.68096923828125000000f,      0.79168701171875000000f,
      0.80276489257812500000f,      0.80819702148437500000f,
      0.81774902343750000000f,      0.87161254882812500000f,
      0.06655883789062500000f,      0.11773681640625000000f,
      0.17578125000000000000f,      0.24182128906250000000f,
      0.30642700195312500000f,      0.35330200195312500000f,
      0.42019653320312494000f,      0.47912597656250000000f,
      0.53189086914062500000f,      0.60665893554687500000f,
      0.71969604492187500000f,      0.74884033203125000000f,
      0.76940917968750000000f,      0.78408813476562511000f,
      0.87548828125000000000f,      0.93099975585937489000f,
      0.06079101562500000000f,      0.11846923828125000000f,
      0.19757080078125000000f,      0.24057006835937503000f,
      0.28628540039062500000f,      0.38671875000000006000f,
      0.43762207031250000000f,      0.47915649414062500000f,
      0.50836181640625000000f,      0.54418945312500000000f,
      0.63629150390625000000f,      0.69839477539062500000f,
      0.75308227539062511000f,      0.80740356445312500000f,
      0.86947631835937500000f,      0.92956542968750000000f,
      0.07296752929687500000f,      0.12170410156250000000f,
      0.16625976562500000000f,      0.22680664062500000000f,
      0.33612060546875000000f,      0.38388061523437500000f,
      0.40100097656250000000f,      0.43170166015625000000f,
      0.48516845703125006000f,      0.56738281250000000000f,
      0.64404296875000000000f,      0.70169067382812500000f,
      0.75296020507812500000f,      0.82965087890624989000f,
      0.85882568359375000000f,      0.90368652343750000000f,
      0.05227661132812500000f,      0.15570068359375000000f,
      0.21328735351562500000f,      0.23797607421875000000f,
      0.26458740234375000000f,      0.30853271484375000000f,
      0.38897705078125000000f,      0.45413208007812500000f,
      0.50991821289062500000f,      0.56173706054687500000f,
      0.61419677734375000000f,      0.67465209960937500000f,
      0.73794555664062500000f,      0.79949951171874989000f,
      0.86172485351562500000f,      0.91970825195312500000f,
      0.04919433593750000000f,      0.11038208007812500000f,
      0.18762207031250000000f,      0.25509643554687500000f,
      0.29223632812500000000f,      0.35180664062500006000f,
      0.45581054687500000000f,      0.54348754882812500000f,
      0.55807495117187500000f,      0.57156372070312500000f,
      0.57986450195312500000f,      0.64425659179687500000f,
      0.75167846679687500000f,      0.81164550781250000000f,
      0.87707519531250000000f,      0.93515014648437500000f,
      0.06915283203125000000f,      0.12719726562500000000f,
      0.23992919921875000000f,      0.29132080078125000000f,
      0.29351806640625000000f,      0.29611206054687500000f,
      0.30926513671875000000f,      0.42410278320312500000f,
      0.49636840820312500000f,      0.56250000000000000000f,
      0.62826538085937500000f,      0.68984985351562500000f,
      0.75543212890625000000f,      0.82379150390625000000f,
      0.88882446289062511000f,      0.94116210937500000000f,
      0.05615234375000000700f,      0.11953735351562501000f,
      0.19140625000000000000f,      0.23831176757812500000f,
      0.29644775390625000000f,      0.34906005859375000000f,
      0.42013549804687500000f,      0.48214721679687500000f,
      0.58728027343750000000f,      0.67053222656250000000f,
      0.70129394531250000000f,      0.70739746093750000000f,
      0.72396850585937489000f,      0.78277587890625000000f,
      0.88858032226562500000f,      0.94863891601562500000f,
      0.04449462890625000000f,      0.11022949218750000000f,
      0.18334960937500000000f,      0.22851562500000000000f,
      0.29989624023437500000f,      0.36294555664062500000f,
      0.42987060546875000000f,      0.48016357421875000000f,
      0.53222656250000000000f,      0.59616088867187500000f,
      0.68432617187500000000f,      0.75582885742187500000f,
      0.89251708984375000000f,      0.91333007812499989000f,
      0.93127441406250000000f,      0.94442749023437489000f,
     -0.00311279296875000000f,     -0.00369262695312500000f,
     -0.00094604492187500000f,     -0.00018310546875000000f,
      0.00015258789062500000f,     -0.00006103515625000000f,
      0.00024414062500000000f,     -0.00054931640625000000f,
     -0.00012207031250000000f,      0.00018310546875000000f,
      0.00042724609375000000f,     -0.00006103515625000000f,
     -0.00036621093750000000f,     -0.00048828125000000000f,
     -0.00036621093750000000f,     -0.00183105468749999980f,
     -0.00384521484375000000f,     -0.01077270507812500000f,
     -0.01751708984375000000f,     -0.02066040039062500000f,
     -0.02005004882812500000f,     -0.01882934570312500000f,
     -0.01519775390625000000f,     -0.01199340820312500000f,
     -0.01062011718750000000f,     -0.00845336914062500000f,
     -0.00686645507812500000f,     -0.00500488281250000000f,
     -0.00311279296875000000f,     -0.00213623046875000000f,
     -0.00094604492187500000f,      0.00100708007812500000f,
      0.00012207031250000000f,      0.01156616210937500000f,
      0.01181030273437500000f,      0.01681518554687500000f,
      0.01846313476562500000f,      0.01892089843750000000f,
      0.01623535156250000000f,      0.01470947265625000200f,
      0.01348876953125000000f,      0.01385498046875000000f,
      0.01174926757812500200f,      0.01058959960937500000f,
      0.00982666015625000000f,      0.00912475585937500000f,
      0.00811767578125000000f,      0.00610351562500000000f,
      0.03564453125000000000f,      0.02902221679687500000f,
      0.02050781250000000000f,      0.00750732421875000000f,
      0.00183105468749999980f,     -0.00491333007812500000f,
     -0.00790405273437500000f,     -0.00714111328125000000f,
     -0.00772094726562500000f,     -0.00860595703125000000f,
     -0.00619506835937500000f,     -0.00570678710937500090f,
     -0.00473022460937500000f,     -0.00537109374999999910f,
     -0.00604248046875000090f,     -0.00543212890625000000f,
      0.00030517578125000000f,      0.00518798828125000000f,
      0.01199340820312500000f,      0.01858520507812500000f,
      0.01693725585937500000f,      0.00634765625000000090f,
     -0.01007080078124999800f,     -0.01742553710937500000f,
     -0.02346801757812500000f,     -0.01931762695312500000f,
     -0.00973510742187500000f,     -0.00131225585937500000f,
      0.00289916992187500000f,      0.00320434570312500000f,
      0.00323486328125000000f,      0.00354003906250000000f,
     -0.00463867187500000000f,     -0.00427246093750000000f,
     -0.00381469726562499960f,      0.00015258789062500000f,
      0.00527954101562500000f,      0.00836181640625000000f,
      0.00805664062500000000f,      0.01010131835937500000f,
     -0.00112915039062500000f,     -0.00894165039062500000f,
     -0.01858520507812500000f,     -0.02398681640625000000f,
     -0.02926635742187500000f,     -0.02484130859375000300f,
     -0.01968383789062500000f,     -0.00726318359375000000f,
     -0.00277709960937500000f,      0.00109863281250000000f,
     -0.00033569335937499995f,     -0.00308227539062500000f,
     -0.00851440429687500000f,     -0.00692749023437500000f,
     -0.00122070312500000000f,      0.00274658203125000000f,
      0.01617431640625000000f,      0.02066040039062500000f,
      0.02716064453125000000f,      0.03369140625000000000f,
      0.03048706054687500000f,      0.02548217773437500000f,
      0.01721191406250000000f,      0.00900268554687500000f,
     -0.00854492187500000000f,     -0.01110839843750000000f,
     -0.01037597656250000000f,     -0.01010131835937500000f,
     -0.00866699218750000000f,      0.00878906250000000000f,
      0.02322387695312500000f,      0.02685546875000000000f,
      0.03015136718750000000f,      0.01913452148437500000f,
      0.00445556640625000000f,     -0.00689697265625000000f,
     -0.00619506835937500000f,     -0.00552368164062500000f,
     -0.00433349609375000000f,      0.00119018554687500000f,
      0.00073242187500000000f,     -0.00079345703125000011f,
     -0.00326538085937500000f,     -0.00280761718750000000f,
     -0.00491333007812500000f,     -0.00411987304687500000f,
     -0.00399780273437500000f,     -0.00268554687499999960f,
     -0.00488281250000000000f,     -0.00476074218750000000f,
     -0.00228881835937500000f,     -0.00131225585937500000f,
     -0.00109863281250000000f,     -0.00018310546875000000f,
     -0.00100708007812500000f,      0.00100708007812500000f,
     -0.00988769531250000000f,     -0.01266479492187500000f,
     -0.00329589843750000000f,      0.00378417968750000000f,
      0.00479125976562500000f,      0.00582885742187500000f,
      0.00619506835937500000f,      0.00601196289062499910f,
      0.00439453125000000000f,      0.00332641601562499960f,
      0.00463867187500000000f,      0.00537109374999999910f,
      0.00579833984375000000f,      0.00372314453125000000f,
      0.00308227539062500000f,      0.00485229492187500000f,
      0.02023315429687500000f,      0.02038574218750000000f,
      0.01464843749999999800f,      0.01220703125000000000f,
      0.01156616210937500000f,      0.01354980468750000000f,
      0.01361083984375000000f,      0.01397705078124999800f,
      0.01046752929687500200f,      0.01071166992187500000f,
      0.00946044921875000000f,      0.00695800781250000000f,
      0.00405883789062500000f,      0.00134277343749999980f,
      0.00228881835937500000f,      0.00192260742187500000f,
     -0.00256347656250000000f,      0.00119018554687500000f,
     -0.00088500976562500000f,      0.00106811523437500000f,
     -0.00286865234375000000f,     -0.00711059570312500000f,
     -0.00796508789062500000f,     -0.01080322265625000200f,
      0.00234985351562500000f,      0.00799560546875000000f,
     -0.00073242187500000000f,     -0.00442504882812500000f,
     -0.01016235351562500000f,     -0.01248168945312500000f,
     -0.01232910156250000000f,     -0.01821899414062500000f,
     -0.01489257812500000000f,     -0.00915527343750000000f,
      0.02777099609375000000f,      0.01806640625000000000f,
      0.01257324218750000000f,      0.00366210937499999960f,
      0.00396728515625000000f,     -0.00155639648437500000f,
     -0.00112915039062500000f,     -0.00234985351562500000f,
     -0.00524902343750000000f,     -0.00552368164062500000f,
     -0.00485229492187500000f,     -0.00451660156250000000f,
     -0.00219726562500000000f,     -0.00189208984375000000f,
      0.01556396484375000000f,      0.01574707031250000000f,
      0.00344848632812500000f,     -0.01785278320312500000f,
     -0.03280639648437500000f,     -0.02920532226562500000f,
     -0.01272583007812500000f,     -0.00595092773437500000f,
      0.00027465820312500000f,      0.00021362304687500000f,
     -0.00268554687499999960f,     -0.00527954101562500000f,
     -0.00277709960937500000f,      0.00164794921875000000f,
      0.00299072265625000000f,      0.00289916992187500000f,
     -0.00085449218750000000f,      0.00601196289062499910f,
     -0.01608276367187500000f,     -0.01895141601562500000f,
      0.00479125976562500000f,      0.00372314453125000000f,
     -0.00512695312500000000f,      0.00448608398437500000f,
      0.00942993164062500000f,      0.00915527343750000000f,
      0.01025390625000000000f,      0.00961303710937500000f,
      0.01208496093750000200f,      0.01245117187500000000f,
      0.01147460937500000000f,      0.00323486328125000000f,
     -0.00494384765625000000f,     -0.00518798828125000000f,
     -0.00961303710937500000f,      0.00299072265625000000f,
      0.02505493164062499700f,      0.02770996093750000000f,
      0.01739501953125000000f,     -0.00100708007812500000f,
     -0.00952148437500000000f,     -0.01733398437500000000f,
     -0.01745605468750000000f,     -0.01153564453125000000f,
     -0.00326538085937500000f,      0.00070190429687500000f,
      0.00476074218750000000f,      0.00283813476562499960f,
     -0.00393676757812500000f,     -0.00265502929687500000f,
      0.00061035156250000000f,     -0.00219726562500000000f,
     -0.00112915039062500000f,      0.00122070312500000000f,
      0.00064086914062500000f,      0.00082397460937500000f,
      0.00146484375000000000f,      0.00228881835937500000f,
      0.00234985351562500000f,      0.00198364257812500000f,
      0.00140380859375000000f,      0.00216674804687500000f,
      0.00201416015625000000f,      0.00143432617187500000f,
      0.00415039062500000000f,      0.01049804687500000000f,
      0.00720214843750000000f,      0.00982666015625000000f,
      0.00518798828125000000f,      0.00863647460937500000f,
      0.00820922851562500000f,      0.00888061523437500000f,
      0.00494384765625000000f,     -0.00131225585937500000f,
     -0.00622558593750000000f,     -0.00790405273437500000f,
     -0.00732421874999999910f,     -0.00930786132812500000f,
     -0.01068115234374999800f,     -0.00952148437500000000f,
      0.01364135742187499800f,      0.01062011718750000000f,
      0.01052856445312500000f,      0.00784301757812500000f,
      0.00216674804687500000f,     -0.00399780273437500000f,
     -0.00234985351562500000f,     -0.00579833984375000000f,
     -0.00616455078125000000f,     -0.00122070312500000000f,
      0.00106811523437500000f,      0.00405883789062500000f,
      0.00796508789062500000f,      0.01113891601562500000f,
      0.01336669921875000200f,      0.00924682617187500000f,
     -0.00024414062500000000f,      0.00067138671874999989f,
      0.00427246093750000000f,      0.00418090820312500000f,
     -0.00915527343750000000f,     -0.01956176757812500000f,
     -0.02331542968750000000f,     -0.00817871093750000000f,
     -0.00070190429687500000f,     -0.00076293945312500000f,
      0.00222778320312500000f,     -0.00494384765625000000f,
     -0.00457763671875000000f,     -0.00646972656250000000f,
     -0.00219726562500000000f,      0.00018310546875000000f,
      0.00119018554687500000f,      0.00238037109375000000f,
      0.00317382812500000040f,     -0.00283813476562499960f,
     -0.00939941406250000000f,     -0.00415039062500000000f,
      0.00357055664062500000f,     -0.00216674804687500000f,
     -0.01565551757812500000f,     -0.02502441406250000000f,
     -0.02136230468749999700f,     -0.01373291015625000000f,
     -0.00491333007812500000f,     -0.00070190429687500000f,
      0.00088500976562500000f,      0.00238037109375000000f,
      0.01028442382812500000f,      0.00323486328125000000f,
     -0.01239013671875000000f,     -0.02386474609375000000f,
     -0.00341796875000000000f,      0.00711059570312500000f,
      0.01168823242187499800f,      0.00189208984375000000f,
     -0.00384521484375000000f,      0.00018310546875000000f,
     -0.00234985351562500000f,     -0.00088500976562500000f,
     -0.00445556640625000000f,     -0.00375366210937500000f,
     -0.00155639648437500000f,     -0.00082397460937500000f,
     -0.00082397460937500000f,     -0.01162719726562500000f,
     -0.01956176757812500000f,      0.01226806640625000000f,
      0.01644897460937500000f,      0.00024414062500000000f,
     -0.00631713867187499910f,     -0.01116943359375000000f,
     -0.00109863281250000000f,     -0.00082397460937500000f,
     -0.00622558593750000000f,     -0.00692749023437500000f,
     -0.00723266601562500000f,     -0.00576782226562500000f,
     -0.00195312500000000000f,      0.00155639648437500000f,
     -0.00280761718750000000f,     -0.00418090820312500000f,
     -0.00857543945312500000f,      0.00189208984375000000f,
      0.00711059570312500000f,      0.00280761718750000000f,
      0.00451660156250000000f,      0.00897216796875000000f,
      0.01107788085937500200f,      0.01269531250000000200f,
      0.01721191406250000000f,      0.01907348632812500000f,
      0.01129150390625000000f,     -0.00109863281250000000f,
     -0.01431274414062499800f,     -0.01409912109375000000f,
      0.00311279296875000000f,      0.00512695312500000000f,
      0.00097656250000000000f,      0.00357055664062500000f,
     -0.00064086914062500000f,      0.00296020507812500000f,
      0.00424194335937500000f,      0.00271606445312500000f,
      0.00317382812500000040f,      0.00106811523437500000f,
      0.00012207031250000000f,      0.00250244140625000000f,
      0.00201416015625000000f,      0.00177001953125000000f,
      0.00222778320312500000f,      0.00283813476562499960f,
     -0.00231933593750000000f,     -0.00976562500000000000f,
     -0.00720214843750000000f,     -0.00576782226562500000f,
     -0.00619506835937500000f,     -0.00433349609375000000f,
     -0.00082397460937500000f,     -0.00222778320312500000f,
      0.00027465820312500000f,     -0.00027465820312500000f,
     -0.00076293945312500000f,      0.00036621093750000000f,
     -0.00045776367187499995f,      0.00012207031250000000f,
      0.00012207031250000000f,     -0.00152587890625000000f,
      0.00958251953125000000f,      0.00549316406250000000f,
      0.00494384765625000000f,     -0.00149536132812500000f,
      0.00607299804687500000f,     -0.00329589843750000000f,
     -0.00692749023437500000f,     -0.00201416015625000000f,
     -0.01364135742187499800f,     -0.00204467773437500000f,
     -0.00805664062500000000f,     -0.01202392578124999800f,
      0.00015258789062500000f,      0.00167846679687500000f,
     -0.00405883789062500000f,     -0.00537109374999999910f,
     -0.00354003906250000000f,     -0.00735473632812500090f,
      0.00830078125000000000f,      0.00332641601562499960f,
      0.00860595703125000000f,      0.00799560546875000000f,
      0.00585937500000000000f,     -0.00195312500000000000f,
     -0.01196289062500000000f,     -0.01568603515625000000f,
      0.00476074218750000000f,      0.00619506835937500000f,
      0.00469970703125000000f,      0.00219726562500000000f,
     -0.00103759765625000000f,     -0.00488281250000000000f,
     -0.00222778320312500000f,      0.00009155273437500000f,
     -0.00100708007812500000f,     -0.01315307617187500000f,
      0.00979614257812500000f,      0.00054931640625000000f,
     -0.01730346679687500000f,     -0.01800537109375000000f,
     -0.00329589843750000000f,      0.00268554687499999960f,
      0.00201416015625000000f,      0.00155639648437500000f,
     -0.00094604492187500000f,     -0.00588989257812500000f,
     -0.00140380859375000000f,      0.00198364257812500000f,
     -0.00088500976562500000f,     -0.00070190429687500000f,
      0.00656127929687500000f,     -0.00094604492187500000f,
      0.00308227539062500000f,     -0.00344848632812500000f,
      0.00097656250000000000f,      0.00927734375000000000f,
      0.00268554687499999960f,      0.00976562500000000000f,
      0.01367187500000000000f,      0.00015258789062500000f,
     -0.01339721679687500000f,     -0.01715087890625000000f,
     -0.01550292968750000000f,     -0.00411987304687500000f,
     -0.00039672851562500005f,     -0.00521850585937500000f,
     -0.00024414062500000000f,      0.00555419921875000000f,
     -0.00302124023437500040f,     -0.00552368164062500000f,
     -0.00454711914062500000f,      0.01147460937500000000f,
      0.01452636718750000000f,      0.00195312500000000000f,
     -0.01208496093750000200f,     -0.01989746093750000000f,
     -0.00457763671875000000f,      0.00537109374999999910f,
      0.00677490234375000000f,      0.00198364257812500000f,
     -0.01800537109375000000f,      0.02194213867187500300f,
      0.00827026367187500000f,      0.01217651367187500000f,
      0.00747680664062500000f,      0.00219726562500000000f,
     -0.00476074218750000000f,     -0.00463867187500000000f,
     -0.00537109374999999910f,      0.00180053710937500000f,
      0.00286865234375000000f,      0.00381469726562499960f,
     -0.00027465820312500000f,     -0.00021362304687500000f,
      0.00027465820312500000f,      0.00003051757812500000f,
     -0.00186157226562500000f,     -0.00354003906250000000f,
     -0.00250244140625000000f,      0.00003051757812500000f,
      0.00241088867187500000f,      0.00067138671874999989f,
     -0.00134277343749999980f,     -0.00045776367187499995f,
     -0.00146484375000000000f,     -0.00198364257812500000f,
     -0.00189208984375000000f,     -0.00308227539062500000f,
     -0.00311279296875000000f,     -0.00164794921875000000f,
     -0.00213623046875000000f,     -0.00238037109375000000f,
     -0.00244140625000000000f,     -0.00076293945312500000f,
      0.01214599609375000000f,      0.00216674804687500000f,
      0.00424194335937500000f,      0.00115966796875000000f,
      0.00274658203125000000f,      0.00592041015625000000f,
      0.00677490234375000000f,      0.00759887695312500000f,
      0.00503540039062499910f,      0.00286865234375000000f,
      0.00674438476562500000f,      0.00799560546875000000f,
      0.00497436523437500000f,      0.00277709960937500000f,
     -0.00628662109375000000f,      0.01748657226562500000f,
      0.00610351562500000000f,     -0.00875854492187500000f,
     -0.00448608398437500000f,      0.00015258789062500000f,
     -0.00054931640625000000f,     -0.00259399414062500000f,
     -0.00225830078125000000f,     -0.00381469726562499960f,
     -0.00265502929687500000f,      0.00259399414062500000f,
      0.00430297851562500000f,      0.00012207031250000000f,
     -0.00012207031250000000f,      0.00085449218750000000f,
      0.00714111328125000000f,      0.00146484375000000000f,
     -0.00457763671875000000f,     -0.00338745117187500000f,
     -0.01544189453125000000f,      0.00723266601562500000f,
     -0.00637817382812500090f,      0.01052856445312500000f,
      0.00286865234375000000f,     -0.00378417968750000000f,
      0.00234985351562500000f,      0.00369262695312500000f,
      0.00436401367187500000f,      0.00036621093750000000f,
     -0.00244140625000000000f,     -0.00146484375000000000f,
      0.00582885742187500000f,      0.00439453125000000000f,
     -0.00283813476562499960f,     -0.00198364257812500000f,
     -0.00460815429687500000f,     -0.01962280273437500000f,
      0.01327514648437500000f,      0.00323486328125000000f,
      0.00265502929687500000f,      0.00021362304687500000f,
      0.00198364257812500000f,      0.00311279296875000000f,
      0.00286865234375000000f,      0.00207519531250000000f,
      0.00015258789062500000f,      0.00302124023437500040f,
      0.00677490234375000000f,      0.00283813476562499960f,
      0.00286865234375000000f,      0.01083374023437500000f,
     -0.00039672851562500005f,     -0.00271606445312500000f,
     -0.00695800781250000000f,     -0.01535034179687500000f,
      0.00875854492187500000f,      0.00332641601562499960f,
      0.00329589843750000000f,      0.01370239257812500200f,
      0.00772094726562500000f,     -0.00088500976562500000f,
     -0.00332641601562499960f,     -0.00354003906250000000f,
      0.00045776367187499995f,     -0.00222778320312500000f,
     -0.00061035156250000000f,      0.00399780273437500000f,
     -0.00448608398437500000f,      0.00219726562500000000f,
      0.00180053710937500000f,     -0.00457763671875000000f,
     -0.01812744140625000000f,      0.00833129882812500000f,
      0.00964355468750000000f,      0.00402832031250000000f,
      0.00607299804687500000f,      0.00323486328125000000f,
      0.00604248046875000090f,      0.00646972656250000000f,
      0.00671386718750000000f,      0.00250244140625000000f,
      0.00137329101562500000f,     -0.00039672851562500005f,
      0.00680541992187500000f,      0.00418090820312500000f,
      0.00823974609375000000f,      0.00115966796875000000f,
      0.00769042968750000000f,      0.00411987304687500000f,
     -0.00540161132812500090f,     -0.00631713867187499910f,
     -0.01098632812500000000f,     -0.00311279296875000000f,
      0.01229858398437500000f,      0.01239013671875000000f,
     -0.00042724609375000000f,      0.00253295898437500040f,
      0.00195312500000000000f,      0.00155639648437500000f,
     -0.00021362304687500000f,     -0.00302124023437500040f,
     -0.00296020507812500000f,     -0.00268554687499999960f,
     -0.00378417968750000000f,     -0.00198364257812500000f,
      0.00128173828125000000f,      0.00097656250000000000f,
      0.00085449218750000000f,      0.00088500976562500000f,
      0.00036621093750000000f,      0.00061035156250000000f,
      0.00363159179687500000f,     -0.00079345703125000011f,
     -0.00646972656250000000f,     -0.00613403320312500000f,
      0.01138305664062500000f,      0.00765991210937500090f,
      0.00430297851562500000f,      0.00314331054687500000f,
      0.00109863281250000000f,     -0.00158691406250000020f,
      0.00201416015625000000f,      0.00054931640625000000f,
     -0.00018310546875000000f,     -0.00289916992187500000f,
     -0.00598144531250000000f,      0.00015258789062500000f,
      0.00299072265625000000f,     -0.00259399414062500000f,
     -0.00329589843750000000f,      0.00665283203124999910f,
     -0.00500488281250000000f,      0.00061035156250000000f,
      0.01086425781250000000f,      0.00524902343750000000f,
      0.00112915039062500000f,      0.00811767578125000000f,
      0.00070190429687500000f,      0.00341796875000000000f,
     -0.00073242187500000000f,     -0.00302124023437500040f,
     -0.00280761718750000000f,     -0.00543212890625000000f,
      0.00088500976562500000f,     -0.00848388671875000000f,
      0.01184082031250000000f,     -0.00183105468749999980f,
     -0.00671386718750000000f,      0.00915527343750000000f,
     -0.00039672851562500005f,      0.00469970703125000000f,
      0.00582885742187500000f,      0.00045776367187499995f,
     -0.00112915039062500000f,     -0.00335693359375000000f,
     -0.00466918945312500000f,     -0.00457763671875000000f,
     -0.00347900390625000000f,     -0.00021362304687500000f,
     -0.00286865234375000000f,     -0.00094604492187500000f,
     -0.00189208984375000000f,     -0.00540161132812500090f,
      0.00012207031250000000f,     -0.00213623046875000000f,
      0.00106811523437500000f,      0.01382446289062500000f,
      0.00448608398437500000f,     -0.00753784179687500000f,
     -0.01000976562500000000f,      0.00308227539062500000f,
      0.00061035156250000000f,     -0.00347900390625000000f,
      0.00448608398437500000f,      0.00329589843750000000f,
     -0.00363159179687500000f,     -0.00332641601562499960f,
     -0.00311279296875000000f,     -0.00726318359375000000f,
      0.00167846679687500000f,     -0.00311279296875000000f,
      0.00527954101562500000f,     -0.00271606445312500000f,
      0.00393676757812500000f,      0.00421142578125000000f,
     -0.01007080078124999800f,     -0.00488281250000000000f,
      0.01480102539062500000f,      0.00469970703125000000f,
     -0.00180053710937500000f,     -0.00518798828125000000f,
     -0.00061035156250000000f,     -0.00103759765625000000f,
     -0.00796508789062500000f,     -0.00122070312500000000f,
     -0.00393676757812500000f,      0.00234985351562500000f,
     -0.00256347656250000000f,      0.00210571289062500000f,
      0.00253295898437500040f,      0.00488281250000000000f,
      0.00515747070312500000f,      0.00192260742187500000f,
     -0.01574707031250000000f,      0.00091552734374999989f,
      0.01025390625000000000f,      0.00158691406250000020f,
     -0.00000000000000000000f,     -0.00158691406250000020f,
     -0.00378417968750000000f,      0.00482177734375000000f,
      0.00057983398437500000f,      0.00601196289062499910f,
     -0.00030517578125000000f,     -0.01144409179687500000f,
      0.01235961914062499800f,      0.00869750976562500000f,
      0.00347900390625000000f,     -0.01205444335937500000f,
     -0.00143432617187500000f,      0.00598144531250000000f,
      0.00189208984375000000f,      0.00265502929687500000f,
     -0.00323486328125000000f,     -0.00198364257812500000f,
     -0.00228881835937500000f,     -0.00210571289062500000f,
     -0.00039672851562500005f,      0.00103759765625000000f,
      0.00302124023437500040f,      0.00180053710937500000f,
      0.00253295898437500040f,      0.00299072265625000000f,
      0.00134277343749999980f,      0.00000000000000000000f,
      0.00073242187500000000f,      0.00054931640625000000f,
      0.00051879882812500000f,      0.00213623046875000000f,
     -0.00067138671874999989f,      0.00592041015625000000f,
      0.00634765625000000090f,      0.00439453125000000000f,
     -0.00241088867187500000f,     -0.00045776367187499995f,
      0.00097656250000000000f,     -0.00317382812500000040f,
     -0.00085449218750000000f,     -0.00320434570312500000f,
     -0.00567626953124999910f,     -0.00646972656250000000f,
     -0.00695800781250000000f,     -0.00241088867187500000f,
     -0.00231933593750000000f,      0.00155639648437500000f,
     -0.00216674804687500000f,      0.00219726562500000000f,
      0.00360107421875000000f,     -0.00103759765625000000f,
     -0.00009155273437500000f,     -0.00521850585937500000f,
      0.00015258789062500000f,      0.00006103515625000000f,
     -0.00329589843750000000f,     -0.00381469726562499960f,
      0.00189208984375000000f,     -0.00177001953125000000f,
      0.00177001953125000000f,     -0.00369262695312500000f,
      0.00222778320312500000f,     -0.01422119140625000000f,
      0.00280761718750000000f,      0.00192260742187500000f,
     -0.00286865234375000000f,     -0.00238037109375000000f,
     -0.00231933593750000000f,      0.00646972656250000000f,
      0.00109863281250000000f,     -0.00686645507812500000f,
     -0.00216674804687500000f,     -0.01080322265625000200f,
      0.00463867187500000000f,      0.00436401367187500000f,
     -0.00241088867187500000f,     -0.00750732421875000000f,
     -0.00155639648437500000f,     -0.00094604492187500000f,
     -0.00018310546875000000f,     -0.00823974609375000000f,
      0.00732421874999999910f,      0.00640869140625000000f,
      0.00091552734374999989f,     -0.00479125976562500000f,
     -0.00704956054687500000f,      0.00225830078125000000f,
     -0.00445556640625000000f,      0.00268554687499999960f,
     -0.00833129882812500000f,      0.00476074218750000000f,
      0.00280761718750000000f,      0.00170898437500000000f,
      0.00216674804687500000f,      0.00006103515625000000f,
      0.00970458984375000000f,      0.00500488281250000000f,
      0.00097656250000000000f,     -0.00335693359375000000f,
     -0.00106811523437500000f,     -0.00125122070312500000f,
     -0.00289916992187500000f,     -0.00323486328125000000f,
      0.00033569335937499995f,      0.00402832031250000000f,
     -0.00207519531250000000f,      0.00167846679687500000f,
      0.00375366210937500000f,     -0.00253295898437500040f,
     -0.00454711914062500000f,      0.00646972656250000000f,
      0.00402832031250000000f,      0.00000000000000000000f,
     -0.00592041015625000000f,      0.00167846679687500000f,
      0.00628662109375000000f,     -0.00329589843750000000f,
     -0.01077270507812500000f,      0.00881958007812500000f,
     -0.00595092773437500000f,      0.00003051757812500000f,
      0.00711059570312500000f,     -0.00067138671874999989f,
     -0.00183105468749999980f,      0.00061035156250000000f,
      0.00079345703125000011f,      0.00207519531250000000f,
      0.00506591796875000090f,      0.00082397460937500000f,
     -0.00177001953125000000f,      0.00396728515625000000f,
      0.00341796875000000000f,      0.00326538085937500000f,
      0.00082397460937500000f,     -0.00503540039062499910f,
      0.00350952148437500040f,     -0.00283813476562499960f,
     -0.00112915039062500000f,      0.00115966796875000000f,
      0.00253295898437500040f,      0.01473999023437500000f,
      0.00198364257812500000f,     -0.00698852539062499910f,
     -0.00039672851562500005f,      0.00479125976562500000f,
      0.00259399414062500000f,      0.00152587890625000000f,
      0.00415039062500000000f,      0.00030517578125000000f,
      0.00097656250000000000f,      0.00253295898437500040f,
      0.00250244140625000000f,      0.00167846679687500000f,
      0.00015258789062500000f,     -0.00027465820312500000f,
     -0.00158691406250000020f,     -0.00238037109375000000f,
     -0.00247192382812500000f,     -0.00155639648437500000f,
      0.00122070312500000000f,      0.00054931640625000000f,
     -0.00387573242187500000f,     -0.00683593750000000000f,
     -0.00125122070312500000f,      0.00161743164062500000f,
     -0.00640869140625000000f,     -0.00344848632812500000f,
      0.00073242187500000000f,     -0.00051879882812500000f,
     -0.00570678710937500090f,     -0.00271606445312500000f,
      0.00024414062500000000f,      0.00369262695312500000f,
      0.00253295898437500040f,      0.00234985351562500000f,
      0.00277709960937500000f,     -0.00225830078125000000f,
     -0.00106811523437500000f,     -0.00341796875000000000f,
     -0.00491333007812500000f,     -0.00527954101562500000f,
      0.00311279296875000000f,      0.00402832031250000000f,
     -0.00381469726562499960f,     -0.00186157226562500000f,
      0.00314331054687500000f,     -0.00793457031250000000f,
      0.00158691406250000020f,      0.00506591796875000090f,
     -0.00097656250000000000f,     -0.00476074218750000000f,
     -0.00265502929687500000f,     -0.00170898437500000000f,
      0.00183105468749999980f,     -0.00213623046875000000f,
     -0.00378417968750000000f,      0.00738525390625000000f,
      0.00347900390625000000f,     -0.00765991210937500090f,
     -0.00506591796875000090f,      0.00613403320312500000f,
      0.00387573242187500000f,      0.00085449218750000000f,
     -0.00033569335937499995f,      0.00070190429687500000f,
     -0.00244140625000000000f,     -0.00350952148437500040f,
     -0.00061035156250000000f,     -0.00155639648437500000f,
     -0.01062011718750000000f,      0.01037597656250000000f,
     -0.00103759765625000000f,      0.00405883789062500000f,
      0.00039672851562500005f,      0.00280761718750000000f,
     -0.00378417968750000000f,     -0.00415039062500000000f,
     -0.00366210937499999960f,     -0.00079345703125000011f,
     -0.00018310546875000000f,      0.00051879882812500000f,
      0.00085449218750000000f,      0.00064086914062500000f,
      0.00366210937499999960f,     -0.00512695312500000000f,
      0.00488281250000000000f,     -0.00106811523437500000f,
      0.00350952148437500040f,      0.00085449218750000000f,
      0.00027465820312500000f,      0.00021362304687500000f,
     -0.00170898437500000000f,      0.00119018554687500000f,
      0.00476074218750000000f,      0.00781250000000000000f,
     -0.00054931640625000000f,      0.00003051757812500000f,
      0.00845336914062500000f,      0.00250244140625000000f,
     -0.00213623046875000000f,     -0.00439453125000000000f,
     -0.00268554687499999960f,     -0.00039672851562500005f,
     -0.00180053710937500000f,     -0.00479125976562500000f,
      0.00024414062500000000f,     -0.00408935546875000000f,
      0.00064086914062500000f,     -0.00122070312500000000f,
      0.00177001953125000000f,     -0.00064086914062500000f,
      0.00592041015625000000f,     -0.00842285156250000000f,
      0.00296020507812500000f,      0.00851440429687500000f,
     -0.00170898437500000000f,     -0.00427246093750000000f,
      0.00381469726562499960f,      0.00173950195312500000f,
     -0.00561523437500000000f,     -0.00622558593750000000f,
     -0.00213623046875000000f,     -0.00006103515625000000f,
      0.00390625000000000000f,     -0.00616455078125000000f,
     -0.00238037109375000000f,      0.00701904296875000090f,
     -0.00070190429687500000f,      0.00491333007812500000f,
     -0.00311279296875000000f,      0.00003051757812500000f,
      0.00003051757812500000f,      0.00549316406250000000f,
     -0.00094604492187500000f,     -0.00262451171875000000f,
     -0.00509643554687500000f,     -0.00173950195312500000f,
     -0.00183105468749999980f,      0.00082397460937500000f,
     -0.00039672851562500005f,      0.00302124023437500040f,
      0.00329589843750000000f,      0.00338745117187500000f,
      0.00231933593750000000f,      0.00210571289062500000f,
      0.00103759765625000000f,     -0.00064086914062500000f,
      0.00161743164062500000f,      0.00115966796875000000f,
      0.00103759765625000000f,      0.00238037109375000000f,
      0.00222778320312500000f,      0.00668334960937500090f,
      0.00155639648437500000f,      0.00045776367187499995f,
     -0.00219726562500000000f,     -0.00314331054687500000f,
     -0.00631713867187499910f,      0.00091552734374999989f,
      0.00650024414062500000f,     -0.00042724609375000000f,
      0.00094604492187500000f,     -0.00286865234375000000f,
     -0.00122070312500000000f,     -0.00439453125000000000f,
      0.00204467773437500000f,      0.00012207031250000000f,
      0.00320434570312500000f,      0.00180053710937500000f,
     -0.00732421874999999910f,      0.00076293945312500000f,
      0.00744628906250000000f,      0.00210571289062500000f,
      0.00177001953125000000f,      0.00070190429687500000f,
     -0.00073242187500000000f,     -0.00015258789062500000f,
     -0.00045776367187499995f,     -0.00405883789062500000f,
     -0.00216674804687500000f,     -0.00204467773437500000f,
      0.00552368164062500000f,      0.00088500976562500000f,
     -0.00137329101562500000f,      0.00369262695312500000f,
      0.00292968750000000000f,      0.00155639648437500000f,
     -0.00219726562500000000f,     -0.00161743164062500000f,
      0.00170898437500000000f,     -0.00466918945312500000f,
     -0.00082397460937500000f,      0.00259399414062500000f,
      0.00558471679687500000f,      0.00643920898437500000f,
      0.00320434570312500000f,     -0.00103759765625000000f,
     -0.00140380859375000000f,      0.00131225585937500000f,
     -0.00219726562500000000f,     -0.00283813476562499960f,
      0.00109863281250000000f,     -0.00390625000000000000f,
      0.00088500976562500000f,      0.00338745117187500000f,
     -0.00289916992187500000f,     -0.00476074218750000000f,
     -0.00546264648437500000f,     -0.00717163085937500000f,
      0.00064086914062500000f,     -0.00119018554687500000f,
     -0.00216674804687500000f,     -0.00100708007812500000f,
     -0.00186157226562500000f,     -0.00769042968750000000f,
      0.00701904296875000090f,     -0.00399780273437500000f,
      0.00479125976562500000f,     -0.00064086914062500000f,
     -0.00259399414062500000f,     -0.00085449218750000000f,
     -0.00375366210937500000f,      0.00244140625000000000f,
     -0.00488281250000000000f,      0.00192260742187500000f,
      0.00143432617187500000f,     -0.00018310546875000000f,
     -0.00149536132812500000f,     -0.00292968750000000000f,
     -0.00057983398437500000f,      0.00051879882812500000f,
     -0.00177001953125000000f,      0.00051879882812500000f,
     -0.00000000000000000000f,     -0.00039672851562500005f,
     -0.00518798828125000000f,      0.00076293945312500000f,
     -0.00106811523437500000f,      0.00180053710937500000f,
      0.00030517578125000000f,     -0.00094604492187500000f,
     -0.01260375976562500000f,      0.00247192382812500000f,
      0.00189208984375000000f,      0.00054931640625000000f,
     -0.00500488281250000000f,      0.00747680664062500000f,
      0.00280761718750000000f,     -0.00503540039062499910f,
      0.00128173828125000000f,      0.00079345703125000011f,
      0.00384521484375000000f,     -0.00756835937500000000f,
      0.00588989257812500000f,     -0.00167846679687500000f,
      0.00048828125000000000f,      0.00119018554687500000f,
      0.00042724609375000000f,      0.00152587890625000000f
};

const SKP_Silk_NLSF_CBS_FLP SKP_Silk_NLSF_CB1_16_Stage_info_FLP[ NLSF_MSVQ_CB1_16_STAGES ] =
{
        {  32, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *   0 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[   0 ] },
        {   8, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *  32 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[  32 ] },
        {   8, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *  40 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[  40 ] },
        {   8, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *  48 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[  48 ] },
        {   8, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *  56 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[  56 ] },
        {   8, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *  64 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[  64 ] },
        {   8, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *  72 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[  72 ] },
        {   8, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *  80 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[  80 ] },
        {   8, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *  88 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[  88 ] },
        {   8, &SKP_Silk_NLSF_MSVQ_CB1_16[ 16 *  96 ], &SKP_Silk_NLSF_MSVQ_CB1_16_rates[  96 ] }
};

const SKP_Silk_NLSF_CB_FLP SKP_Silk_NLSF_CB1_16_FLP =
{
        NLSF_MSVQ_CB1_16_STAGES,
        SKP_Silk_NLSF_CB1_16_Stage_info_FLP,
        SKP_Silk_NLSF_MSVQ_CB1_16_ndelta_min,
        SKP_Silk_NLSF_MSVQ_CB1_16_CDF,
        SKP_Silk_NLSF_MSVQ_CB1_16_CDF_start_ptr,
        SKP_Silk_NLSF_MSVQ_CB1_16_CDF_middle_idx
};

