/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : message.c                                        */
/* contenu       : gestion des messages pendant le jeu              */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>
#include <stdio.h>
#include <string.h>

#include "message.h"
#include "ticker.h"
#include "viewport.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

#define MESSAGE_MAX 12
#define MESSAGE_SIZE 64

static int MESSAGE_NB=0;
static char MESSAGE[MESSAGE_MAX][MESSAGE_SIZE+1];
static int MESSAGE_TICKER[MESSAGE_MAX];
static int MESSAGE_DISPLAYED[MESSAGE_MAX];
static int MESSAGE_DELAY=1000;

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
void clear_message (void)
{
 MESSAGE_NB=0;
}

/*------------------------------------------------------------------*/
void display_message (void)
{
 int i,h,j,new_ticker;

 new_ticker=get_ticker();
 for (i=0;i<MESSAGE_NB;++i)
     if (!MESSAGE_DISPLAYED[i])
        {
         MESSAGE_DISPLAYED[i]=1;
         MESSAGE_TICKER[i]=new_ticker+MESSAGE_DELAY*(i+1);
        }

 while (MESSAGE_NB>0
       && MESSAGE_DISPLAYED[0]
       && new_ticker>MESSAGE_TICKER[0])
    {
    for (i=0; i<MESSAGE_NB-1; ++i)
        for (j=0;j<MESSAGE_SIZE+1;++j)
            {
            MESSAGE[i][j]=MESSAGE[i+1][j];
            MESSAGE_TICKER[i]=MESSAGE_TICKER[i+1];
            }
    MESSAGE_NB--;
    }

 h=text_height (font);
 text_mode (-1);
 for (i=0;i<MESSAGE_NB;++i)
     textout (NEXT_SCREEN,font,MESSAGE[i],
             NEXT_SCREEN->w-text_length(font,MESSAGE[i]),
             NEXT_SCREEN->h-(MESSAGE_NB-i)*h,-1);
}

/*------------------------------------------------------------------*/
void message_str(char *str)
{
 int i,j;

 if (MESSAGE_NB==MESSAGE_MAX)
    {
    for (i=0; i<MESSAGE_NB-1; ++i)
        for (j=0;j<MESSAGE_SIZE+1;++j)
            {
            MESSAGE[i][j]=MESSAGE[i+1][j];
            MESSAGE_TICKER[i]=MESSAGE_TICKER[i+1]-MESSAGE_DELAY;
            }
    MESSAGE_NB--;
    }

 MESSAGE_DISPLAYED[MESSAGE_NB]=0;
 j=0;
 while (str[j] && j<MESSAGE_SIZE)
      {
       MESSAGE[MESSAGE_NB][j]=str[j];
       j++;
      }
 MESSAGE[MESSAGE_NB++][j]=0;
}

/*------------------------------------------------------------------*/
void message_int (int val)
{
 static char buffer[34];

 buffer[0]=0;
 sprintf (buffer,"%d",val);
 message_str (buffer);
}

/*------------------------------------------------------------------*/
void message_str_int (char *str, int val)
{
 int i,n;
 static char buf1[34];
 static char buf2[MESSAGE_SIZE+1];

 buf1[0]=0;
 sprintf (buf1,"%d",val);
 i=0;
 n=MESSAGE_SIZE-strlen(buf1);
 while (str[i] && i<n)
      {
       buf2[i]=str[i];
       i++;
      }
 buf2[i]=0;
 strcat (buf2,buf1);
 message_str (buf2);
}



