/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : volume.c                                         */
/* contenu       : reglage du volume du son                         */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "back.h"
#include "config.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "menu.h"
#include "sound.h"
#include "volume.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int sound_options (void)
{
  int *temp;
  DIALOG d[13];
  int i,choix=4,retour=0;
  static int y_pos[4]={0,2,4,5};

  for (i=0; i<4; ++i)
      {
       standard_button (d+i+4,0,y_pos[i],2,6);
       d[i+4].proc=my_textbox_proc;
      }
  for (i=0; i<4; ++i)
      {
       standard_button (d+i+8,1,y_pos[i],2,6);
       d[i+8].proc=my_slider_proc;
      }

  quick_buttons(d);

  d[4].dp="Sfx";
  d[5].dp="Click";
  d[6].dp="Game water";
  d[7].dp="Menu water";
  d[8].dp3=&CONFIG_SFX_VOLUME;
  d[9].dp3=&CONFIG_CLICK_VOLUME;
  d[10].dp3=&CONFIG_WATER_VOLUME_GAME;
  d[11].dp3=&WATER_VOLUME;
  for (i=8;i<12;++i)
      {
       d[i].d1=16;
       d[i].dp=NULL;
       d[i].dp2=slider_int;
       temp=d[i].dp3;
       d[i].d2=*temp;
      }
 
  d[12].proc=0;

  while (retour==0)
        {
          choix=my_do_dialog (d,choix);
          switch (choix)
            {
             case -1:
             case MENU_QUICK_BACK:
                  retour=1;
                  break;
             case MENU_QUICK_MAIN:
                  retour=MENU_TOP;
                  break;
             case MENU_QUICK_QUIT:
                  if (confirm_quit())
                    retour=MENU_EXIT;
                  else
                    display_back_image();
                  break;
             case MENU_QUICK_HELP:
                  retour=display_help (HELP_TEXT_SOUND);
                  display_back_image ();
                  break;
             }
        }

  CONFIG_WATER_VOLUME_MENU=WATER_VOLUME;

  if (retour>0)
    retour--;

 return retour;
}


