/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : liquidwarmap.c                                   */
/* contenu       : tools to generate tabs                           */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*=================================================================*/
/* includes                                                        */
/*=================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include <allegro.h>
#include <sys/stat.h>

/*=================================================================*/
/* variables globales                                              */
/*=================================================================*/

int   ARGC;
char  **ARGV;
int   FLAG_HELP=0;
int   FLAG_SILENT=0;
char  *FILENAMES[65536];
int   NUMBER_OF_FILES=0;
PALETTE PALETTE_SRC;
BITMAP *BITMAP_SRC=NULL;
BITMAP *BITMAP_DST=NULL;
signed char  BUFFER[1048576];
int   DST_X,DST_Y,DST_W,DST_H,DST_SIZE,BG_SIZE;

/*=================================================================*/
/* fonctions                                                       */
/*=================================================================*/

/*-----------------------------------------------------------------*/
/* affichages d'aide                                               */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
void display_common_help(void)
{
 printf ("liquidwarmap 1.0.0 by U-Foot. (ufoot@bigfoot.com)\n");
 printf ("This program creates maps for Liquid War.\n");
 printf ("It is free software, protected by the GPL.\n");
 printf ("It uses Allegro by Shawn Hargreaves.\n");
 printf ("\n");
}

/*-----------------------------------------------------------------*/
void display_short_help (void)
{
 display_common_help();
 printf ("Type \"liquidwarmap -?\" for more help.\n");
}

/*-----------------------------------------------------------------*/
void display_long_help (void)
{
 display_common_help();
 printf ("The source must be a 256 color bitmap.\n");
 printf ("Color 0=walls, the map must be contained in a closed rectangle.\n");
 printf ("Other colors ignored.\n");
 printf ("\n");
 printf ("Syntax:\n");
 printf ("liquidwarmap [options] filenames\n");
 printf ("\n");
 printf ("Options:\n");
 printf ("-? -h -H : displays this help.\n");
 printf ("-s -S :    silent mode, nothing written to the console.\n");
 printf ("\n");
 printf ("Remark: the created map will have a .map extension.\n");
 printf ("Warning: the source file will be replaced by a smaller file.\n");
}

/*-----------------------------------------------------------------*/
/* lecture des parametres de la ligne de commande                  */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
int acknowledge_flag (char *str)
{
 int found=0;

 if (str[0]=='-' || str[0]=='/')
    {
     found=1;
     switch (str[1])
     {
      case '?':
      case 'h':
      case 'H': FLAG_HELP=1;
                break;
      case 's':
      case 'S': FLAG_SILENT=1;
                break;
      default : found=0;
     }
    }
 return found;
}

/*-----------------------------------------------------------------*/
int read_command_line (void)
{
 int      i,j=0,success=1;

 for (i=1; i<ARGC; ++i)
     {
      if ((!acknowledge_flag (ARGV[i])))
         {
             FILENAMES[j]=ARGV[i];
          j++;
         }
     }
 NUMBER_OF_FILES=j;
 if (NUMBER_OF_FILES<=0)
     {
      success=0;
      if (!FLAG_HELP)
         printf ("ERROR! Two few arguments.\n");
     }
 return success;
}

/*-----------------------------------------------------------------*/
/* acces disque                                                    */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
int load_file (char *filename)
{
 int success;

 if (!FLAG_SILENT)
    printf ("Loading '%s'.\n", filename);

 if (BITMAP_SRC != NULL)
    destroy_bitmap (BITMAP_SRC);
 BITMAP_SRC=load_bitmap (filename, PALETTE_SRC);
 success=BITMAP_SRC!=NULL;
 if (!success)
    printf ("ERROR! Unable to read '%s'.\n", filename);
 return success;
}

/*-----------------------------------------------------------------*/
/* lecture des parametres du tableau                               */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
void get_range (void)
{
 int min_x=BITMAP_SRC->w;
 int min_y=BITMAP_SRC->h;
 int max_x=-1;
 int max_y=-1;
 int x,y;

 for (y=0;y<BITMAP_SRC->h;++y)
     for (x=0;x<BITMAP_SRC->w;++x)
         if (!getpixel (BITMAP_SRC,x,y))
            {
             if (min_x>x)
                min_x=x;
             if (min_y>y)
                min_y=y;
             if (max_x<x)
                max_x=x;
             if (max_y<y)
                max_y=y;
            }
 DST_X=min_x;
 DST_Y=min_y;
 DST_W=max_x-min_x+1;
 DST_H=max_y-min_y+1;

 if (DST_W<1 || DST_H<1)
    {
     printf ("ERROR! Map is too small.\n");
     DST_W=DST_H=1;
    }
 if (BITMAP_DST!=NULL)
    destroy_bitmap (BITMAP_DST);
 BITMAP_DST=create_bitmap (DST_W,DST_H);
 blit (BITMAP_SRC, BITMAP_DST, DST_X, DST_Y, 0, 0, DST_W, DST_H);
}

/*-----------------------------------------------------------------*/
/* conversion dans le buffer                                       */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
void convert_to_buffer (void)
{
 int pos_src,pos_dst,l,wh;
 char *data;

 wh=BITMAP_DST->h*BITMAP_DST->w;
 data=BITMAP_DST->dat;
 pos_src=pos_dst=0;
 BG_SIZE=0;

 while (pos_src<wh)
   {
   l=0;
   if (!data[pos_src])
      {
       while ((!data[pos_src]) && pos_src<wh && l<127)
         {
          l++;
          pos_src++;
         }
       BUFFER[pos_dst++]=l;
      }
   else
      {
       while (data[pos_src] && pos_src<wh && l<127)
         {
          l++;
          pos_src++;
         }
       BUFFER[pos_dst++]=-l;
       BG_SIZE+=l;
      }
   }
 BUFFER[pos_dst++]=0;

 DST_SIZE=pos_dst;
}

/*-----------------------------------------------------------------*/
/* on ecrit sur le disque                                          */
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
void change_ext (char *str)
{
  char *ext;

  ext=strchr (str, '.');
  ext[1]='m';
  ext[2]='a';
  ext[3]='p';
}

/*-----------------------------------------------------------------*/
void write_to_disk (char *str)
{
 FILE *f;
 short w,h;
 int size;

 if (!FLAG_SILENT)
    printf ("Writing %s to disk.\n",str);
 delete_file (str);
 f=fopen (str,"w");
 if (f!=NULL)
 {
    w=DST_W;
    h=DST_H;
    size=DST_SIZE;
    fwrite (&BG_SIZE,4,1,f);
    fwrite (&w,2,1,f);
    fwrite (&h,2,1,f);
    fwrite (BUFFER,DST_SIZE,1,f);
    fclose (f);
 }
 else
 {
  printf("Unable to write %s.\n",str);
 }
}

/*-----------------------------------------------------------------*/
void write_with_new_size (char *str)
{
 if (!FLAG_SILENT)
     printf ("Writing %s to disk.\n",str);
 delete_file (str);

 save_bitmap (str,BITMAP_DST,PALETTE_SRC);
}

/*=================================================================*/
/* fonctions main                                                  */
/*=================================================================*/

/*-----------------------------------------------------------------*/
int main (int argc, char **argv)
{
 int  i;

 ARGC=argc;
 ARGV=argv;

 allegro_init ();

 if (read_command_line ())
    {
     for (i=0; i<NUMBER_OF_FILES; ++i)
         {
          if (load_file (FILENAMES [i]))
             {
              get_range ();
              write_with_new_size(FILENAMES [i]);
              convert_to_buffer ();
              change_ext (FILENAMES [i]);
              write_to_disk (FILENAMES [i]);
              }
        }
    }
 else
     {
      if (FLAG_HELP)
         display_long_help ();
      else
          display_short_help ();
     }
 allegro_exit ();

 return 0;

}

#ifdef ALLEGRO_WINDOWS
END_OF_MAIN()
#endif

#ifdef ALLEGRO_UNIX
END_OF_MAIN();
#endif


